/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiProcessDeleteRequest;
import com.dingtalk.api.request.OapiProcessGetByNameRequest;
import com.dingtalk.api.request.OapiProcessSaveRequest;
import com.dingtalk.api.response.OapiProcessDeleteResponse;
import com.dingtalk.api.response.OapiProcessGetByNameResponse;
import com.dingtalk.api.response.OapiProcessSaveResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.AccessTokenUtils;
import kd.bos.message.service.utils.DingdingMessageUtils;
import kd.bos.message.service.utils.MessageUtils;
import kd.bos.util.RevProxyUtil;

public class DingdingTemplateUtils {
    private static Log logger = LogFactory.getLog(DingdingTemplateUtils.class);
    private static final String COMPONMENTNAME = "TextareaField";
    private static final String COMPONMENTID = "TextareaField-J78F056D";
    private static final String DINGDING = "dingding";

    public static JSONObject createTemplate(Long agentId, String accessToken, DingdingTodoInfo todoInfo) {
        logger.debug("DingdingTemplateUtils--createTemplate--\u521b\u5efa\u6a21\u677fbegin");
        OapiProcessSaveRequest.FormComponentVo multipleInput = new OapiProcessSaveRequest.FormComponentVo();
        multipleInput.setComponentName(COMPONMENTNAME);
        OapiProcessSaveRequest.FormComponentPropVo multipleInputProp = new OapiProcessSaveRequest.FormComponentPropVo();
        multipleInputProp.setRequired(Boolean.valueOf(false));
        multipleInputProp.setLabel(ResManager.loadKDString((String)"\u5ba1\u6279\u5185\u5bb9", (String)"DingdingTemplateUtils_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        multipleInputProp.setId(COMPONMENTID);
        multipleInput.setProps(multipleInputProp);
        ArrayList<OapiProcessSaveRequest.FormComponentVo> formComponentList = new ArrayList<OapiProcessSaveRequest.FormComponentVo>();
        formComponentList.add(multipleInput);
        OapiProcessSaveRequest.SaveProcessRequest saveProcessRequest = new OapiProcessSaveRequest.SaveProcessRequest();
        if (StringUtils.isNotBlank((CharSequence)todoInfo.getTplProcessCode())) {
            saveProcessRequest.setProcessCode(todoInfo.getTplProcessCode());
        }
        saveProcessRequest.setDisableFormEdit(Boolean.valueOf(true));
        saveProcessRequest.setFakeMode(Boolean.valueOf(true));
        saveProcessRequest.setAgentid(agentId);
        saveProcessRequest.setName(todoInfo.getTplName());
        saveProcessRequest.setDescription(todoInfo.getTplDescription());
        saveProcessRequest.setFormComponentList(formComponentList);
        OapiProcessSaveRequest request = new OapiProcessSaveRequest();
        request.setSaveProcessRequest(saveProcessRequest);
        OapiProcessSaveResponse response = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/save";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            response = (OapiProcessSaveResponse)client.execute((TaobaoRequest)request, accessToken);
            logger.debug("DingdingTemplateUtils--createTemplate--\u521b\u5efa\u6a21\u677f\u6210\u529f");
            resultJson = JSONObject.parseObject((String)response.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingTemplateUtils--createTemplate--\u521b\u5efa\u6a21\u677fapi\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put("errcode", (Object)"101");
            resultJson.put("errmsg", (Object)e.getMessage());
        }
        return resultJson;
    }

    public static JSONObject deleteTemplate(Long agentId, String accessToken, String processCode) {
        logger.debug("DingdingTemplateUtils--createTemplate--\u5220\u9664\u6a21\u677fbegin");
        OapiProcessDeleteRequest req = new OapiProcessDeleteRequest();
        OapiProcessDeleteRequest.DeleteProcessRequest obj1 = new OapiProcessDeleteRequest.DeleteProcessRequest();
        obj1.setAgentid(agentId);
        obj1.setProcessCode(processCode);
        req.setRequest(obj1);
        OapiProcessDeleteResponse rsp = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/delete";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            rsp = (OapiProcessDeleteResponse)client.execute((TaobaoRequest)req, accessToken);
            logger.debug("DingdingTemplateUtils--deleteTemplate--\u521b\u5efa\u6a21\u677f\u6210\u529f");
            resultJson = JSONObject.parseObject((String)rsp.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingTemplateUtils--deleteTemplate--\u521b\u5efa\u6a21\u677fapi\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put("errcode", (Object)"101");
            resultJson.put("errmsg", (Object)e.getMessage());
        }
        return resultJson;
    }

    public static Map<String, Object> getDingTplCode(String entityName) {
        logger.debug("get dingtpl code start");
        MsgChannelInfo dingCacheInfo = MsgServiceCache.getMsgChannel((String)DINGDING);
        if (dingCacheInfo == null) {
            return MessageUtils.wrapResult(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u9489\u9489\u670d\u52a1\uff0c\u8bf7\u5728\u7cfb\u7edf\u7ba1\u7406-\u6d88\u606f\u5e73\u53f0\u68c0\u67e5", (String)"DingdingHandler_0", (String)"bos-mservice-message", (Object[])new Object[0]));
        }
        String accessToken = AccessTokenUtils.getDinddingAccessToken(DINGDING, dingCacheInfo.getAppkey(), dingCacheInfo.getAppsecret(), null);
        if (StringUtils.isBlank((CharSequence)accessToken)) {
            return MessageUtils.wrapResult("accessToken is null, send messsgae is terminated");
        }
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/get_by_name";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            OapiProcessGetByNameRequest req = new OapiProcessGetByNameRequest();
            req.setName(entityName);
            OapiProcessGetByNameResponse rsp = (OapiProcessGetByNameResponse)client.execute((TaobaoRequest)req, accessToken);
            Map<String, Object> result = MessageUtils.wrapResult("success");
            logger.debug("getDingTplCode--getTplCode result\uff1a" + result.toString());
            result.put("tplCode", rsp.getBody());
            return result;
        }
        catch (Exception e) {
            return MessageUtils.wrapResult(e.getMessage());
        }
    }
}

