/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.utils;

import com.alibaba.fastjson.JSONObject;
import com.dingtalk.api.DefaultDingTalkClient;
import com.dingtalk.api.request.OapiProcessWorkrecordTaskCreateRequest;
import com.dingtalk.api.request.OapiProcessWorkrecordTaskUpdateRequest;
import com.dingtalk.api.request.OapiProcessWorkrecordTaskgroupCancelRequest;
import com.dingtalk.api.response.OapiProcessWorkrecordTaskCreateResponse;
import com.dingtalk.api.response.OapiProcessWorkrecordTaskUpdateResponse;
import com.dingtalk.api.response.OapiProcessWorkrecordTaskgroupCancelResponse;
import com.taobao.api.ApiException;
import com.taobao.api.TaobaoRequest;
import java.util.ArrayList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.DingdingTodoInfo;
import kd.bos.message.service.MessageServiceProperties;
import kd.bos.message.service.utils.DingdingMessageUtils;
import kd.bos.util.RevProxyUtil;

public class DingdingTodoUtils {
    private static Log logger = LogFactory.getLog(DingdingTodoUtils.class);
    private static final String ERRORCODE = "errcode";
    private static final String ERRORMSG = "errmsg";

    public static JSONObject createTodo(Long agentId, String accessToken, DingdingTodoInfo todoInfo) {
        logger.debug("DingdingTodoUtils--createTodo--\u521b\u5efa\u5f85\u529ebegin" + todoInfo);
        OapiProcessWorkrecordTaskCreateRequest.TaskTopVo obj4 = new OapiProcessWorkrecordTaskCreateRequest.TaskTopVo();
        obj4.setUserid(todoInfo.getUserId());
        obj4.setUrl(todoInfo.getTodoUrl());
        ArrayList<OapiProcessWorkrecordTaskCreateRequest.TaskTopVo> list3 = new ArrayList<OapiProcessWorkrecordTaskCreateRequest.TaskTopVo>();
        list3.add(obj4);
        OapiProcessWorkrecordTaskCreateRequest.SaveTaskRequest obj1 = new OapiProcessWorkrecordTaskCreateRequest.SaveTaskRequest();
        obj1.setAgentid(agentId);
        obj1.setProcessInstanceId(todoInfo.getProcessInstanceId());
        obj1.setTasks(list3);
        OapiProcessWorkrecordTaskCreateRequest req = new OapiProcessWorkrecordTaskCreateRequest();
        req.setRequest(obj1);
        OapiProcessWorkrecordTaskCreateResponse rsp = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/workrecord/task/create";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            rsp = (OapiProcessWorkrecordTaskCreateResponse)client.execute((TaobaoRequest)req, accessToken);
            logger.debug("DingdingTodoUtils--createTodo--\u521b\u5efa\u5f85\u529e\u6210\u529f");
            resultJson = JSONObject.parseObject((String)rsp.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingTodoUtils--createTodo--\u521b\u5efa\u5f85\u529eapi\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put(ERRORCODE, (Object)"101");
            resultJson.put(ERRORMSG, (Object)e.getMessage());
        }
        return resultJson;
    }

    public static JSONObject updateTodoStatus(Long agentId, String accessToken, String processInstanceId, Long taskId, String status, String result) {
        logger.debug("DingdingTodoUtils--updateTodoStatus--\u66f4\u65b0\u5f85\u529e\u72b6\u6001");
        OapiProcessWorkrecordTaskUpdateRequest.TaskTopVo obj4 = new OapiProcessWorkrecordTaskUpdateRequest.TaskTopVo();
        obj4.setTaskId(taskId);
        obj4.setStatus(status);
        obj4.setResult(result);
        ArrayList<OapiProcessWorkrecordTaskUpdateRequest.TaskTopVo> list3 = new ArrayList<OapiProcessWorkrecordTaskUpdateRequest.TaskTopVo>();
        list3.add(obj4);
        OapiProcessWorkrecordTaskUpdateRequest req = new OapiProcessWorkrecordTaskUpdateRequest();
        OapiProcessWorkrecordTaskUpdateRequest.UpdateTaskRequest obj1 = new OapiProcessWorkrecordTaskUpdateRequest.UpdateTaskRequest();
        obj1.setAgentid(agentId);
        obj1.setProcessInstanceId(processInstanceId);
        obj1.setTasks(list3);
        req.setRequest(obj1);
        OapiProcessWorkrecordTaskUpdateResponse rsp = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/workrecord/task/update";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            rsp = (OapiProcessWorkrecordTaskUpdateResponse)client.execute((TaobaoRequest)req, accessToken);
            logger.debug("DingdingTodoUtils--updateTodoStatus--\u66f4\u65b0\u5f85\u529e\u72b6\u6001\u6210\u529f");
            resultJson = JSONObject.parseObject((String)rsp.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingTodoUtils--updateTodoStatus--\u66f4\u65b0\u5f85\u529e\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put(ERRORCODE, (Object)"101");
            resultJson.put(ERRORMSG, (Object)e.getMessage());
        }
        return resultJson;
    }

    public static JSONObject cancleTodo(Long agentId, String accessToken, String processInstanceId, String activityId) {
        logger.debug("DingdingTodoUtils--cancleTodo--\u6279\u91cf\u66f4\u65b0\u5f85\u529e\u72b6\u6001begin");
        OapiProcessWorkrecordTaskgroupCancelRequest req = new OapiProcessWorkrecordTaskgroupCancelRequest();
        OapiProcessWorkrecordTaskgroupCancelRequest.UpdateTaskRequest obj1 = new OapiProcessWorkrecordTaskgroupCancelRequest.UpdateTaskRequest();
        obj1.setAgentid(agentId);
        obj1.setProcessInstanceId(processInstanceId);
        obj1.setActivityId(activityId);
        req.setRequest(obj1);
        OapiProcessWorkrecordTaskgroupCancelResponse rsp = null;
        JSONObject resultJson = new JSONObject();
        try {
            String ddDomain = MessageServiceProperties.ddDomain;
            String url = RevProxyUtil.addSlash((String)ddDomain) + "topapi/process/workrecord/taskgroup/cancel";
            DefaultDingTalkClient client = new DefaultDingTalkClient(DingdingMessageUtils.wrapDingdingUrl(url));
            rsp = (OapiProcessWorkrecordTaskgroupCancelResponse)client.execute((TaobaoRequest)req, accessToken);
            logger.debug("DingdingTodoUtils--cancleTodo--\u6279\u91cf\u66f4\u65b0\u5f85\u529e\u72b6\u6001\u6210\u529f");
            resultJson = JSONObject.parseObject((String)rsp.getBody());
        }
        catch (ApiException e) {
            logger.warn("DingdingTodoUtils--cancleTodo--\u6279\u91cf\u66f4\u65b0\u5f85\u529e\u629b\u51fa\u5f02\u5e38\uff0cmsg:" + e.getMessage());
            resultJson.put(ERRORCODE, (Object)"101");
            resultJson.put(ERRORMSG, (Object)e.getMessage());
        }
        return resultJson;
    }
}

