/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.message.service.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.inte.api.EnabledLang;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.SendMessageContext;
import kd.bos.message.channel.MessageChannelUtils;
import kd.bos.message.channel.cache.MsgServiceCache;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.message.channel.model.MsgChannelInfo;
import kd.bos.message.mutilLange.MessageMultilangageUtils;
import kd.bos.message.utils.MessageAttachmentUtils;
import kd.bos.message.utils.MessageUtils;
import kd.bos.message.utils.personalSetting.MessageBussinessInfo;
import kd.bos.message.utils.personalSetting.MessageBussinessPublishUtil;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.engine.msg.info.MessageAttachment;
import kd.bos.workflow.engine.msg.info.MessageInfo;

public class FailMessageUtil {
    private static Log logger = LogFactory.getLog(FailMessageUtil.class);
    private static final String USERIDS = "userids";
    private static final String CONFIG = "config";
    public static final String CHANNEL = "channel";
    private static final String PARAM = "param";
    private static final String EMAIL = "email";
    private static final String TPLSCENE = "tplscene";
    private static final String MESSAGEID = "messageid";
    private static final String SENDERNAME = "sendername";
    private static final String ENTITYNAME = "entityname";
    private static final String CREATEDATE = "createdate";
    private static final String TITLE = "title";
    private static final String CONTENT = "content";
    public static final String COMMONLANG = "commonlang";
    private static final String GLANG = "GLang";
    public static final String LANG = "lang";
    private static final String ATTACHMENTURLS = "attachmentUrls";
    private static final String TEMPLATE = "template";
    private static final String WF_MSG_FALILMESSAGE = "wf_msg_failmessage";
    private static final String RETRY = "retry";
    public static final String NORMAL = "normal";
    public static final String FAIL = "fail";
    public static final String SUCCESS = "success";
    private static final String ISSIGNLEEMAIL = "isSignleEmail";
    public static final String RUNTIMECONFIG = "runtimeconfig";
    private static final String MSGURL = "msgUrl";
    private static final String TRACEID = "traceId";
    public static final String USERFILTER = "userFilter";
    public static final String SYSTEMDISABLED = "systemDisabled";
    public static final String INTERNATIONAL_PHONE = "internationalPhoneNumbers";
    public static final String INTERNATIONAL_PHONE_USER = "internationalPhoneNumbersUsers";
    public static final String NOOPENID = "noOpenId";
    public static final String MSGVERIFYINFO = "msgVerifyInfo";
    public static final String SUCCESSSENDUSER = "successSendUser";
    public static final String SUCCESSSENDUSERINFO = "successSendUser";
    public static final String MSGTPLPARSE = "msgTplParser";
    public static final String TITLEPARSERESULT = "titleParseResult";
    public static final String CONTENTPARSERESULT = "contentParseResult";
    public static final String FAILREASON = "failReason";
    public static final String VARIABLES = "variables";
    public static final String DEALFAIL = "dealfail";
    public static final String NOSAVEMESSAGE = "noSaveMessage";
    public static final String BIZENTITYOBJECT = "bizEntityObject";

    public static Map<String, Object> getFailMessageById(Long failMsgId) {
        ArrayList<Long> failMsgIds = new ArrayList<Long>();
        failMsgIds.add(failMsgId);
        List<Map<String, Object>> failMsgDatas = FailMessageUtil.getFailMessageData(failMsgIds);
        HashMap<String, Object> failMessageInfo = null;
        if (failMsgDatas != null && failMsgDatas.size() > 0) {
            Object channelContent;
            DynamicObject tplObj;
            Object templateNumber;
            Map<String, Object> failMsgData = failMsgDatas.get(0);
            failMessageInfo = new HashMap(failMsgData.size());
            Object receiverIds = failMsgData.get(USERIDS);
            StringBuilder usernames = new StringBuilder();
            if (StringUtils.isNotBlank((Object)receiverIds)) {
                String[] receiverArray = ((String)receiverIds).split(",");
                ArrayList<Long> reIds = new ArrayList<Long>(receiverArray.length);
                for (String ra : receiverArray) {
                    reIds.add(Long.parseLong(ra));
                }
                DynamicObject[] userdoArray = BusinessDataServiceHelper.load((String)"bos_user", (String)"id, name", (QFilter[])new QFilter[]{new QFilter("id", "in", reIds)});
                if (userdoArray != null && userdoArray.length != 0) {
                    for (int i = 0; i < userdoArray.length; ++i) {
                        if (i == userdoArray.length - 1) {
                            usernames.append(userdoArray[i].getLocaleString("name").getLocaleValue());
                            continue;
                        }
                        usernames.append(userdoArray[i].getLocaleString("name").getLocaleValue()).append(",");
                    }
                }
            } else {
                Object configData = failMsgData.get(CONFIG);
                if (StringUtils.isNotBlank((Object)configData)) {
                    Map param = (Map)SerializationUtils.fromJsonString((String)((String)configData), Map.class);
                    String channel = (String)failMsgData.get(CHANNEL);
                    if ("sms".equals(channel)) {
                        failMessageInfo.put(PARAM, StringUtils.isBlank(param.get("phone")) ? "" : param.get("phone").toString());
                    } else if (EMAIL.equals(channel)) {
                        failMessageInfo.put(PARAM, StringUtils.isBlank(param.get(EMAIL)) ? "" : param.get(EMAIL).toString());
                    } else {
                        failMessageInfo.put(PARAM, param.toString());
                    }
                }
            }
            String tplScene = (String)failMsgData.get(TPLSCENE);
            DynamicObjectCollection typedo = QueryServiceHelper.query((String)"msg_type", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", failMsgData.get("type"))});
            if (StringUtils.isNotBlank((CharSequence)tplScene)) {
                DynamicObject scenedo = BusinessDataServiceHelper.loadSingle((String)"msg_tplscene", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tplScene)});
                failMessageInfo.put(TPLSCENE, scenedo == null ? "" : scenedo.getLocaleString("name").getLocaleValue());
            }
            if (StringUtils.isNotBlank((Object)(templateNumber = failMsgData.get(TEMPLATE))) && (tplObj = BusinessDataServiceHelper.loadSingle((String)"msg_template", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("number", "=", templateNumber)})) != null) {
                failMessageInfo.put("tpl", tplObj.getLocaleString("name"));
            }
            if ((channelContent = failMsgData.get("channelcontent")) != null && MessageUtils.isEmpty((ILocaleString)((ILocaleString)channelContent))) {
                channelContent = failMsgData.get(CONTENT);
            }
            failMessageInfo.put("id", failMsgData.get("id"));
            failMessageInfo.put(MESSAGEID, failMsgData.get(MESSAGEID));
            LocaleString senderName = FailMessageUtil.wrapLocalStringProperty(failMsgData.get(SENDERNAME));
            failMessageInfo.put(SENDERNAME, senderName.getLocaleValue());
            failMessageInfo.put("receiver", usernames);
            LocaleString entityName = FailMessageUtil.wrapLocalStringProperty(failMsgData.get(ENTITYNAME));
            failMessageInfo.put(ENTITYNAME, entityName.getLocaleValue());
            failMessageInfo.put("type", typedo != null && typedo.size() > 0 ? ((DynamicObject)typedo.get(0)).getString("name") : "");
            LocaleString channelName = FailMessageUtil.wrapLocalStringProperty(failMsgData.get("channelname"));
            failMessageInfo.put(CHANNEL, channelName.getLocaleValue());
            LocaleString messageTag = FailMessageUtil.wrapLocalStringProperty(failMsgData.get("tag"));
            failMessageInfo.put("tag", messageTag.getLocaleValue());
            failMessageInfo.put(CREATEDATE, failMsgData.get("modifydate"));
            LocaleString title = FailMessageUtil.wrapLocalStringProperty(failMsgData.get(TITLE));
            failMessageInfo.put(TITLE, FailMessageUtil.getGLang((ILocaleString)title));
            LocaleString content = FailMessageUtil.wrapLocalStringProperty(channelContent);
            failMessageInfo.put(CONTENT, FailMessageUtil.getGLang((ILocaleString)content));
            failMessageInfo.put("msgurl", failMsgData.get("mobcontenturl"));
            failMessageInfo.put("failreason", failMsgData.get("reason"));
            failMessageInfo.put(CONFIG, failMsgData.get(CONFIG));
            failMessageInfo.put(RUNTIMECONFIG, failMsgData.get(RUNTIMECONFIG));
            failMessageInfo.put("state", failMsgData.get("state"));
            failMessageInfo.put("toall", failMsgData.get("toall"));
        }
        return failMessageInfo == null ? new HashMap<String, Object>() : failMessageInfo;
    }

    public static List<Long> batchResendFailMessage(List<Long> failMsgIds, List<MessageInfo> failMsgInfos) {
        ArrayList<Long> successIds = new ArrayList<Long>();
        int batchCount = 100;
        int totalCount = failMsgIds == null ? failMsgInfos.size() : failMsgIds.size();
        int pageCount = totalCount % batchCount != 0 ? totalCount / batchCount + 1 : totalCount / batchCount;
        try {
            for (int i = 0; i < pageCount; ++i) {
                int endIndex;
                int startIndex = i * batchCount;
                int n = endIndex = (i + 1) * batchCount > totalCount ? totalCount : (i + 1) * batchCount;
                if (failMsgIds != null && failMsgIds.size() != 0) {
                    List<Long> msgIds = failMsgIds.subList(startIndex, endIndex);
                    FailMessageUtil.resendMsgByIds(msgIds, successIds);
                    continue;
                }
                List<MessageInfo> failMessageList = failMsgInfos.subList(startIndex, endIndex);
                FailMessageUtil.resendMsgByInfos(failMessageList, successIds);
            }
        }
        catch (Exception e) {
            logger.warn("batchResendFailMessage--exception:" + MessageUtils.getExceptionStacktrace((Throwable)e));
        }
        return successIds;
    }

    private static void resendMsgByIds(List<Long> msgIds, List<Long> successIds) {
        if (msgIds == null || msgIds.isEmpty()) {
            return;
        }
        List<Map<String, Object>> failMsgDatas = FailMessageUtil.getFailMessageData(msgIds);
        ArrayList<MessageInfo> failMessageList = new ArrayList<MessageInfo>();
        if (failMsgDatas != null && failMsgDatas.size() > 0) {
            for (int i = 0; i < failMsgDatas.size(); ++i) {
                Map<String, Object> failMsg = failMsgDatas.get(i);
                MessageInfo messageInfo = FailMessageUtil.wrapMessageInfo(failMsg);
                if (DEALFAIL.equals(failMsg.get("state"))) {
                    messageInfo.putParam("state", DEALFAIL);
                }
                failMessageList.add(messageInfo);
            }
            List<Long> ids = FailMessageUtil.sendFailMessage(failMessageList, Boolean.FALSE);
            successIds.addAll(ids);
        }
    }

    private static void resendMsgByInfos(List<MessageInfo> failMsgInfos, List<Long> successIds) {
        if (failMsgInfos == null || failMsgInfos.isEmpty()) {
            return;
        }
        List<Long> ids = FailMessageUtil.sendFailMessage(failMsgInfos, Boolean.TRUE);
        successIds.addAll(ids);
    }

    private static MessageInfo wrapMessageInfo(Map<String, Object> failMsg) {
        String runtimeConfig;
        Object channelContent;
        ArrayList<Long> userIdList = new ArrayList<Long>(1);
        Object uId = failMsg.get(USERIDS);
        if (StringUtils.isNotBlank((Object)uId)) {
            String[] userIdStr;
            for (String userId : userIdStr = ((String)uId).split(",")) {
                if (!StringUtils.isNotBlank((CharSequence)userId) || "null".equalsIgnoreCase(userId)) continue;
                userIdList.add(Long.valueOf(userId));
            }
        }
        if ((channelContent = failMsg.get("channelcontent")) != null && MessageUtils.isEmpty((ILocaleString)((ILocaleString)channelContent))) {
            channelContent = failMsg.get(CONTENT);
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setId((Long)failMsg.get(MESSAGEID));
        messageInfo.setChannelMsgId((Long)failMsg.get("id"));
        messageInfo.setUserIds(userIdList);
        messageInfo.setMessageTitle((ILocaleString)FailMessageUtil.wrapLocalStringProperty(failMsg.get(TITLE)));
        messageInfo.setMessageContent((ILocaleString)FailMessageUtil.wrapLocalStringProperty(channelContent));
        messageInfo.setSenderId(Long.valueOf(StringUtils.isNotBlank((Object)failMsg.get("sender")) ? Long.parseLong((String)failMsg.get("sender")) : 0L));
        messageInfo.setMessageSenderName((ILocaleString)FailMessageUtil.wrapLocalStringProperty(failMsg.get(SENDERNAME)));
        messageInfo.setContentUrl((String)failMsg.get("contenturl"));
        messageInfo.setMobContentUrl((String)failMsg.get("mobcontenturl"));
        messageInfo.setEntityNumber((String)failMsg.get("entitynumber"));
        messageInfo.setOperation((String)failMsg.get("operation"));
        messageInfo.setBizDataId(StringUtils.isNotBlank((Object)failMsg.get("bizdataid")) ? (Long)failMsg.get("bizdataid") : null);
        messageInfo.setMessageTag((ILocaleString)FailMessageUtil.wrapLocalStringProperty(failMsg.get("tag")));
        messageInfo.setSource((String)failMsg.get("source"));
        messageInfo.setPubaccNumber((String)failMsg.get("pubaccnumber"));
        messageInfo.setTplScene((String)failMsg.get(TPLSCENE));
        messageInfo.setNotifyType((String)failMsg.get(CHANNEL));
        Map params = null;
        String config = (String)failMsg.get(CONFIG);
        if (StringUtils.isNotBlank((CharSequence)config) && !"{}".equals(config)) {
            params = (Map)SerializationUtils.fromJsonString((String)config, Map.class);
        }
        if (params == null) {
            params = new HashMap();
        }
        if (StringUtils.isNotBlank((CharSequence)(runtimeConfig = (String)failMsg.get(RUNTIMECONFIG))) && !"{}".equals(runtimeConfig)) {
            Map runtimeParams = (Map)SerializationUtils.fromJsonString((String)runtimeConfig, Map.class);
            params.putAll(runtimeParams);
        }
        messageInfo.setParams(params);
        if (params.containsKey(ATTACHMENTURLS)) {
            MessageAttachmentUtils.downloadAttachmentData((MessageInfo)messageInfo);
        }
        if (params.containsKey(ISSIGNLEEMAIL)) {
            boolean signleEmail = (Boolean)params.get(ISSIGNLEEMAIL);
            messageInfo.setSignleEmail(signleEmail);
        }
        messageInfo.setTemplateNumber((String)failMsg.get(TEMPLATE));
        messageInfo.setToAll(((Boolean)failMsg.get("toall")).booleanValue());
        return messageInfo;
    }

    private static LocaleString wrapLocalStringProperty(Object property) {
        LocaleString ls = new LocaleString();
        if (property != null) {
            Map tmap = (Map)property;
            for (Map.Entry entry : tmap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                ls.setItem(key, (Object)((String)value));
            }
        }
        return ls;
    }

    private static List<Map<String, Object>> getFailMessageData(List<Long> failMsgIds) {
        ArrayList<Map<String, Object>> failMsgDatas = new ArrayList<Map<String, Object>>();
        String msgFailFields = "id,messageid,userids,tplscene,reason,pubaccnumber,channel,serviceclass,config,runtimeconfig,template,title,sendername,entityname,channelname,toall,modifydate,state,channelcontent";
        QFilter[] filter1s = new QFilter[]{new QFilter("id", "in", failMsgIds)};
        DynamicObject[] failMsgDos = BusinessDataServiceHelper.load((String)WF_MSG_FALILMESSAGE, (String)msgFailFields, (QFilter[])filter1s);
        List<Long> messageIds = FailMessageUtil.putFailMsgData(msgFailFields, failMsgDos, failMsgDatas, Boolean.FALSE);
        if (messageIds.isEmpty()) {
            return failMsgDatas;
        }
        QFilter[] filter2s = new QFilter[]{new QFilter("id", "in", messageIds)};
        String msgFields = "ID,TYPE,MOBCONTENTURL,SENDER,CONTENTURL,ENTITYNUMBER,OPERATION,BIZDATAID,SOURCE,TAG,CONTENT";
        DynamicObject[] messageDos = BusinessDataServiceHelper.load((String)"wf_msg_message", (String)msgFields, (QFilter[])filter2s);
        FailMessageUtil.putFailMsgData(msgFields, messageDos, failMsgDatas, Boolean.TRUE);
        return failMsgDatas;
    }

    private static List<Long> putFailMsgData(String properties, DynamicObject[] msgDos, List<Map<String, Object>> failMsgDatas, boolean isMessage) {
        ArrayList<Long> messageIds = null;
        String[] propertyList = properties.split(",");
        if (!isMessage) {
            messageIds = new ArrayList<Long>(msgDos.length);
            for (DynamicObject msgDo : msgDos) {
                HashMap<String, Object> hashMap = new HashMap<String, Object>(propertyList.length + 11);
                boolean hasSetMsgDataFromConfig = FailMessageUtil.setMsgDataFromConfig(msgDo, hashMap);
                for (String property : propertyList) {
                    String p = property.trim();
                    if (MESSAGEID.equalsIgnoreCase(p) && !hasSetMsgDataFromConfig) {
                        messageIds.add(msgDo.getLong(p));
                    }
                    hashMap.put(p.toLowerCase(), msgDo.get(p));
                }
                failMsgDatas.add(hashMap);
            }
        } else {
            for (Map<String, Object> failMsgData : failMsgDatas) {
                Object messageId = failMsgData.get(MESSAGEID);
                DynamicObject targetMsgDo = null;
                for (DynamicObject dynamicObject : msgDos) {
                    if (!messageId.equals(dynamicObject.getLong("id"))) continue;
                    targetMsgDo = dynamicObject;
                    break;
                }
                if (targetMsgDo == null) continue;
                for (String string : propertyList) {
                    String p = string.trim();
                    if ("id".equalsIgnoreCase(p)) continue;
                    failMsgData.put(p.toLowerCase(), targetMsgDo.get(p));
                }
            }
        }
        return messageIds;
    }

    private static boolean setMsgDataFromConfig(DynamicObject msgDo, Map<String, Object> data) {
        if (msgDo == null) {
            return false;
        }
        String configStr = msgDo.getString(CONFIG);
        if (configStr == null || configStr == "") {
            return false;
        }
        Map configMap = null;
        try {
            configMap = (Map)SerializationUtils.fromJsonString((String)configStr, Map.class);
        }
        catch (Throwable e) {
            return false;
        }
        if (configMap == null) {
            return false;
        }
        Object noSaveMessage = configMap.get(NOSAVEMESSAGE);
        if (noSaveMessage == null) {
            return false;
        }
        Map messageInfo = (Map)configMap.get("messageInfo");
        data.put("id", messageInfo.get("id"));
        data.put("type", messageInfo.get("type"));
        data.put("mobcontenturl", messageInfo.get("mobcontenturl"));
        data.put("sender", messageInfo.get("sender"));
        data.put("contenturl", messageInfo.get("contenturl"));
        data.put("entitynumber", messageInfo.get("entitynumber"));
        data.put("operation", messageInfo.get("operation"));
        data.put("bizdataid", messageInfo.get("bizdataid"));
        data.put("source", messageInfo.get("source"));
        data.put("tag", messageInfo.get("tag"));
        data.put(CONTENT, messageInfo.get(CONTENT));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Long> sendFailMessage(List<MessageInfo> failMessageList, boolean isMsgInfo) {
        ArrayList<Long> sendSuccessIds = new ArrayList<Long>();
        try (MessagePublisher publisher = null;){
            Object needStoreFailMsg;
            if (isMsgInfo && (needStoreFailMsg = FailMessageUtil.getMessageInfoOfNotExist(failMessageList)).size() != 0) {
                FailMessageUtil.saveFailMessage(needStoreFailMsg);
            }
            logger.debug("sendFailMessage-- batch send fail message & message publisher");
            publisher = MQFactory.get().createSimplePublisher("workflow", "messagecenter_service");
            for (MessageInfo channelMessage : failMessageList) {
                if (channelMessage.getParams() != null && DEALFAIL.equals(channelMessage.getParams().get("state"))) {
                    MessageBussinessInfo info = FailMessageUtil.buildDealMessagePublishData(channelMessage);
                    MessageBussinessPublishUtil.publishBizMessage((MessageBussinessInfo)info);
                } else {
                    FailMessageUtil.adornMessageUser(channelMessage);
                    FailMessageUtil.wrapMessageMutilLan(channelMessage);
                    publisher.publish((Object)channelMessage);
                }
                sendSuccessIds.add(channelMessage.getChannelMsgId());
            }
        }
        return sendSuccessIds;
    }

    private static void adornMessageUser(MessageInfo message) {
        List userIds = message.getUserIds();
        Map params = message.getParams();
        List successSendUsers = (List)params.get("successSendUser");
        if (successSendUsers == null || successSendUsers.size() == 0) {
            return;
        }
        if (userIds != null && !userIds.isEmpty()) {
            List<Long> successSendUserIds = FailMessageUtil.getLongCollection(successSendUsers);
            params.put("successSendUser", successSendUserIds);
            userIds.removeAll(successSendUserIds);
        } else {
            String notifyType = message.getNotifyType();
            if ("sms".equals(notifyType) || EMAIL.equals(notifyType)) {
                Object receivers;
                Object v = receivers = "sms".equals(notifyType) ? params.get("phone") : params.get(EMAIL);
                if (receivers != null) {
                    List rs = (List)receivers;
                    rs.removeAll(successSendUsers);
                }
            }
        }
    }

    private static List<Long> getLongCollection(List<Object> colls) {
        ArrayList<Long> newColls = new ArrayList<Long>(colls.size());
        for (Object coll : colls) {
            if (coll instanceof Long) {
                newColls.add((Long)coll);
                continue;
            }
            newColls.add(Long.valueOf(coll + ""));
        }
        return newColls;
    }

    private static MessageBussinessInfo buildDealMessagePublishData(MessageInfo channelMessage) {
        MessageBussinessInfo info = new MessageBussinessInfo();
        HashMap<String, Object> params = new HashMap<String, Object>();
        List userIds = channelMessage.getUserIds();
        Long userId = 0L;
        if (userIds != null && !userIds.isEmpty()) {
            userId = (Long)channelMessage.getUserIds().get(0);
        }
        params.put("userId", userId);
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(channelMessage.getId());
        params.put("messageIds", ids);
        params.put(CHANNEL, channelMessage.getNotifyType());
        params.put("isResend", Boolean.TRUE);
        info.setData(params);
        info.setType(MessageBussinessInfo.Type.DEALMESSAGE.getNumber());
        return info;
    }

    private static List<MessageInfo> getMessageInfoOfNotExist(List<MessageInfo> failMessageList) {
        ArrayList<Long> ids = new ArrayList<Long>(failMessageList.size());
        for (MessageInfo messageInfo : failMessageList) {
            ids.add(messageInfo.getChannelMsgId());
        }
        DynamicObject[] exitsFailMsgs = BusinessDataServiceHelper.load((String)WF_MSG_FALILMESSAGE, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        ArrayList<MessageInfo> needStoreFailMsg = new ArrayList();
        if (exitsFailMsgs != null && exitsFailMsgs.length != 0) {
            if (exitsFailMsgs.length != failMessageList.size()) {
                for (MessageInfo messageInfo : failMessageList) {
                    boolean isNotExits = true;
                    for (DynamicObject failMsg : exitsFailMsgs) {
                        if (messageInfo.getChannelMsgId().longValue() != failMsg.getLong("id")) continue;
                        isNotExits = false;
                        break;
                    }
                    if (!isNotExits) continue;
                    needStoreFailMsg.add(messageInfo);
                }
            }
        } else {
            needStoreFailMsg = failMessageList;
        }
        return needStoreFailMsg;
    }

    private static void wrapMessageMutilLan(MessageInfo message) {
        ILocaleString messageTitle;
        ILocaleString messageContent = message.getMessageContent();
        if (MessageUtils.isEmpty((ILocaleString)messageContent)) {
            String content = message.getContent();
            ILocaleString mcontent = FailMessageUtil.getMultiLangValue(content);
            message.setMessageContent(mcontent);
        }
        if (MessageUtils.isEmpty((ILocaleString)(messageTitle = message.getMessageTitle()))) {
            String title = message.getTitle();
            ILocaleString mtitle = FailMessageUtil.getMultiLangValue(title);
            message.setMessageTitle(mtitle);
        }
    }

    private static ILocaleString getMultiLangValue(String value) {
        LocaleString result = new LocaleString();
        List enabledLangs = InteServiceHelper.getEnabledLang();
        for (EnabledLang enabledLang : enabledLangs) {
            result.put((Object)enabledLang.getNumber(), (Object)value);
        }
        return result;
    }

    public static Map<String, Object> updateFailMessage(MessageInfo message, boolean isDeleteMsg, String msgFailReason) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Map param = message.getParams();
        if (isDeleteMsg) {
            if (param.containsKey(ATTACHMENTURLS)) {
                MessageAttachmentUtils.deleteAttachmentData((MessageInfo)message);
                logger.info(String.format("updateFailMessage-deleteAttachmentDate-message[%s]-channel[%s]", message.getId(), message.getChannelMsgId()));
            }
            DeleteServiceHelper.delete((String)WF_MSG_FALILMESSAGE, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)message.getChannelMsgId())});
        } else {
            DynamicObject msg = BusinessDataServiceHelper.loadSingle((Object)message.getChannelMsgId(), (String)WF_MSG_FALILMESSAGE);
            int retrySize = msg.getInt(RETRY);
            msg.set("state", (Object)(msgFailReason == null ? SUCCESS : FAIL));
            msg.set(RETRY, (Object)(++retrySize));
            msg.set("reason", (Object)msgFailReason);
            msg.set("modifydate", (Object)System.currentTimeMillis());
            msg.set(TITLE, (Object)FailMessageUtil.commonlangToGlang(message.getMessageTitle()));
            msg.set("channelcontent", (Object)FailMessageUtil.commonlangToGlang(message.getMessageContent()));
            MsgChannelInfo channelCfgInfo = MsgServiceCache.getMsgChannel((String)message.getNotifyType());
            if (channelCfgInfo != null) {
                msg.set("channelname", (Object)FailMessageUtil.getChannelName(channelCfgInfo.getName()));
                msg.set("serviceclass", (Object)channelCfgInfo.getServiceclass());
            }
            msg.set(RUNTIMECONFIG, (Object)FailMessageUtil.getMessageLogRuntimeConfig(message, msg));
            if (StringUtils.isBlank((Object)msg.get(TEMPLATE)) && StringUtils.isNotBlank((CharSequence)message.getTemplateNumber())) {
                msg.set(TEMPLATE, (Object)message.getTemplateNumber());
            }
            FailMessageUtil.storeMessageAttachment(message, msg, channelCfgInfo);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{msg});
            map.put("retrysize", retrySize);
        }
        return map;
    }

    private static String getMessageLogRuntimeConfig(MessageInfo message, DynamicObject msg) {
        try {
            String runtimeConfigJson;
            Map<String, String> runtimeConfig = null;
            runtimeConfig = MessageUtils.isNotEmpty((String)msg.getString(RUNTIMECONFIG)) ? (Map)SerializationUtils.fromJsonString((String)msg.getString(RUNTIMECONFIG), Map.class) : new HashMap<String, String>();
            runtimeConfig.put(MSGURL, message.getMobContentUrl());
            runtimeConfig.put(TRACEID, RequestContext.get().getTraceId());
            Map params = message.getParams();
            if (!message.isToAll()) {
                if (params.containsKey(USERFILTER)) {
                    runtimeConfig.put(USERFILTER, (String)params.get(USERFILTER));
                }
                if (params.containsKey(MSGVERIFYINFO)) {
                    runtimeConfig.put(MSGVERIFYINFO, (String)params.get(MSGVERIFYINFO));
                }
                if (params.containsKey("successSendUser")) {
                    List successUsers = (List)params.get("successSendUser");
                    if (successUsers.size() > 100) {
                        runtimeConfig.put("successSendUser", "successUser beyond maxRecord[100]");
                    } else {
                        runtimeConfig.put("successSendUser", (String)((Object)successUsers));
                    }
                }
            }
            if ("sms".equalsIgnoreCase(message.getNotifyType()) && params.containsKey(MSGTPLPARSE)) {
                runtimeConfig.put(MSGTPLPARSE, (String)params.get(MSGTPLPARSE));
            }
            return (runtimeConfigJson = SerializationUtils.toJsonString(runtimeConfig)).length() > 30000 ? runtimeConfigJson.substring(0, 30000) : runtimeConfigJson;
        }
        catch (Exception e) {
            logger.info("sendFailMessage-- config:" + msg.getString(CONFIG));
            return "";
        }
    }

    private static void storeMessageAttachment(MessageInfo message, DynamicObject msg, MsgChannelInfo msgChannelInfo) {
        Map<String, List> config;
        boolean isEmailChannel = MessageChannelUtils.isEmailChannel((String)message.getNotifyType(), (MsgChannelInfo)msgChannelInfo);
        if (!isEmailChannel || message.getAttachment() == null) {
            return;
        }
        Object param = msg.get(CONFIG);
        boolean needStoreAttachment = Boolean.FALSE;
        if (StringUtils.isNotBlank((Object)param)) {
            config = (Map)SerializationUtils.fromJsonString((String)((String)param), Map.class);
            if (!config.containsKey(ATTACHMENTURLS)) {
                needStoreAttachment = Boolean.TRUE;
            }
        } else {
            config = new HashMap();
            needStoreAttachment = Boolean.TRUE;
        }
        if (!needStoreAttachment) {
            return;
        }
        List attachmentUrls = MessageAttachmentUtils.putAttachmentData((MessageInfo)message);
        MessageAttachment attachments = message.getAttachment();
        if (attachmentUrls.size() == attachments.getAttachmentNames().size()) {
            config.put("attachmentNames", attachments.getAttachmentNames());
            config.put(ATTACHMENTURLS, attachmentUrls);
            msg.set(CONFIG, (Object)SerializationUtils.toJsonString(config));
        } else {
            logger.info("FailMessageUtil-storeAttachment is error msgid:" + message.getChannelMsgId());
        }
    }

    @Deprecated
    public static void saveFailMessage(List<MessageInfo> messageList) {
        FailMessageUtil.saveFailMessage(messageList, null);
    }

    public static void saveFailMessage(List<MessageInfo> messageInfos, SendMessageContext messageContext) {
        if (messageInfos == null || messageInfos.isEmpty()) {
            return;
        }
        try (TXHandle tx = TX.requiresNew((String)"MessageCenterServiceImpl_saveFailMessage");){
            try {
                DynamicObject[] failMsgArray = new DynamicObject[messageInfos.size()];
                for (int i = 0; i < messageInfos.size(); ++i) {
                    MessageInfo message = messageInfos.get(i);
                    String notifyType = message.getNotifyType();
                    LocaleString messageTitle = MessageUtils.isEmpty((ILocaleString)message.getMessageTitle()) ? new LocaleString(message.getTitle()) : message.getMessageTitle();
                    LocaleString messageContent = MessageUtils.isEmpty((ILocaleString)message.getMessageContent()) ? new LocaleString(message.getContent()) : message.getMessageContent();
                    ILocaleString senderName = MessageUtils.isEmpty((ILocaleString)message.getMessageSenderName()) ? FailMessageUtil.getSenderName(message, messageContext) : message.getMessageSenderName();
                    MessageMultilangageUtils.clipLocaleString((ILocaleString)senderName, (int)100);
                    DynamicObject failMsgObject = BusinessDataServiceHelper.newDynamicObject((String)WF_MSG_FALILMESSAGE);
                    failMsgObject.set("id", (Object)message.getChannelMsgId());
                    failMsgObject.set(MESSAGEID, (Object)message.getId());
                    failMsgObject.set(USERIDS, (Object)FailMessageUtil.getUserIds(message));
                    failMsgObject.set(TITLE, (Object)messageTitle);
                    failMsgObject.set(ENTITYNAME, (Object)FailMessageUtil.getEntityName(message, messageContext));
                    failMsgObject.set(SENDERNAME, (Object)senderName);
                    failMsgObject.set("pubaccnumber", (Object)message.getPubaccNumber());
                    failMsgObject.set(TPLSCENE, (Object)message.getTplScene());
                    failMsgObject.set(CHANNEL, (Object)notifyType);
                    failMsgObject.set("channelname", (Object)new LocaleString(notifyType));
                    failMsgObject.set("serviceclass", (Object)"");
                    failMsgObject.set(RETRY, (Object)-1);
                    failMsgObject.set("state", (Object)NORMAL);
                    failMsgObject.set(CREATEDATE, (Object)System.currentTimeMillis());
                    failMsgObject.set("modifydate", (Object)System.currentTimeMillis());
                    Map param = message.getParams();
                    Object bizEntityObject = null;
                    if (!param.isEmpty()) {
                        String config;
                        FailMessageUtil.saveMessageInfoToConfig(param, message);
                        param.put(ISSIGNLEEMAIL, message.isSignleEmail());
                        if (message.getParams() != null && param.containsKey(BIZENTITYOBJECT)) {
                            bizEntityObject = param.remove(BIZENTITYOBJECT);
                        }
                        failMsgObject.set(CONFIG, (Object)((config = SerializationUtils.toJsonString((Object)param)).length() > 2000 ? config.substring(0, 1950) : config));
                        if (bizEntityObject != null) {
                            param.put(BIZENTITYOBJECT, bizEntityObject);
                        }
                    }
                    failMsgObject.set(TEMPLATE, (Object)message.getTemplateNumber());
                    failMsgObject.set("toall", (Object)message.isToAll());
                    failMsgObject.set("channelcontent", (Object)messageContent);
                    failMsgArray[i] = failMsgObject;
                }
                SaveServiceHelper.save((DynamicObject[])failMsgArray);
            }
            catch (Exception e) {
                FailMessageUtil.printStackTrace(e);
                logger.info("MessageCenterServiceImpl--message data save failmsg db error" + e.getMessage());
                tx.markRollback();
            }
        }
    }

    private static void saveMessageInfoToConfig(Map<String, Object> param, MessageInfo message) {
        if (param == null || param.get(NOSAVEMESSAGE) == null) {
            return;
        }
        HashMap<String, Object> messageInfo = new HashMap<String, Object>(11);
        messageInfo.put("id", message.getId());
        Map typeCacheData = MessageUtils.getMessageTypeInfo((String)message.getType());
        messageInfo.put("type", typeCacheData.get("id"));
        messageInfo.put("mobcontenturl", message.getMobContentUrl());
        messageInfo.put("sender", message.getSenderId() == null ? "0" : String.valueOf(message.getSenderId()));
        messageInfo.put("contenturl", message.getContentUrl());
        messageInfo.put("entitynumber", message.getEntityNumber());
        messageInfo.put("operation", message.getOperation());
        messageInfo.put("bizdataid", message.getBizDataId());
        messageInfo.put("source", message.getSource());
        ILocaleString messageTag = message.getMessageTag();
        if (messageTag != null) {
            messageInfo.put("tag", messageTag);
        } else {
            messageInfo.put("tag", message.getTag());
        }
        messageInfo.put(CONTENT, message.getContent());
        param.put("messageInfo", messageInfo);
    }

    public static ILocaleString getSenderName(MessageInfo message) {
        return FailMessageUtil.getSenderName(message, null);
    }

    public static ILocaleString getSenderName(MessageInfo message, SendMessageContext messageContext) {
        LocaleString messageSenderName = new LocaleString();
        if (MessageUtils.isEmpty((String)message.getSenderName()) && MessageUtils.isEmpty((ILocaleString)message.getMessageSenderName())) {
            messageSenderName = ResManager.getLocaleString((String)"\u7cfb\u7edf\u53d1\u9001", (String)"MessageCenterServiceImpl_1", (String)"bos-mservice-message");
            if (StringUtils.isBlank((Object)message.getSenderId()) || message.getSenderId() == 0L) {
                message.setMessageSenderName((ILocaleString)messageSenderName);
            } else {
                Long senderId = message.getSenderId();
                if (messageContext != null) {
                    Map senderMapping = messageContext.getSenderMapping();
                    ILocaleString name = (ILocaleString)senderMapping.get(senderId);
                    if (MessageUtils.isNotEmpty((ILocaleString)name)) {
                        for (Lang lang : MessageMultilangageUtils.getSupportLangs()) {
                            messageSenderName.put((Object)lang.name(), name.get((Object)lang.name()));
                        }
                    }
                } else {
                    ILocaleString name;
                    DynamicObject userObject = BusinessDataServiceHelper.loadSingle((Object)senderId, (String)"bos_user");
                    if (userObject != null && MessageUtils.isNotEmpty((ILocaleString)(name = userObject.getLocaleString("name")))) {
                        for (Lang lang : MessageMultilangageUtils.getSupportLangs()) {
                            messageSenderName.put((Object)lang.name(), name.get((Object)lang.name()));
                        }
                    }
                }
                message.setMessageSenderName((ILocaleString)messageSenderName);
            }
        } else if (MessageUtils.isNotEmpty((ILocaleString)message.getMessageSenderName())) {
            messageSenderName = message.getMessageSenderName();
        } else {
            messageSenderName = new LocaleString(message.getSenderName());
            message.setMessageSenderName((ILocaleString)messageSenderName);
        }
        return messageSenderName;
    }

    private static LocaleString getEntityName(MessageInfo message, SendMessageContext messageContext) {
        String entityNumber = message.getEntityNumber();
        LocaleString entityName = new LocaleString();
        if (messageContext == null) {
            try {
                if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
                    entityName = FormMetadataCache.getFormConfig((String)entityNumber).getCaption();
                }
            }
            catch (Exception e) {
                logger.info("SaveChannelMessage and getEntityNameIsError" + e.getMessage());
            }
        } else {
            Map entityMapping = messageContext.getEntityMapping();
            MainEntityType mainEntityType = (MainEntityType)entityMapping.get(entityNumber);
            if (mainEntityType != null) {
                entityName = mainEntityType.getDisplayName();
            }
        }
        return entityName;
    }

    private static String getUserIds(MessageInfo message) {
        List receiverUserIds = message.getUserIds();
        StringBuilder sb = new StringBuilder();
        if (receiverUserIds != null && receiverUserIds.size() != 0) {
            for (int j = 0; j < receiverUserIds.size(); ++j) {
                Long receiverId = (Long)receiverUserIds.get(j);
                if (receiverId == null || MessageUtils.isEmpty((Long)receiverId)) continue;
                if (j == receiverUserIds.size() - 1) {
                    sb.append(receiverId);
                    continue;
                }
                sb.append(receiverId).append(",");
            }
        }
        return sb.toString();
    }

    private static void printStackTrace(Throwable e) {
        StringBuilder traceLog = new StringBuilder();
        StackTraceElement[] stackElements = e.getStackTrace();
        if (stackElements != null) {
            for (int i = 0; i < stackElements.length; ++i) {
                String str = stackElements[i].toString();
                traceLog.append(str).append("\n");
            }
            logger.info(traceLog.toString());
        }
    }

    @Deprecated
    public static List<MessageInfo> wrapChannelMessage(MessageInfo mcMessage) {
        String[] channels;
        ArrayList<MessageInfo> messageList = new ArrayList<MessageInfo>();
        String messageChannel = mcMessage.getNotifyType();
        if (messageChannel.equalsIgnoreCase("mcenter")) {
            return messageList;
        }
        if (StringUtils.isNotBlank((CharSequence)messageChannel) && (channels = messageChannel.split(",")) != null && channels.length > 0) {
            for (String c : channels) {
                if (!StringUtils.isNotBlank((CharSequence)c.trim())) continue;
                if (c.trim().equalsIgnoreCase("mcenter") || !"notice".equals(mcMessage.getType()) && !"activity".equals(mcMessage.getType()) && c.trim().equalsIgnoreCase("sysnotice")) {
                    logger.info(String.format("sendMessage-wrapChannelMessage-\u4e0d\u5141\u8bb8\u9664\u516c\u544a\u4e4b\u5916\u7684\u6d88\u606f\u7c7b\u578b\u4f7f\u7528 \u7cfb\u7edf\u516c\u544a\u6e20\u9053:%s", messageChannel));
                    continue;
                }
                messageList.add(FailMessageUtil.clone(mcMessage, c.trim()));
            }
        }
        return messageList;
    }

    @Deprecated
    private static MessageInfo clone(MessageInfo mcMessage, String channelNumber) {
        MessageInfo channelMessage = mcMessage.copy();
        channelMessage.setNotifyType(channelNumber);
        channelMessage.setAttachment(mcMessage.getAttachment());
        if (!EMAIL.equals(channelNumber)) {
            channelMessage.setAttachment(null);
        }
        channelMessage.setChannelMsgId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
        return channelMessage;
    }

    private static ILocaleString getChannelName(String channel) {
        LocaleString channelName = new LocaleString("");
        if (!StringUtils.isBlank((CharSequence)channel)) {
            Map map = (Map)SerializationUtils.fromJsonString((String)channel, Map.class);
            for (Map.Entry entry : map.entrySet()) {
                channelName.setItem((String)entry.getKey(), entry.getValue());
            }
        }
        return channelName;
    }

    private static ILocaleString commonlangToGlang(ILocaleString str) {
        if (MessageUtils.isNotEmpty((ILocaleString)str) && MessageUtils.isNotEmpty((String)((String)str.getItem(COMMONLANG)))) {
            str.setItem(GLANG, str.getItem(COMMONLANG));
            str.remove((Object)COMMONLANG);
        }
        return str;
    }

    private static String getGLang(ILocaleString localStr) {
        String str = "";
        if (MessageUtils.isNotEmpty((ILocaleString)localStr) && MessageUtils.isEmpty((String)(str = localStr.getLocaleValue()))) {
            str = (String)localStr.getItem(GLANG);
        }
        return str;
    }

    public static void dealFailMessage(JSONObject failMsgs, Map<Long, Map<String, MessageInfo>> successMsgs) {
        HashSet<Long> allMsgIds = new HashSet<Long>();
        boolean hasSuccessMsgs = false;
        boolean hasFailMsgs = false;
        if (failMsgs != null && !failMsgs.isEmpty()) {
            Set keySet = failMsgs.keySet();
            keySet.forEach(id -> allMsgIds.add(Long.valueOf(id)));
            hasFailMsgs = true;
        }
        if (successMsgs != null && !successMsgs.isEmpty()) {
            allMsgIds.addAll(successMsgs.keySet());
            hasSuccessMsgs = true;
        }
        QFilter filter = new QFilter(MESSAGEID, "in", allMsgIds);
        DynamicObject[] msgs = BusinessDataServiceHelper.load((String)WF_MSG_FALILMESSAGE, (String)"id,messageid,channel,retry,state,reason,modifydate,title,channelcontent,userids", (QFilter[])new QFilter[]{filter});
        ArrayList<Long> deleteMsgList = new ArrayList<Long>(msgs.length);
        ArrayList<DynamicObject> updateMsgList = new ArrayList<DynamicObject>(msgs.length);
        ArrayList<String> cacheKeys = new ArrayList<String>();
        for (DynamicObject msg : msgs) {
            String channel = msg.getString(CHANNEL);
            Long messageId2 = msg.getLong(MESSAGEID);
            if (hasSuccessMsgs && successMsgs.get(messageId2) != null && successMsgs.get(messageId2).get(channel) != null) {
                MsgChannelInfo config = MessageChannelUtils.getChannelConfig((String)channel);
                deleteMsgList.add(msg.getLong("id"));
                continue;
            }
            String state = msg.getString("state");
            JSONObject messageJson = failMsgs.getJSONObject(messageId2.toString());
            if (messageJson == null || messageJson.get((Object)channel) == null || !DEALFAIL.equals(state)) continue;
            JSONObject channelMessageJson = messageJson.getJSONObject(channel);
            String msgFailReason = channelMessageJson.getString(FAILREASON);
            int retrySize = msg.getInt(RETRY);
            msg.set(RETRY, (Object)(++retrySize));
            msg.set("reason", (Object)msgFailReason);
            msg.set("modifydate", (Object)System.currentTimeMillis());
            String cacheKey = MsgServiceCacheHelper.getDealMessageKey((String)messageId2.toString(), (String)msg.getString(USERIDS), (String)channel);
            if (MsgServiceCacheHelper.getCache((String)cacheKey) == null) {
                updateMsgList.add(msg);
                MsgServiceCacheHelper.putDealMessageCache((String)cacheKey, (String)"dealMessage");
                cacheKeys.add(cacheKey);
            }
            messageJson.remove((Object)channel);
            if (!messageJson.isEmpty()) continue;
            failMsgs.remove((Object)messageId2.toString());
        }
        if (hasFailMsgs) {
            failMsgs.forEach((messageId, json) -> {
                JSONObject messageJson = (JSONObject)json;
                messageJson.forEach((channel, channelMessage) -> {
                    JSONObject channelMessageJson = (JSONObject)channelMessage;
                    MessageInfo message = (MessageInfo)channelMessageJson.get((Object)"message");
                    String msgFailReason = channelMessageJson.getString(FAILREASON);
                    MsgChannelInfo channelCfgInfo = MsgServiceCache.getMsgChannel((String)message.getNotifyType());
                    LocaleString messageTitle = StringUtils.isBlank((Object)message.getMessageTitle()) ? new LocaleString(message.getTitle()) : message.getMessageTitle();
                    LocaleString messageContent = StringUtils.isBlank((Object)message.getMessageContent()) ? new LocaleString(message.getContent()) : message.getMessageContent();
                    ILocaleString senderName = StringUtils.isBlank((Object)message.getMessageSenderName()) ? FailMessageUtil.getSenderName(message) : message.getMessageSenderName();
                    LocaleString channelName = channelCfgInfo != null ? FailMessageUtil.getChannelName(channelCfgInfo.getName()) : new LocaleString("");
                    String serviceClass = channelCfgInfo != null ? channelCfgInfo.getServiceclass() : "";
                    DynamicObject failMsgObject = BusinessDataServiceHelper.newDynamicObject((String)WF_MSG_FALILMESSAGE);
                    String userIds = FailMessageUtil.getUserIds(message);
                    failMsgObject.set(MESSAGEID, (Object)message.getId());
                    failMsgObject.set(USERIDS, (Object)userIds);
                    failMsgObject.set(TITLE, (Object)messageTitle);
                    failMsgObject.set(ENTITYNAME, (Object)FailMessageUtil.getEntityName(message, null));
                    failMsgObject.set(SENDERNAME, (Object)senderName);
                    failMsgObject.set("pubaccnumber", (Object)message.getPubaccNumber());
                    failMsgObject.set(TPLSCENE, (Object)message.getTplScene());
                    failMsgObject.set(CHANNEL, (Object)message.getNotifyType());
                    failMsgObject.set("channelname", (Object)channelName);
                    failMsgObject.set("serviceclass", (Object)serviceClass);
                    failMsgObject.set(RETRY, (Object)-1);
                    failMsgObject.set("state", (Object)DEALFAIL);
                    failMsgObject.set(CREATEDATE, (Object)System.currentTimeMillis());
                    failMsgObject.set("modifydate", (Object)System.currentTimeMillis());
                    failMsgObject.set("reason", (Object)msgFailReason);
                    Map param = message.getParams();
                    if (!param.isEmpty()) {
                        failMsgObject.set(CONFIG, (Object)SerializationUtils.toJsonString((Object)param));
                    }
                    failMsgObject.set("toall", (Object)message.isToAll());
                    failMsgObject.set("channelcontent", (Object)messageContent);
                    String cacheKey = MsgServiceCacheHelper.getDealMessageKey((String)message.getId().toString(), (String)userIds, (String)channel);
                    if (MsgServiceCacheHelper.getCache((String)cacheKey) == null) {
                        updateMsgList.add(failMsgObject);
                        MsgServiceCacheHelper.putDealMessageCache((String)cacheKey, (String)"dealMessage");
                    }
                });
            });
        }
        if (!deleteMsgList.isEmpty()) {
            DeleteServiceHelper.delete((String)WF_MSG_FALILMESSAGE, (QFilter[])new QFilter[]{new QFilter("id", "in", deleteMsgList)});
        }
        if (!updateMsgList.isEmpty()) {
            SaveServiceHelper.save((DynamicObject[])updateMsgList.toArray(new DynamicObject[updateMsgList.size()]));
            MsgServiceCacheHelper.deleteCache((String[])cacheKeys.toArray(new String[cacheKeys.size()]));
        }
    }
}

