/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.api;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.impl.log.entity.ConditionParseLogEntity;
import kd.bos.workflow.engine.impl.util.DynamicObjectSafeGetter;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ConditionParseApis {
    private static final Log logger = LogFactory.getLog(ConditionParseApis.class);
    public static ConditionParseApis instance = new ConditionParseApis();

    private ConditionParseApis() {
    }

    public static ConditionParseApis getInstance() {
        return instance;
    }

    public List<ConditionParseLogEntity> findConditionParseList(String entityNumber, String billNoOrBusinessKey) {
        return this.historyService().findConditionParseListBy(entityNumber.trim(), billNoOrBusinessKey.trim());
    }

    public String findBaseNumber(String entityNumber, String billNo) {
        DynamicObject dynamicObject;
        try {
            dynamicObject = QueryServiceHelper.queryOne((String)entityNumber, (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billNo)});
        }
        catch (Throwable error) {
            logger.warn(error);
            return "";
        }
        if (dynamicObject == null) {
            return "";
        }
        DynamicObjectSafeGetter dynamicObjectSafeGetter = new DynamicObjectSafeGetter(dynamicObject);
        String number = dynamicObjectSafeGetter.getString("number");
        String name = dynamicObjectSafeGetter.getString("name");
        return number + "/" + name;
    }

    public HistoryService historyService() {
        return (HistoryService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(HistoryService.class);
    }

    public RuntimeService runtimeService() {
        return (RuntimeService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(RuntimeService.class);
    }
}

