/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cache;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.engine.WfUtils;

public class DevopsServiceCacheHelper {
    private static final String CACHE_KEY_EXCEPTED_ENTITY_NUMBER = "CACHE_KEY_EXCEPTED_ENTITY_NUMBER";
    private static DistributeSessionlessCache cache = null;
    private static final String WFDEVOPS = "WF_DEVOPS_SERVICE";
    private static final String CACHEKEY_MQANDSCHEDULEMANAGERMONITOR = "mqAndScheduleManagerMonitor";
    private static final String CACHEKEY_MQANDSCHEDULEMANAGERMONITORID = "mqAndScheduleMonitorId";
    private static final String CACHEKEY_RECOVERSYSERRORPROCESSINSTANCE = "recoverSysErrorProcessInstance";
    private static final String CACHEKEY_DISABLEINDICTORMAP = "disableIndcitors";
    private static final String CACHEKEY_INDCITORSCAPTUREGROUP = "indcitorsCaptureGroup";
    private static final String CACHEKEY_INDCITORSCLEANTIME = "indcitorsCleanTime";

    private static DistributeSessionlessCache getCache() {
        if (cache == null) {
            cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(WFDEVOPS, new DistributeCacheHAPolicy());
        }
        return cache;
    }

    public static String getWholeKey(String ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append(RequestContext.get().getTenantId()).append("_").append(RequestContext.get().getAccountId()).append("_").append("wf.devops.").append(StringUtils.join((Object[])args, (String)"_"));
        return sb.toString();
    }

    public static void putMqAndScheduleManagerMonitorKey(String appId, Map<String, String> map) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_MQANDSCHEDULEMANAGERMONITOR, appId);
        DevopsServiceCacheHelper.getCache().put(cacheKey, map);
    }

    public static Map<String, String> getMqAndScheduleManagerMonitorKey(String appId) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_MQANDSCHEDULEMANAGERMONITOR, appId);
        return DevopsServiceCacheHelper.getCache().getAll(cacheKey);
    }

    public static void removeMqAndScheduleManagerMonitorKey(String appId) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_MQANDSCHEDULEMANAGERMONITOR, appId);
        DevopsServiceCacheHelper.getCache().remove(cacheKey);
    }

    public static void putMqAndScheduleMnoitorId(String parentId) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_MQANDSCHEDULEMANAGERMONITORID);
        DevopsServiceCacheHelper.getCache().put(cacheKey, (Object)parentId);
    }

    public static String getMqAndScheduleMnoitorId() {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_MQANDSCHEDULEMANAGERMONITORID);
        return (String)DevopsServiceCacheHelper.getCache().get(cacheKey);
    }

    public static void removeMqAndScheduleMnoitorId() {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_MQANDSCHEDULEMANAGERMONITORID);
        DevopsServiceCacheHelper.getCache().remove(cacheKey);
    }

    public static void putRecoverSysErrorProcessinstance(String key, String value) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_RECOVERSYSERRORPROCESSINSTANCE);
        Map map = DevopsServiceCacheHelper.getCache().getAll(cacheKey);
        map.put(key, value);
    }

    public static String getRecoverSysErrorProcessinstance(String key) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_RECOVERSYSERRORPROCESSINSTANCE);
        return (String)DevopsServiceCacheHelper.getCache().getAll(cacheKey).get(key);
    }

    public static void removeRecoverSysErrorProcessinstance() {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_RECOVERSYSERRORPROCESSINSTANCE);
        DevopsServiceCacheHelper.getCache().remove(cacheKey);
    }

    public static void putDisableIndictor(Map<String, String> numbers) {
        if (WfUtils.isNotEmptyForMap(numbers)) {
            String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_DISABLEINDICTORMAP);
            numbers.forEach((key, value) -> DevopsServiceCacheHelper.getCache().put(cacheKey, key, value));
        }
    }

    public static Set<String> getExceptedEntityNumber() {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHE_KEY_EXCEPTED_ENTITY_NUMBER);
        String[] list = DevopsServiceCacheHelper.getCache().getSetValues(key);
        return new HashSet<String>(Arrays.asList(list));
    }

    public static int setExceptedEntityNumber(String entityNumber) {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHE_KEY_EXCEPTED_ENTITY_NUMBER);
        String[] value = new String[]{entityNumber};
        return DevopsServiceCacheHelper.getCache().addToSet(key, value);
    }

    public static int setExceptedEntityNumber(Set<String> entityNumber) {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHE_KEY_EXCEPTED_ENTITY_NUMBER);
        return DevopsServiceCacheHelper.getCache().addToSet(key, entityNumber.toArray(new String[0]));
    }

    public static void removeExceptedEntityNumber() {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHE_KEY_EXCEPTED_ENTITY_NUMBER);
        DevopsServiceCacheHelper.getCache().remove(key);
    }

    public static Map<String, String> getDisableIndictor() {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_DISABLEINDICTORMAP);
        return DevopsServiceCacheHelper.getCache().getAll(cacheKey);
    }

    public static void removeDisableIndictor(Map<String, String> numbers) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_DISABLEINDICTORMAP);
        numbers.forEach((key, value) -> DevopsServiceCacheHelper.getCache().remove(cacheKey, key));
    }

    public static int putIndcitorsCaptureGroup(String groupId) {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_INDCITORSCAPTUREGROUP, groupId);
        return DevopsServiceCacheHelper.getCache().addToSet(key, new String[]{groupId}, 3600);
    }

    public static void removeIndcitorsCaptureGroup(String groupId) {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_INDCITORSCAPTUREGROUP, groupId);
        DevopsServiceCacheHelper.getCache().removeSetValues(key, new String[]{groupId});
    }

    public static boolean containsIndcitorsCaptureGroup(String groupId) {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_INDCITORSCAPTUREGROUP, groupId);
        Object[] setValues = DevopsServiceCacheHelper.getCache().getSetValues(key);
        return ArrayUtils.contains((Object[])setValues, (Object)groupId);
    }

    public static void putIndcitorsCleanTime() {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_INDCITORSCLEANTIME);
        DevopsServiceCacheHelper.getCache().put(key, (Object)String.valueOf(WfUtils.now().getTime()), 86400);
    }

    public static Long getIndcitorsCleanTime() {
        String key = DevopsServiceCacheHelper.getWholeKey(CACHEKEY_INDCITORSCLEANTIME);
        return WfUtils.isNotEmpty((String)((String)DevopsServiceCacheHelper.getCache().get(key))) ? Long.valueOf((String)DevopsServiceCacheHelper.getCache().get(key)) : null;
    }

    public static void putRedisIndicatorInfo(String number, String dimvalue, int count, int limit) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(number);
        Map allInfos = DevopsServiceCacheHelper.getCache().getAll(cacheKey);
        int tmp = WfUtils.isNotEmpty((String)((String)allInfos.get(dimvalue))) ? Integer.parseInt((String)allInfos.get(dimvalue)) : 0;
        allInfos.put(dimvalue, String.valueOf(tmp + count));
        if (allInfos.size() > limit) {
            List<String> removeList = allInfos.keySet().stream().sorted().limit(allInfos.size() - limit).collect(Collectors.toList());
            DevopsServiceCacheHelper.getCache().remove(cacheKey, removeList.toArray(new String[0]));
        }
        DevopsServiceCacheHelper.getCache().put(cacheKey, dimvalue, (Object)String.valueOf(tmp + count));
    }

    public static Map<String, String> getRedisIndicatorInfos(String number) {
        String cacheKey = DevopsServiceCacheHelper.getWholeKey(number);
        return DevopsServiceCacheHelper.getCache().getAll(cacheKey);
    }
}

