/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.api.ISpecialDataCapture;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.statisticalanalysis.captures.AbstractOperationCapture;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class CollectAndStatisticsIndicatorCmd
implements Command<Integer> {
    private Log logger = LogFactory.getLog(CollectAndStatisticsIndicatorCmd.class);
    private int collectLimit;
    private List<String> numbers;

    public CollectAndStatisticsIndicatorCmd(List<String> numbers, int collectLimit) {
        this.collectLimit = collectLimit;
        this.numbers = numbers;
    }

    public Integer execute(CommandContext commandContext) {
        DevopsIndicatorEntityManager entityManager = (DevopsIndicatorEntityManager)commandContext.getEntityManager(DevopsIndicatorEntityManager.class);
        long startTime3 = System.currentTimeMillis();
        List<DynamicObject> indicatorEntitys = this.findCanCaptureIndicator();
        this.logger.info("\u6307\u6807\u67e5\u8be2\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime3));
        if (indicatorEntitys.isEmpty()) {
            return 0;
        }
        List<IndicatorByGroupInfo> indicatorByGroupInfos = this.getIndicatorsGroupByNumberAndType(indicatorEntitys);
        this.logger.info("indicatorByGroupInfo size:" + indicatorByGroupInfos.size());
        HashSet successIds = new HashSet();
        HashSet faliIds = new HashSet();
        long startTime = System.currentTimeMillis();
        indicatorByGroupInfos.forEach(indicatorByGroupInfo -> {
            try {
                if (indicatorByGroupInfo.getInfo() != null) {
                    DevopsUtils.getWorkflowDevopsService().captureIndicatorInfo(indicatorByGroupInfo.getInfo());
                }
                successIds.addAll(indicatorByGroupInfo.getIds() == null ? new ArrayList() : indicatorByGroupInfo.getIds());
            }
            catch (Exception e) {
                faliIds.addAll(indicatorByGroupInfo.getIds() == null ? new ArrayList() : indicatorByGroupInfo.getIds());
                this.logger.info("\u6536\u96c6\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        });
        this.logger.info("\u6307\u6807\u6536\u96c6\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startTime) + "\u6307\u6807\u5206\u7ec4\u4e2a\u6570\uff1a" + indicatorByGroupInfos.size());
        if (!successIds.isEmpty()) {
            entityManager.deleteDevopsIndicatorsByIds(new ArrayList<Long>(successIds));
        }
        if (!faliIds.isEmpty()) {
            entityManager.batchUpdateDevopsIndicatorsSendTimes(new ArrayList<Long>(faliIds));
        }
        return successIds.size() + faliIds.size();
    }

    private List<DynamicObject> findCanCaptureIndicator() {
        boolean flag = true;
        Long id = 0L;
        ArrayList<DynamicObject> entitys = new ArrayList<DynamicObject>(this.collectLimit);
        DevopsIndicatorEntityManager devopsIndicatorEntityManager = (DevopsIndicatorEntityManager)Context.getCommandContext().getEntityManager(DevopsIndicatorEntityManager.class);
        while (flag) {
            DynamicObjectCollection indicators = devopsIndicatorEntityManager.findIndicatorsToCollect(id, this.numbers, "createDate", this.collectLimit);
            entitys.addAll(indicators.stream().filter(entity -> entity.getDate("createDate").getTime() + (long)(entity.getInt("sendtimes") * 12 * 60 * 60) * 1000L < System.currentTimeMillis() && entity.getInt("sendtimes") < 4).collect(Collectors.toList()));
            if (indicators.size() < this.collectLimit || entitys.size() >= this.collectLimit) {
                flag = false;
            }
            if (!WfUtils.isNotEmptyForCollection((Collection)indicators)) continue;
            id = ((DynamicObject)indicators.get(indicators.size() - 1)).getLong("id");
        }
        return entitys;
    }

    private List<IndicatorByGroupInfo> getIndicatorsGroupByNumberAndType(List<DynamicObject> indicatorEntitys) {
        HashMap<String, IndicatorByGroupInfo> map = new HashMap<String, IndicatorByGroupInfo>(indicatorEntitys.size());
        DevopsIndicatorEntityManager entityManager = (DevopsIndicatorEntityManager)Context.getCommandContext().getEntityManager(DevopsIndicatorEntityManager.class);
        for (DynamicObject dynObj : indicatorEntitys) {
            try {
                List<IndicatorInfo> needGroupIndicators;
                IDataCapture dataCaptureInterface = DataCaptureFactory.getDataCaptureInterface(dynObj.getString("number"));
                if (dataCaptureInterface instanceof AbstractOperationCapture && !(needGroupIndicators = ((AbstractOperationCapture)dataCaptureInterface).getGroupAndSelfIndicatorInfos((DevopsIndicatorEntity)entityManager.create(dynObj))).isEmpty()) {
                    needGroupIndicators.stream().filter(Objects::nonNull).forEach(info -> this.groupByIndicator((Map<String, IndicatorByGroupInfo>)map, dataCaptureInterface, dynObj, (IndicatorInfo)info));
                    continue;
                }
                this.groupByIndicator(map, dataCaptureInterface, dynObj, null);
                if (map.size() <= 2000) continue;
                break;
            }
            catch (Exception e) {
                this.logger.info("WfDevopsConsumer_getIndicatorsGroupByNumberAndType: \u5206\u7c7b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return new ArrayList<IndicatorByGroupInfo>(map.values());
    }

    private void groupByIndicator(Map<String, IndicatorByGroupInfo> map, IDataCapture dataCaptureInterface, DynamicObject indicatorEntity, IndicatorInfo indicatorInfo) {
        String key = indicatorInfo != null ? indicatorInfo.getNumber() + "." + Optional.ofNullable(indicatorInfo.getDimValue()).orElseGet(() -> "") : indicatorEntity.getString("number") + '.' + Optional.ofNullable(indicatorEntity.getString("dimvalue")).orElseGet(() -> "");
        IndicatorByGroupInfo indicatorByGroupInfo = map.get(key);
        if (indicatorByGroupInfo == null) {
            indicatorInfo = Optional.ofNullable(indicatorInfo).orElseGet(() -> dataCaptureInterface.build(((DevopsIndicatorEntityManager)Context.getCommandContext().getEntityManager(DevopsIndicatorEntityManager.class)).create(indicatorEntity)));
            ArrayList<Long> temp = new ArrayList<Long>(100);
            temp.add(indicatorEntity.getLong("id"));
            IndicatorByGroupInfo info = new IndicatorByGroupInfo(indicatorInfo, temp);
            if (indicatorInfo != null && dataCaptureInterface instanceof AbstractOperationCapture && ((AbstractOperationCapture)dataCaptureInterface).canGroupByNumberAndDim().booleanValue()) {
                map.put(key, info);
            } else {
                map.put(String.valueOf(indicatorEntity.getLong("id")), info);
            }
        } else {
            IDataCapture otherDataCaptureInterface;
            IndicatorInfo info = indicatorByGroupInfo.getInfo();
            info.setAddCount(info.getAddCount() + (indicatorInfo != null ? indicatorInfo.getAddCount() : indicatorEntity.getInt("count")));
            indicatorByGroupInfo.getIds().add(indicatorEntity.getLong("id"));
            if (indicatorInfo != null && indicatorInfo.getNumber() != null && map.get(key) != null && (otherDataCaptureInterface = DataCaptureFactory.getDataCaptureInterface(indicatorInfo.getNumber())) instanceof ISpecialDataCapture) {
                map.get(key).setInfo(((ISpecialDataCapture)otherDataCaptureInterface).countSpecialProperty(map.get(key).getInfo(), indicatorEntity));
            }
        }
    }

    static class IndicatorByGroupInfo {
        private List<Long> ids;
        private IndicatorInfo info;

        public IndicatorByGroupInfo(IndicatorInfo info, List<Long> ids) {
            this.info = info;
            this.ids = ids;
        }

        public List<Long> getIds() {
            return this.ids;
        }

        public void setIds(List<Long> ids) {
            this.ids = ids;
        }

        public IndicatorInfo getInfo() {
            return this.info;
        }

        public void setInfo(IndicatorInfo info) {
            this.info = info;
        }
    }
}

