/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.devops.pojo.AlarmReceiver;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfAdminUtil;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class FindAlarmMessageReceiverCmd
implements Command<List<Long>> {
    private String alarmSetting;
    private String userIdStr;
    private boolean wfAdmin;
    private boolean initiator;
    private Map<String, Object> params;

    public FindAlarmMessageReceiverCmd(String alarmSetting, Map<String, Object> params) {
        this.alarmSetting = alarmSetting;
        this.params = Optional.ofNullable(params).orElseGet(HashMap::new);
    }

    public FindAlarmMessageReceiverCmd(String userIdStr, Boolean wfAdmin, Map<String, Object> params) {
        this.userIdStr = userIdStr;
        this.wfAdmin = wfAdmin;
        this.params = Optional.ofNullable(params).orElseGet(HashMap::new);
    }

    public List<Long> execute(CommandContext commandContext) {
        HashSet<Long> userIds = new HashSet<Long>();
        if (StringUtils.isNotBlank((CharSequence)this.alarmSetting)) {
            this.getUserSettingFromStr();
        }
        userIds.addAll(this.getFromUserIds());
        userIds.addAll(this.getFromWfAdmin());
        userIds.addAll(this.getFromInitiator());
        return new ArrayList<Long>(userIds);
    }

    private Collection<Long> getFromWfAdmin() {
        Set<Long> userIds = new HashSet<Long>();
        if (this.wfAdmin) {
            Long processDefinitionId = this.params.get("processDefinitionId") != null ? (Long)this.params.get("processDefinitionId") : 0L;
            userIds = Context.getCommandContext().getAdministratorEntityManager().findAdminsByProcessDefinitionId(processDefinitionId);
            userIds.addAll(WfAdminUtil.getUserIdsFromAppEntry((Long)processDefinitionId));
        }
        return userIds;
    }

    private List<Long> getFromUserIds() {
        return DevopsUtils.formatArrStrToSLongList(this.userIdStr, ",");
    }

    private List<Long> getFromInitiator() {
        if (this.initiator && this.params.get("initiator") != null) {
            Long submitter = (Long)this.params.get("initiator");
            return Lists.newArrayList((Object[])new Long[]{submitter});
        }
        return new ArrayList<Long>(0);
    }

    private void getUserSettingFromStr() {
        AlarmReceiver alarmReceiver = (AlarmReceiver)SerializationUtils.fromJsonString((String)this.alarmSetting, AlarmReceiver.class);
        this.userIdStr = alarmReceiver.getUserIds();
        this.wfAdmin = alarmReceiver.getWfadmin();
        this.initiator = alarmReceiver.getInitiator();
    }
}

