/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.api.IDataCapture;
import kd.bos.workflow.devops.statisticalanalysis.DataCaptureFactory;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.MultiLangEnumBridge;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import org.apache.commons.lang.time.DateFormatUtils;

public class GetReportDatasCmd
implements Command<List<IndicatorInfo>> {
    public List<IndicatorInfo> execute(CommandContext commandContext) {
        Map<String, IDataCapture> capturesMap = DataCaptureFactory.getCapturesMap();
        ArrayList<IndicatorInfo> result = new ArrayList<IndicatorInfo>(capturesMap.size());
        capturesMap.forEach((number, dataCapture) -> {
            if (dataCapture.isReportData()) {
                result.addAll(dataCapture.fetch((String)number, null));
            }
        });
        this.addCustomIndicators(result);
        return result;
    }

    private void addCustomIndicators(List<IndicatorInfo> result) {
        result.add(this.getDataInRecent7Days("processInstanceDaily"));
        result.addAll(this.getThreeMonthsProcessExceptions());
        result.add(this.getDataInRecent7Days("becInstanceDaily"));
    }

    private IndicatorInfo getDataInRecent7Days(String number) {
        IndicatorInfo indicatorInfo = null;
        String dimValue = new StringJoiner("-").add(DateFormatUtils.format((Date)this.getDateBefore7Days(), (String)"yyyyMMdd")).add(DateFormatUtils.format((Date)new Date(WfUtils.now().getTime() + 86400000L), (String)"yyyyMMdd")).toString();
        List<IndicatorInfo> indicatorInfos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo(number, dimValue);
        Long total = 0L;
        for (IndicatorInfo info : indicatorInfos) {
            if (indicatorInfo == null) {
                indicatorInfo = info.clone();
            }
            total = total + info.getTotal();
        }
        if (indicatorInfo != null) {
            indicatorInfo.setTotal(Long.valueOf(total / 7L));
        }
        return indicatorInfo;
    }

    private List<IndicatorInfo> getThreeMonthsProcessExceptions() {
        String dimValue = new StringJoiner("-").add(DateFormatUtils.format((Date)DevopsUtils.getDateBeforeThreeMonths(), (String)"yyyyMMdd")).add(DateFormatUtils.format((Date)new Date(WfUtils.now().getTime() + 86400000L), (String)"yyyyMMdd")).toString();
        List<IndicatorInfo> indicatorInfos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo("expectionProcessDaily", dimValue);
        if (WfUtils.isNotEmptyForCollection(indicatorInfos)) {
            indicatorInfos.forEach(info -> {
                if (ErrortypeEnum.getErrortypeByNumber((String)info.getDimValue()) != null) {
                    info.setDimDisplayValue((ILocaleString)ErrortypeEnum.getErrortypeByNumber((String)info.getDimValue()).getName().toLocaleString());
                }
            });
        }
        return indicatorInfos;
    }

    private Date getDateBefore7Days() {
        Date now = WfUtils.now();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        calendar.add(5, -7);
        return calendar.getTime();
    }

    static enum ErrortypeEnum {
        ENGINE("engine", new MultiLangEnumBridge("\u5f15\u64ce\u5f02\u5e38", "DeadLetterJobPieChartPlugin_0", "bos-wf-devops")),
        NULLPARTICIPANT("nullParticipant", new MultiLangEnumBridge("\u53c2\u4e0e\u4eba\u4e3a\u7a7a\u5f02\u5e38", "DeadLetterJobPieChartPlugin_1", "bos-wf-devops")),
        BUSINESS("business", new MultiLangEnumBridge("\u4e1a\u52a1\u8c03\u7528\u5f02\u5e38", "DeadLetterJobPieChartPlugin_2", "bos-wf-devops")),
        CONDITIONPARSE("conditionParse", new MultiLangEnumBridge("\u6761\u4ef6\u89e3\u6790\u5f02\u5e38", "DeadLetterJobPieChartPlugin_3", "bos-wf-devops")),
        MESSAGESERVICE("messageService", new MultiLangEnumBridge("\u6d88\u606f\u5f02\u5e38", "DeadLetterJobPieChartPlugin_4", "bos-wf-devops")),
        CONFIGURATION("configuration", new MultiLangEnumBridge("\u914d\u7f6e\u5f02\u5e38", "DeadLetterJobPieChartPlugin_5", "bos-wf-devops")),
        OUTSET("outSet", new MultiLangEnumBridge("\u51fa\u53e3\u7ebf\u5f02\u5e38", "DeadLetterJobPieChartPlugin_6", "bos-wf-devops")),
        SUBPROCESS("subProcess", new MultiLangEnumBridge("\u5b50\u6d41\u7a0b\u8fd0\u884c\u5f02\u5e38", "DeadLetterJobPieChartPlugin_7", "bos-wf-devops")),
        NOTFINDSUBPROCESS("notFindSubprocess", new MultiLangEnumBridge("\u542f\u52a8\u5b50\u6d41\u7a0b\u5f02\u5e38", "DeadLetterJobPieChartPlugin_8", "bos-wf-devops")),
        BILLCALC("billCalc", new MultiLangEnumBridge("\u5355\u636e\u8ba1\u7b97\u5f02\u5e38", "DeadLetterJobPieChartPlugin_9", "bos-wf-devops")),
        CYCLENUMBERSEXCEED("cycleNumbersExceed", new MultiLangEnumBridge("\u5faa\u73af\u6b21\u6570\u8d85\u51fa\u5f02\u5e38", "DeadLetterJobPieChartPlugin_10", "bos-wf-devops")),
        RPA("rpa", new MultiLangEnumBridge("RPA\u5f02\u5e38", "DeadLetterJobPieChartPlugin_11", "bos-wf-devops")),
        TARGETBILLFILTER("targetBillFilter", new MultiLangEnumBridge("\u76ee\u6807\u5355\u8fc7\u6ee4\u5f02\u5e38", "DeadLetterJobPieChartPlugin_13", "bos-wf-devops"));

        String number;
        MultiLangEnumBridge name;

        private ErrortypeEnum(String number, MultiLangEnumBridge name) {
            this.number = number;
            this.name = name;
        }

        public String getNumber() {
            return this.number;
        }

        public MultiLangEnumBridge getName() {
            return this.name;
        }

        public static ErrortypeEnum getErrortypeByNumber(String number) {
            return Stream.of(ErrortypeEnum.values()).filter(each -> each.getNumber().equals(number)).findFirst().orElse(null);
        }
    }
}

