/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devops.cmd.SendAlarmMessageCmd;
import kd.bos.workflow.devops.enums.AlarmRule;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class NotifySubmitterProcessNotEnteredCmd
implements Command<Long> {
    private static final Log logger = LogFactory.getLog(NotifySubmitterProcessNotEnteredCmd.class);
    private final DynamicObject businessModel;
    private final ProcessNotExistPoJo poJo;
    public static final String CODE_PREFIX = "NOT_ENTERED";

    public NotifySubmitterProcessNotEnteredCmd(DynamicObject businessModel, ProcessNotExistPoJo poJo) {
        this.businessModel = businessModel;
        this.poJo = poJo;
    }

    public Long execute(CommandContext commandContext) {
        AlarmRule alarmRule;
        ProcessNotExistReasonEnum errorReason = this.poJo.getErrorReason();
        LocaleString title = new LocaleString();
        LocaleString content = new LocaleString();
        LocaleString displayName = this.businessModel.getDataEntityType().getDisplayName();
        switch (errorReason) {
            case NOT_FIND: {
                alarmRule = AlarmRule.NOT_FIND;
                title = ResManager.getLocaleString((String)"\u201c%1$s%2$s\u201d\u6ca1\u6709\u8fdb\u5165\u6d41\u7a0b\uff0c\u539f\u56e0\uff1a\u672a\u627e\u5230\u6ee1\u8db3\u542f\u52a8\u6761\u4ef6\u7684\u6d41\u7a0b\u3002", (String)"NotifySubmitterProcessNotEnteredCmd_1", (String)"bos-wf-devops");
                content = title = WfMultiLangUtils.replaceILocaleString((ILocaleString)title, (ILocaleString[])new ILocaleString[]{displayName, new LocaleString(this.poJo.getBillno())});
                break;
            }
            case CONFLICT: {
                alarmRule = AlarmRule.CONFLICT;
                title = ResManager.getLocaleString((String)"\u201c%1$s%2$s\u201d\u6ca1\u6709\u8fdb\u5165\u6d41\u7a0b\uff0c\u539f\u56e0\uff1a\u627e\u5230%3$s\u6761\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u3002", (String)"NotifySubmitterProcessNotEnteredCmd_2", (String)"bos-wf-devops");
                displayName = this.businessModel.getDataEntityType().getDisplayName();
                Object data = this.poJo.getPayload().getData();
                List<Long> definitionList = this.calDefinitionList(data);
                title = WfMultiLangUtils.replaceILocaleString((ILocaleString)title, (ILocaleString[])new ILocaleString[]{displayName, new LocaleString(this.poJo.getBillno()), new LocaleString(definitionList.size() + "")});
                QFilter qFilter = new QFilter("id", "in", definitionList);
                List entities = commandContext.getProcessDefinitionEntityManager().findByQueryFilters(qFilter.toArray());
                List collect = entities.stream().map(item -> {
                    ArrayList<Object> iLocaleStrings = new ArrayList<Object>();
                    LocaleString number = new LocaleString(item.getKey());
                    LocaleString version = new LocaleString(item.getVersion());
                    iLocaleStrings.add(number);
                    iLocaleStrings.add(item.getName());
                    iLocaleStrings.add(version);
                    ILocaleString iLocaleString = WfMultiLangUtils.jointCollectionLocaleString(iLocaleStrings, (String)"/");
                    return WfMultiLangUtils.jointILocaleString((ILocaleString)iLocaleString, (ILocaleString)new LocaleString("\r\n"), (String)"");
                }).collect(Collectors.toList());
                content = ResManager.getLocaleString((String)"\u5355\u636e\u201c%1$s%2$s\u201d\u7531\u4e8e\u7cfb\u7edf\u53c2\u6570\u5f00\u542f\u4e86\u201c\u5b58\u5728\u552f\u4e00\u6d41\u7a0b\u65f6\u542f\u52a8\u201d\uff0c\u5e76\u4e14\u5728\u5bfb\u5740\u65f6\u627e\u5230%3$s\u6761\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\uff0c\u6240\u4ee5\u6ca1\u6709\u8fdb\u5165\u6d41\u7a0b\u3002%4$s\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b\u6709\uff1a%5$s\u3002%4$s%4$s", (String)"NotifySubmitterProcessNotEnteredCmd_3", (String)"bos-wf-devops");
                ILocaleString alterNativeList = WfMultiLangUtils.jointCollectionLocaleString(collect, (String)"\r\n");
                content = WfMultiLangUtils.replaceILocaleString((ILocaleString)content, (ILocaleString[])new ILocaleString[]{displayName, new LocaleString(this.poJo.getBillno()), new LocaleString(definitionList.size() + ""), new LocaleString("\r\n"), alterNativeList});
                break;
            }
            case ERROR_ADDRESS: {
                alarmRule = AlarmRule.ERROR_ADDRESS;
                title = ResManager.getLocaleString((String)"\u201c%1$s%2$s\u201d\u6ca1\u6709\u8fdb\u5165\u6d41\u7a0b\uff0c\u539f\u56e0\uff1a\u5bfb\u5740\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (String)"NotifySubmitterProcessNotEnteredCmd_4", (String)"bos-wf-devops");
                displayName = this.businessModel.getDataEntityType().getDisplayName();
                content = title = WfMultiLangUtils.replaceILocaleString((ILocaleString)title, (ILocaleString[])new ILocaleString[]{displayName, new LocaleString(this.poJo.getBillno())});
                break;
            }
            default: {
                alarmRule = AlarmRule.NOT_FIND;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("initiator", this.poJo.getSubmitterId());
        return new SendAlarmMessageCmd(alarmRule.getValue(), this.groupCode(), (ILocaleString)title, (ILocaleString)content, map).execute(commandContext);
    }

    public ILocaleString jointILocaleString(ILocaleString str1, ILocaleString str2, String delimiter) {
        if (WfUtils.isEmpty((ILocaleString)str1)) {
            return str2;
        }
        LocaleString newStr = new LocaleString();
        for (Lang lang : WfUtils.getSupportLangs()) {
            String lan = lang.toString();
            String arg1 = WfUtils.isEmpty((String)((String)str1.get((Object)lan))) ? str1.toString() : (String)str1.get((Object)lan);
            String arg2 = WfUtils.isEmpty((String)((String)str2.get((Object)lan))) ? str2.toString() : (String)str2.get((Object)lan);
            newStr.setItem(lan, (Object)String.format("%s%s%s", arg1, delimiter, arg2));
        }
        return newStr;
    }

    public String groupCode() {
        return "NOT_ENTERED::" + this.poJo.getEntityNumber() + "::" + this.poJo.getBusinessKey();
    }

    public List<Long> calDefinitionList(Object o) {
        try {
            return (List)o;
        }
        catch (Throwable error) {
            logger.warn(error);
            return new ArrayList<Long>(0);
        }
    }
}

