/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.WFDevopsUtils;
import kd.bos.workflow.devopos.WorkflowDevopsService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.entity.RecoverSysErrorEntity;
import kd.bos.workflow.devops.entity.RecoverSysErrorEntityManager;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.job.DeadLetterJobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;
import kd.bos.workflow.engine.impl.persistence.entity.runtime.ExecutionEntity;
import kd.bos.workflow.engine.impl.util.RuntimeUtil;
import kd.bos.workflow.exception.WFErrorCode;
import org.apache.commons.collections.map.HashedMap;

public class RecoverSysErrorProcessInstanceCmd
implements Command<String> {
    private Log logger = LogFactory.getLog(RecoverSysErrorProcessInstanceCmd.class);
    private static final String CREATEDATE = "createdate";
    private static final String LOCKEXPIRATIONTIME = "lockexpirationtime";
    private static final int RECOVERSIZE = 500;
    private static final String RECOVERID = "recoverid";
    private static final String CACHEJOBID = "jobid";
    private Date createDate;

    public String execute(CommandContext commandContext) {
        try {
            this.logger.info("RecoverSysErrorProcessInstanceCmd start");
            this.createDate = new Date();
            int recoversize = WfConfigurationUtil.getRepairSysErrorProcessInstancesSize();
            recoversize = recoversize > 0 ? recoversize : 500;
            ArrayList<RecoverDetailInfo> details = new ArrayList<RecoverDetailInfo>(recoversize);
            details.addAll(this.recoverDeadLetterJob(commandContext, recoversize));
            Object processInstanceId = null;
            if (WfConfigurationUtil.isAutoRepairSysErrorRecordJob() && details.size() < recoversize) {
                List<RecoverDetailInfo> recoverDetailInfos = this.revocerAbnormalJob(commandContext, recoversize - details.size());
                details.addAll(recoverDetailInfos);
            }
            Long logId = this.saveData(this.createDate, details);
            if (details.size() < recoversize) {
                WfCacheHelper.removeAutoRecoverSysErrorProcsSign();
                DevopsServiceCacheHelper.removeRecoverSysErrorProcessinstance();
            }
            this.logger.info("RecoverSysErrorProcessInstanceCmd end");
        }
        catch (Exception e) {
            WfCacheHelper.removeAutoRecoverSysErrorProcsSign();
            this.logger.warn("RecoverSysErrorProcessInstanceCmd-\u6062\u590d\u6302\u8d77\u6d41\u7a0b\u548c\u5f02\u5e38job\u5931\u8d25\uff0c\u9519\u8bef\u8be6\u60c5\uff1a" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return null;
    }

    private Long saveData(Date now, List<RecoverDetailInfo> details) {
        if (details.isEmpty()) {
            return 0L;
        }
        Date end = new Date();
        Long duration = end.getTime() - now.getTime();
        String detailInfos = this.getDetailInfos(details);
        RecoverSysErrorEntityManager entityManager = (RecoverSysErrorEntityManager)Context.getCommandContext().getEntityManager(RecoverSysErrorEntityManager.class);
        RecoverSysErrorEntity entity = (RecoverSysErrorEntity)entityManager.create();
        Long id = this.getId();
        entity.setId(id);
        entity.setStartDate(now);
        entity.setEndDate(end);
        entity.setDuration(duration);
        entity.setErrorType("syserror");
        entity.setFixtotal(Long.valueOf(details.size()));
        entity.setRecoverDetails(detailInfos);
        entityManager.insert(entity);
        return id;
    }

    private Long getId() {
        String id = DevopsServiceCacheHelper.getRecoverSysErrorProcessinstance(RECOVERID);
        if (StringUtils.isNotBlank((CharSequence)id)) {
            return Long.valueOf(id);
        }
        long logId = DB.genGlobalLongId();
        DevopsServiceCacheHelper.putRecoverSysErrorProcessinstance(RECOVERID, String.valueOf(logId));
        return logId;
    }

    private String getDetailInfos(List<RecoverDetailInfo> details) {
        String detailInfos = "";
        if (!details.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            HashMap temp = new HashMap(details.size());
            details.forEach(detail -> {
                if (StringUtils.isBlank((CharSequence)detail.getBillno())) {
                    String billNo = "";
                    if (StringUtils.isNotBlank((CharSequence)((CharSequence)temp.get(detail.getExecutionId())))) {
                        billNo = (String)temp.get(detail.getExecutionId());
                    } else if (StringUtils.isNotBlank((Object)detail.getExecutionId())) {
                        ExecutionEntity execution = (ExecutionEntity)Context.getCommandContext().getExecutionEntityManager().findById(detail.getExecutionId());
                        billNo = execution != null ? execution.getBillNo() : "";
                        temp.put(detail.getExecutionId(), billNo);
                    }
                    if (StringUtils.isBlank((CharSequence)billNo) && StringUtils.isNotBlank((CharSequence)detail.getEntityNumber())) {
                        billNo = TaskBehaviorUtil.getTaskBillNo((String)detail.getEntityNumber(), (String)detail.getBusinessKey());
                    }
                    detail.setBillno(billNo);
                }
                sb.append(detail.toString());
                sb.append(";");
                sb.append("\r\n");
            });
            detailInfos = sb.substring(0, sb.length() - "\r\n".length() - 1);
        }
        return detailInfos;
    }

    private List<RecoverDetailInfo> recoverDeadLetterJob(CommandContext commandContext, int size) {
        ArrayList<RecoverDetailInfo> details = new ArrayList<RecoverDetailInfo>();
        EntityQueryBuilder deadJobEqb = commandContext.getDeadLetterJobEntityManager().createQueryBuilder();
        deadJobEqb.addFilter(CREATEDATE, ">=", (Object)this.getYesterday()).addFilter(CREATEDATE, "<", (Object)new Date()).addFilter("processtype", "!=", (Object)ModelType.NoCodeFlow.name()).addFilter("errorcode", "=", (Object)WFErrorCode.jobUnKnowError().getCode()).orderBy("id desc").setLimit(size);
        List ret = commandContext.getDeadLetterJobEntityManager().findByQueryBuilder(deadJobEqb);
        if (ret != null && !ret.isEmpty()) {
            ret.stream().filter(entity -> WfUtils.isNotEmpty((String)entity.getBusinessKey()) && WfUtils.isNotEmpty((ILocaleString)entity.getKeyversion())).forEach(deadLetterJobEntity -> {
                JobEntity jobEntity = commandContext.getJobManager().moveDeadLetterJobToExecutableJob(deadLetterJobEntity, 3);
                String[] arr = deadLetterJobEntity.getKeyversion().getLocaleValue().split("/");
                details.add(new RecoverDetailInfo(jobEntity.getBusinessKey(), arr[0]));
            });
            this.createDate = ((DeadLetterJobEntity)ret.get(ret.size() - 1)).getCreateDate();
            this.collectDeadLetterJobMessageData(ret);
        }
        this.logger.info("RecoverSysErrorProcessInstanceCmd_move jobs's size is : " + details.size());
        return details;
    }

    private List<RecoverDetailInfo> revocerAbnormalJob(CommandContext commandContext, int size) {
        ArrayList<RecoverDetailInfo> details = new ArrayList<RecoverDetailInfo>();
        Date now = new Date();
        boolean needRecover = true;
        Long pkId = DevopsServiceCacheHelper.getRecoverSysErrorProcessinstance(CACHEJOBID) != null ? Long.valueOf(DevopsServiceCacheHelper.getRecoverSysErrorProcessinstance(CACHEJOBID)) : null;
        int flag = 0;
        while (needRecover) {
            ++flag;
            EntityQueryBuilder jobEqb = commandContext.getJobEntityManager().createQueryBuilder();
            Optional.ofNullable(pkId).ifPresent(id -> jobEqb.addFilter("id", "<", id));
            jobEqb.addFilter(LOCKEXPIRATIONTIME, ">=", (Object)this.getYesterday()).addFilter(LOCKEXPIRATIONTIME, "<=", (Object)now).addFilter("state", "in", (Object)new String[]{JobStateEnum.CREATED.getNumber(), JobStateEnum.PREEXECUTING.getNumber(), JobStateEnum.EXECUTING.getNumber()}).addFilter("jobhandlertype", "in", (Object)RuntimeUtil.getRunningJobStr()).addFilter("retries", "<=", (Object)3).orderBy("id desc").setLimit(size);
            List jobs = commandContext.getJobEntityManager().findByQueryBuilder(jobEqb);
            if (WfUtils.isNotEmptyForCollection((Collection)jobs) && flag <= 10) {
                jobs.stream().filter(job -> job.getRetries() < 3 || job.getRetries() == 3 && DevopsUtils.getTimeDifference(job.getCreateDate(), now) > 1800000L).forEach(job -> {
                    details.add(new RecoverDetailInfo(job.getBusinessKey(), null, job.getEntityNumber(), job.getExecutionId()));
                    JobUtil.sendJobToMQ((JobEntity)job);
                });
                pkId = ((JobEntity)jobs.get(jobs.size() - 1)).getId();
                this.createDate = ((JobEntity)jobs.get(jobs.size() - 1)).getCreateDate();
                continue;
            }
            needRecover = false;
        }
        if (details.isEmpty() && pkId != null) {
            DevopsServiceCacheHelper.putRecoverSysErrorProcessinstance(CACHEJOBID, String.valueOf(pkId));
        }
        this.logger.info("RecoverSysErrorProcessInstanceCmd_resend jobs's size is : " + details.size());
        return details;
    }

    private Date getYesterday() {
        Calendar c = Calendar.getInstance();
        c.add(5, -1);
        return c.getTime();
    }

    private void collectDeadLetterJobMessageData(List<DeadLetterJobEntity> jobs) {
        Date asyncMessageStartTime = WFDevopsUtils.getAsyncMessageStartTime();
        HashedMap deadJobs = new HashedMap(jobs.size());
        jobs.stream().filter(job -> job.getCreateDate().after(asyncMessageStartTime)).forEach(arg_0 -> RecoverSysErrorProcessInstanceCmd.lambda$collectDeadLetterJobMessageData$8((Map)deadJobs, arg_0));
        ArrayList infos = new ArrayList(jobs.size());
        deadJobs.forEach((key, value) -> {
            if ("address-process-event".equalsIgnoreCase((String)key)) {
                IndicatorInfo indicatorInfo = new IndicatorInfo("addressMessage", (Object)"fail", -value.intValue());
                infos.add(indicatorInfo);
            } else {
                IndicatorInfo indicatorInfo = new IndicatorInfo("asyncMessage", (Object)"fail", -value.intValue());
                indicatorInfo.addToSpecialProperty("processType", key);
                infos.add(indicatorInfo);
            }
        });
        WorkflowDevopsService.create().batchExceutionDataCollection(infos);
    }

    private static /* synthetic */ void lambda$collectDeadLetterJobMessageData$8(Map deadJobs, DeadLetterJobEntity job) {
        if ("address-process-event".equalsIgnoreCase(job.getJobHandlerType())) {
            deadJobs.merge("address-process-event", 1, Integer::sum);
        } else {
            Optional.ofNullable(job.getProcessType()).ifPresent(x -> deadJobs.merge(x, 1, Integer::sum));
        }
    }

    private static class RecoverDetailInfo {
        private String businessKey;
        private String billno;
        private String entityNumber;
        Long executionId;

        public RecoverDetailInfo(String businesskey, String billno) {
            this.billno = billno;
            this.businessKey = businesskey;
        }

        public RecoverDetailInfo(String businesskey, String billno, String entityNumber, Long executionId) {
            this.billno = billno;
            this.businessKey = businesskey;
            this.entityNumber = entityNumber;
            this.executionId = executionId;
        }

        public void setBillno(String billno) {
            this.billno = billno != null ? billno : "";
        }

        public String getBusinessKey() {
            return this.businessKey;
        }

        public Long getExecutionId() {
            return this.executionId;
        }

        public String getBillno() {
            return this.billno;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public String toString() {
            return String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\uff1a%1$s\uff0c\u4e1a\u52a1\u4e3b\u952e\uff1a%2$s", (String)"RecoverSysErrorProcessInstanceCmd_0", (String)"bos-wf-devops", (Object[])new Object[0]), this.billno, this.businessKey);
        }
    }
}

