/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.enums.DevopsErrorCode;
import kd.bos.workflow.engine.WfUtils;

public class RegistToScheduleCheckCmd {
    private static final String ENDDATE = "enddate";
    private static final String STATE = "state";
    private static final String PARENTID = "parentid";
    private Boolean isSuccess;
    private String exception;

    public RegistToScheduleCheckCmd(Boolean isSuccess, String exception) {
        this.isSuccess = isSuccess;
        this.exception = exception;
    }

    public void execute() {
        if (this.isSuccess.booleanValue()) {
            QFilter f1 = new QFilter("errorcode", "=", (Object)DevopsErrorCode.REGISTERERROR.getErrorNumber());
            QFilter f2 = new QFilter(ENDDATE, "is null", null);
            Object[] objs = BusinessDataServiceHelper.load((String)"wf_schedulemqmanage", (String)ENDDATE, (QFilter[])new QFilter[]{f2, f1});
            if (WfUtils.isNotEmptyForArrays((Object[])objs)) {
                for (int i = 0; i < objs.length; ++i) {
                    objs[i].set(ENDDATE, (Object)new Date());
                }
                SaveServiceHelper.update((DynamicObject[])objs);
            }
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"wf_schedulemqmanage");
            DynamicObject entity = new DynamicObject((DynamicObjectType)dataEntityType);
            AppInfo appInfo = AppMetadataCache.getAppInfo((String)"wf");
            entity.set("appname", (Object)appInfo.getName());
            entity.set("appid", (Object)"wf");
            entity.set("startdate", (Object)new Date());
            entity.set("errorcode", (Object)DevopsErrorCode.REGISTERERROR.getErrorNumber());
            entity.set("errortype", (Object)DevopsErrorCode.REGISTERERROR.getErrorType());
            entity.set(STATE, (Object)"error");
            entity.set("errorinfo", (Object)DevopsErrorCode.REGISTERERROR.getErrorDesc());
            entity.set("errorinfo_tag", (Object)(DevopsErrorCode.REGISTERERROR.getErrorDesc() + this.exception));
            Long parentId = this.getCurrentMonitorParentId();
            entity.set(PARENTID, (Object)parentId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{entity});
        }
    }

    protected Long getCurrentMonitorParentId() {
        String parentId = DevopsServiceCacheHelper.getMqAndScheduleMnoitorId();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            return Long.valueOf(parentId);
        }
        Object[] entitys = BusinessDataServiceHelper.load((String)"wf_schedulemqmanage", (String)PARENTID, null, (String)"id desc", (int)1);
        Long pid = WfUtils.isNotEmptyForArrays((Object[])entitys) ? Long.valueOf(entitys[0].getLong(PARENTID)) : Long.valueOf(DB.genGlobalLongId());
        DevopsServiceCacheHelper.putMqAndScheduleMnoitorId(String.valueOf(pid));
        return pid;
    }
}

