/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.BatchOptionResult;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.workflow.devops.enums.ReAddressType;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.pojo.AddressParam;

public class RestartProcessesCmd
implements Command<BatchOptionResult<String>> {
    public static final Log logger = LogFactory.getLog(RestartProcessesCmd.class);
    private final List<AddressParam> params;
    private final ReAddressType reAddressType;

    public RestartProcessesCmd(List<AddressParam> params, ReAddressType reAddressType) {
        this.params = params;
        this.reAddressType = reAddressType;
    }

    public BatchOptionResult<String> execute(CommandContext commandContext) {
        BatchOptionResult result = new BatchOptionResult();
        if (this.params == null) {
            return result;
        }
        List logs = this.params.stream().map(item -> {
            String desc = this.reAddressType.desc();
            String format = String.format(desc, item.getBillno());
            String opName = this.reAddressType.opName();
            return this.buildLogInfo(item.getEntityNumber(), opName, format);
        }).collect(Collectors.toList());
        LogServiceHelper.addBatchLog(logs);
        return this.restartProcess(commandContext);
    }

    private BatchOptionResult<String> restartProcess(CommandContext commandContext) {
        final ArrayList<JobEntity> jobs = new ArrayList<JobEntity>(this.params.size());
        int successCount = 0;
        int failCount = 0;
        for (AddressParam param : this.params) {
            Map variables = param.getVariables();
            if (variables == null) {
                logger.debug(param + "variables==null\u91cd\u8bd5\u5931\u8d25");
                ++failCount;
                continue;
            }
            String operate = param.getOperate();
            if (StringUtils.isEmpty((CharSequence)operate)) {
                logger.debug(param + "operate isEmpty \u91cd\u8bd5\u5931\u8d25");
                ++failCount;
                continue;
            }
            JobEntity job = commandContext.getJobManager().createAddressMessageJob(param.getBusinessKey(), param.getOperate(), param.getEntityNumber(), variables);
            String handlerConfig = job.getJobHandlerConfiguration();
            if (WfUtils.isNotEmpty((String)handlerConfig)) {
                try {
                    Map payload = (Map)SerializationUtils.fromJsonString((String)handlerConfig, Map.class);
                    if (payload != null && payload.get("_requestContext_") != null) {
                        Map t = (Map)payload.get("_requestContext_");
                        if (t != null && !t.isEmpty()) {
                            Long submitterId = param.getSubmitterId();
                            t.put("userId", param.getSubmitterId() + "");
                            ILocaleString nameMulti = WfUtils.findUserName((Long)submitterId);
                            if (WfUtils.isNotEmpty((ILocaleString)nameMulti)) {
                                t.put("userName", nameMulti.getLocaleValue());
                            }
                        }
                        payload.put("_requestContext_", t);
                        job.setJobHandlerConfiguration(SerializationUtils.toJsonString((Object)payload));
                    }
                }
                catch (Exception e) {
                    logger.warn(handlerConfig + "\u683c\u5f0f\u9519\u8bef" + e);
                }
            }
            try {
                commandContext.getJobEntityManager().insert((Entity)job);
                jobs.add(job);
                ++successCount;
            }
            catch (Exception e) {
                logger.warn(param + "\u91cd\u8bd5\u5931\u8d25", (Throwable)e);
                ++failCount;
            }
        }
        commandContext.addCloseListener((CommandContextCloseListener)new DefaultCommandContextCloseListener(RestartProcessesCmd.class.getName()){

            public void closed(CommandContext commandContext) {
                JobUtil.sendJobToMQ((List)jobs);
                logger.debug("\u672a\u8fdb\u5165\u5355\u636e\u6d41\u7a0b\u91cd\u65b0\u5bfb\u5740,\u4e0d\u4fdd\u8bc1\u6210\u529f,\u5931\u8d25\u4e0d\u505a\u5904\u7406");
            }
        });
        return new BatchOptionResult().setFailCount(failCount).setSuccessCount(successCount);
    }

    private OpLogAppInfo buildLogInfo(String entityNumber, String opName, String opDescription) {
        OpLogAppInfo info = new OpLogAppInfo();
        info.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        info.setBizAppID("a479ec06000000ac");
        info.setBizObjID(entityNumber);
        info.setOrgID(Long.valueOf(RequestContext.get().getOrgId()));
        info.setOpTime(TimeServiceHelper.now());
        info.setOpName(opName);
        info.setOpDescription(opDescription);
        return info;
    }
}

