/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.cmd.SendAlarmMessageCmd;
import kd.bos.workflow.devops.entity.PluginExeDetailEntity;
import kd.bos.workflow.devops.entity.PluginExeDetailEntityManager;
import kd.bos.workflow.devops.entity.PluginExeSummaryEntityManager;
import kd.bos.workflow.devops.entity.PluginProcInfoEntity;
import kd.bos.workflow.devops.entity.PluginProcInfoEntityManager;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class SavePluginDataCmd
implements Command<Void> {
    private static Log logger = LogFactory.getLog(SavePluginDataCmd.class);
    private IndicatorInfo indicatorInfo;

    public SavePluginDataCmd(IndicatorInfo indicatorInfo) {
        this.indicatorInfo = indicatorInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Void execute(CommandContext commandContext) {
        Map allProperty = this.indicatorInfo.getSpecialProperty();
        boolean noErrorFlag = true;
        try (TXHandle tx = TX.requiresNew();){
            PluginExeDetailEntity pluginExeDetailEntity = ((PluginExeDetailEntityManager)commandContext.getEntityManager(PluginExeDetailEntityManager.class)).savePluginExeDetail(allProperty);
            ((PluginProcInfoEntityManager)commandContext.getEntityManager(PluginProcInfoEntityManager.class)).savePluginExeProcessInfo(pluginExeDetailEntity, allProperty);
            ((PluginExeSummaryEntityManager)commandContext.getEntityManager(PluginExeSummaryEntityManager.class)).savePluginExeSummary(pluginExeDetailEntity);
            tx.commit();
        }
        if (noErrorFlag) {
            try {
                String pluginNo = (String)allProperty.get("pluginno");
                String processNo = (String)allProperty.get("processno");
                Long duration = Long.parseLong(String.valueOf(allProperty.get("duration")));
                Long procdefId = Long.parseLong(String.valueOf(allProperty.get("procdefid")));
                logger.debug("send alarm msg procdefId:{}", (Object)procdefId);
                if (SavePluginDataCmd.isNeedSendAlarmMsg(commandContext, pluginNo, processNo, duration).booleanValue()) {
                    SavePluginDataCmd.sendAlarmMsg(commandContext, pluginNo, processNo, procdefId);
                }
            }
            catch (Exception e) {
                logger.warn("send alarm msg occurred exception:{}", (Object)WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
        return null;
    }

    private static Boolean isNeedSendAlarmMsg(CommandContext commandContext, String pluginNo, String processNo, Long duration) {
        boolean flag = Boolean.FALSE;
        Integer execfrequency = 0;
        Integer startValue = 0;
        Integer endValue = 0;
        Integer moreThanValue = 0;
        Map<String, Object> alarmSettingMap = SavePluginDataCmd.getAlarmSettingInfo();
        if (alarmSettingMap.size() > 0) {
            execfrequency = alarmSettingMap.get("execfrequency") == null ? 0 : Integer.parseInt(String.valueOf(alarmSettingMap.get("execfrequency")));
            if (alarmSettingMap.get("moreThanValue") != null) {
                moreThanValue = Integer.parseInt(String.valueOf(alarmSettingMap.get("moreThanValue")));
            } else {
                startValue = Integer.parseInt(String.valueOf(alarmSettingMap.get("startValue")));
                endValue = Integer.parseInt(String.valueOf(alarmSettingMap.get("endValue")));
            }
        }
        QFilter qFilterPluginNo = new QFilter("pluginno", "=", (Object)pluginNo);
        QFilter qFilterProcessNo = new QFilter("processno", "=", (Object)processNo);
        PluginProcInfoEntityManager pluginProcInfoEntityManager = (PluginProcInfoEntityManager)commandContext.getEntityManager(PluginProcInfoEntityManager.class);
        List pluginProcInfoEntityList = pluginProcInfoEntityManager.findByQueryFilters(new QFilter[]{qFilterPluginNo, qFilterProcessNo}, pluginProcInfoEntityManager.getSelectFields(), "");
        if (pluginProcInfoEntityList != null && pluginProcInfoEntityList.size() > 0) {
            Long exeTimes = ((PluginProcInfoEntity)pluginProcInfoEntityList.get(0)).getExecutedtimes();
            Long avaDuration = ((PluginProcInfoEntity)pluginProcInfoEntityList.get(0)).getAverageduration();
            if (exeTimes.intValue() < execfrequency) {
                flag = false;
            }
            if (moreThanValue != 0 && avaDuration >= (long)(moreThanValue * 60) * 1000L) {
                flag = true;
            } else if (startValue != 0 && endValue != 0 && avaDuration >= (long)(startValue * 60) * 1000L) {
                flag = true;
            }
        } else {
            flag = WfUtils.isNotEmpty((Long)duration) && (moreThanValue != 0 && duration >= (long)(moreThanValue * 60) * 1000L || startValue != 0 && duration >= (long)(startValue * 60) * 1000L) && execfrequency == 1;
        }
        return flag;
    }

    private static Map<String, Object> getAlarmSettingInfo() {
        HashMap<String, Object> ret = new HashMap<String, Object>(2);
        StringBuilder sql = new StringBuilder(" select  fid,fnumber,fname,fconfig from t_wf_alarmrule  where falarmscene=?  and fenable=? ");
        Object[] param = new Object[]{"plugintimeouterror", "1"};
        try (DataSet ds = DB.queryDataSet((String)"wf.devops.plugin.getSetting", (DBRoute)DBRoute.workflow, (String)sql.toString(), (Object[])param);){
            JSONObject commonf7Json;
            String jsonStr;
            JSONObject config;
            Iterator iter = ds.iterator();
            if (iter.hasNext() && (config = (JSONObject)SerializationUtils.fromJsonString((String)(jsonStr = ((Row)iter.next()).getString("fconfig")), JSONObject.class)) != null && (commonf7Json = config.getJSONObject("commonf7")) != null) {
                ret.put("execfrequency", commonf7Json.get((Object)"execfrequency"));
                ret.put("exectime", commonf7Json.get((Object)"exectime"));
                JSONObject displayJson = commonf7Json.getJSONObject("displayvalue");
                String realValue = "";
                if (displayJson != null) {
                    realValue = (String)displayJson.get((Object)RequestContext.get().getLang().name());
                }
                if (realValue.contains("~")) {
                    Integer startValue = Integer.parseInt(realValue.split("~")[0]);
                    Integer endValue = Integer.parseInt(realValue.split("~")[1]);
                    ret.put("startValue", startValue);
                    ret.put("endValue", endValue);
                } else if (realValue.contains(">")) {
                    ret.put("moreThanValue", Integer.parseInt(realValue.replace(">", "")));
                }
            }
        }
        return ret;
    }

    private static void sendAlarmMsg(CommandContext commandContext, String pluginNo, String processNo, Long procdefId) {
        LocaleString title = ResManager.getLocaleString((String)"\u63d2\u4ef6\u6267\u884c\u8d85\u65f6\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", (String)"PluginUtils_4", (String)"bos-wf-devops");
        LocaleString content_p1 = ResManager.getLocaleString((String)"\u6d41\u7a0b\u7f16\u7801\u4e3a\uff1a", (String)"PluginUtils_5", (String)"bos-wf-devops");
        LocaleString content_p2 = ResManager.getLocaleString((String)"\u63d2\u4ef6\u7f16\u7801\u4e3a\uff1a", (String)"PluginUtils_6", (String)"bos-wf-devops");
        LocaleString content_p3 = ResManager.getLocaleString((String)"\u6267\u884c\u8d85\u65f6\u3002", (String)"PluginUtils_7", (String)"bos-wf-devops");
        ILocaleString pluginNoL = WfMultiLangUtils.getMultiLangValue((String)pluginNo);
        ILocaleString processNoL = WfMultiLangUtils.getMultiLangValue((String)processNo);
        ILocaleString content1 = WfMultiLangUtils.jointILocaleString((ILocaleString)content_p1, (ILocaleString)processNoL, (String)"");
        ILocaleString content2 = WfMultiLangUtils.jointILocaleString((ILocaleString)content_p2, (ILocaleString)pluginNoL, (String)"");
        ILocaleString content = WfMultiLangUtils.jointILocaleString((ILocaleString)WfMultiLangUtils.jointILocaleString((ILocaleString)content1, (ILocaleString)content2, (String)"\n"), (ILocaleString)content_p3, (String)"\n");
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("processDefinitionId", procdefId);
        logger.debug(String.format("\u63d2\u4ef6\u8d85\u65f6\uff0c\u53d1\u9001\u544a\u8b66\u6d88\u606f\uff1a%s-%s", pluginNo, content.getLocaleValue()));
        new SendAlarmMessageCmd("plugintimeouterror", pluginNo, (ILocaleString)title, content, params).execute(commandContext);
    }
}

