/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devops.entity.PluginProcInfoEntity;
import kd.bos.workflow.devops.entity.PluginProcInfoEntityManager;
import kd.bos.workflow.devops.util.ClassInfoUtils;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class ScanPluginClassCmd
implements Command<Void> {
    private static Log logger = LogFactory.getLog(ScanPluginClassCmd.class);

    public Void execute(CommandContext commandContext) {
        Set<String> listData = this.getPluginByType(commandContext);
        ArrayList<Map<String, Object>> saveList = new ArrayList<Map<String, Object>>(16);
        if (listData != null) {
            for (String plugin : listData) {
                HashMap<String, String> temp = new HashMap<String, String>(2);
                String classReferenceInfo = "";
                try {
                    classReferenceInfo = ScanPluginClassCmd.getReferenceInfo(plugin);
                }
                catch (Exception e) {
                    logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
                }
                if (WfUtils.isEmpty((String)classReferenceInfo)) continue;
                temp.put("pluginno", plugin);
                temp.put("referenceInfo", classReferenceInfo);
                saveList.add(temp);
            }
            if (saveList.size() > 0) {
                this.batchUpdatePluginReferenceInfo(saveList);
            }
        }
        return null;
    }

    public static String getReferenceInfo(String pluginNo) throws Exception {
        String referenceInfo = "";
        Set<String> classReferenceInfo = new HashSet<String>(8);
        if ((classReferenceInfo = ClassInfoUtils.getClassRelyClass(pluginNo, classReferenceInfo)).size() > 0) {
            referenceInfo = String.join((CharSequence)",", classReferenceInfo);
        }
        if (WfUtils.isNotEmpty((String)referenceInfo) && referenceInfo.length() > 2000) {
            referenceInfo = referenceInfo.substring(0, 1999);
        }
        return referenceInfo;
    }

    private Set<String> getPluginByType(CommandContext commandContext) {
        Set<String> listData = new HashSet<String>(8);
        PluginProcInfoEntityManager pluginProcInfoEntityManager = (PluginProcInfoEntityManager)commandContext.getEntityManager(PluginProcInfoEntityManager.class);
        QFilter qFilter1 = new QFilter("plugintype", "=", (Object)"class");
        QFilter[] filters = new QFilter[]{qFilter1};
        List pluginProcInfoEntityList = pluginProcInfoEntityManager.findByQueryFilters(filters);
        if (pluginProcInfoEntityList != null) {
            listData = pluginProcInfoEntityList.stream().map(PluginProcInfoEntity::getPluginno).collect(Collectors.toSet());
        }
        return listData;
    }

    private void batchUpdatePluginReferenceInfo(List<Map<String, Object>> updateList) {
        String sql = " update t_wf_pluginprocinfo set freferenceinfo=? where fpluginno=? ";
        ArrayList params = new ArrayList(updateList.size());
        updateList.forEach(map -> {
            Object[] tmp = new Object[]{map.get("referenceInfo"), map.get("pluginno")};
            params.add(tmp);
        });
        WfDBUtils.executeBatch((String)sql, params, (Integer)updateList.size());
    }
}

