/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devops.cmd.FindAlarmMessageReceiverCmd;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntity;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntityManager;
import kd.bos.workflow.devops.entity.AlarmRuleEntity;
import kd.bos.workflow.devops.entity.AlarmRuleEntityManager;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;

public class SendAlarmMessageCmd
implements Command<Long> {
    private static final String UNFINISH = "unfinish";
    private static final String COMPLETE = "complete";
    private static final String STR_ERROCDE = "errocde";
    private static final String PLUGINTIMEOUTERROR = "plugintimeouterror";
    private String scene;
    private String group;
    Map<String, Object> params;
    ILocaleString title;
    ILocaleString content;

    @Deprecated
    public SendAlarmMessageCmd(String scene, Long monitorId, Map<String, Object> params) {
        this.scene = scene;
        this.group = String.valueOf(monitorId);
        this.params = Optional.ofNullable(params).orElseGet(HashMap::new);
    }

    public SendAlarmMessageCmd(String scene, String group, Map<String, Object> params) {
        this.scene = scene;
        this.group = group;
        this.params = Optional.ofNullable(params).orElseGet(HashMap::new);
    }

    public SendAlarmMessageCmd(String scene, String group, ILocaleString title, ILocaleString content, Map<String, Object> params) {
        this.scene = scene;
        this.title = title;
        this.content = content;
        this.group = group;
        this.params = Optional.ofNullable(params).orElseGet(HashMap::new);
    }

    public Long execute(CommandContext commandContext) {
        if (StringUtils.isBlank((CharSequence)this.scene)) {
            return null;
        }
        List ruleEntitys = this.getAlarmRuleEntityManager(commandContext).findByQueryFilters(new QFilter[]{new QFilter("alarmscene", "=", (Object)this.scene), new QFilter("enable", "=", (Object)Boolean.TRUE)});
        if (ruleEntitys.isEmpty()) {
            return null;
        }
        AlarmRuleEntity alarmRuleEntity = (AlarmRuleEntity)ruleEntitys.get(0);
        Object userIds = new FindAlarmMessageReceiverCmd(alarmRuleEntity.getReceiverIds(), this.params).execute(commandContext);
        List<AlarmMsgSendLogEntity> sendLogs = this.getAlarmMsgSendLogEntityManager(commandContext).findNoInterruptLogsByRuleId(alarmRuleEntity.getId(), this.group);
        this.setContentAndTitle();
        LocaleString messageTag = null;
        if (this.params.get("appnumber") != null && "bec".equals(this.params.get("appnumber"))) {
            messageTag = ResManager.getLocaleString((String)"\u4e1a\u52a1\u4e8b\u4ef6\u4e2d\u5fc3", (String)"SendAlarmMessageCmd_7", (String)"bos-wf-devops");
        }
        if (sendLogs.isEmpty() && WfUtils.isNotEmpty((ILocaleString)this.title) && WfUtils.isNotEmpty((ILocaleString)this.content)) {
            String state = UNFINISH;
            if (alarmRuleEntity.getTimes() == 1) {
                this.content = this.addDescribeIfLastSend(this.content);
                state = COMPLETE;
            }
            long messageId = DevopsUtils.sendAlarmMessage(this.title, this.content, alarmRuleEntity.getChannel(), (List<Long>)userIds, (ILocaleString)messageTag);
            Long entityId = this.insertAlarmMsgSendLogEntity(commandContext, alarmRuleEntity.getId(), alarmRuleEntity.getChannel(), alarmRuleEntity.getChannelName(), String.valueOf(messageId), this.title, this.content, alarmRuleEntity.getReceiverName(), state);
            return entityId;
        }
        if (!sendLogs.isEmpty() && UNFINISH.equals(sendLogs.get(0).getState())) {
            AlarmMsgSendLogEntity sendLog;
            int ruleTimes = alarmRuleEntity.getTimes();
            int ruleInterval = alarmRuleEntity.getInterval();
            if ((long)(ruleInterval * 60) * 1000L + (sendLog = sendLogs.get(0)).getModifyDate().getTime() <= System.currentTimeMillis()) {
                ILocaleString msgTiltle = WfUtils.isNotEmpty((ILocaleString)this.title) ? this.title : sendLog.getTiltle();
                ILocaleString msgContent = WfUtils.isNotEmpty((ILocaleString)this.content) ? this.content : sendLog.getContent();
                sendLog.setModifyDate(new Date());
                sendLog.setTimes(sendLog.getTimes() + 1);
                if (ruleTimes != -1 && ruleTimes <= sendLog.getTimes()) {
                    sendLog.setState(COMPLETE);
                    msgContent = this.addDescribeIfLastSend(msgContent);
                    sendLog.setContent(msgContent);
                }
                long messageId = DevopsUtils.sendAlarmMessage(msgTiltle, msgContent, alarmRuleEntity.getChannel(), (List<Long>)userIds, (ILocaleString)messageTag);
                StringBuilder messageIdStr = new StringBuilder(sendLog.getMessageIds()).append(",").append(messageId);
                sendLog.setMessageIds(messageIdStr.toString());
                this.getAlarmMsgSendLogEntityManager(commandContext).update(sendLog);
            }
        }
        return 0L;
    }

    public void setContentAndTitle() {
        if ("syserror".equalsIgnoreCase(this.scene)) {
            Map errorCodes = (Map)this.params.get(STR_ERROCDE);
            LocaleString suffix = ResManager.getLocaleString((String)"\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5206\u6790\u5904\u7406\u3002", (String)"SendAlarmMessageCmd_4", (String)"bos-wf-devops");
            LocaleString msgTitle = new LocaleString();
            LocaleString msgContent = new LocaleString();
            errorCodes.forEach((arg_0, arg_1) -> this.lambda$setContentAndTitle$0((ILocaleString)msgTitle, (ILocaleString)msgContent, arg_0, arg_1));
            this.title = msgTitle;
            this.content = WfMultiLangUtils.jointILocaleString((ILocaleString)msgContent, (ILocaleString)suffix, (String)"\uff0c");
        }
    }

    private Long insertAlarmMsgSendLogEntity(CommandContext commandContext, Long ruleId, String channel, ILocaleString channelName, String messageIds, ILocaleString title, ILocaleString content, ILocaleString receiver, String state) {
        AlarmMsgSendLogEntityManager alarmMsgSendLogEntityManager = this.getAlarmMsgSendLogEntityManager(commandContext);
        AlarmMsgSendLogEntity entity = (AlarmMsgSendLogEntity)alarmMsgSendLogEntityManager.create();
        entity.setAlarmRuleId(ruleId);
        entity.setAlarmScene(this.scene);
        entity.setChannel(channel);
        entity.setChannelName(channelName);
        entity.setCreateDate(new Date());
        entity.setMessageIds(messageIds);
        entity.setGroup(this.group);
        entity.setModifyDate(new Date());
        entity.setReceiver(receiver);
        entity.setTimes(1);
        entity.setTitle(title);
        entity.setContent(content);
        entity.setState(state);
        if (this.params.get("appnumber") != null) {
            entity.setAppNumber((String)this.params.get("appnumber"));
        } else {
            entity.setAppNumber("wf");
        }
        alarmMsgSendLogEntityManager.insert(entity);
        return Optional.ofNullable(entity.getId()).orElse(0L);
    }

    private ILocaleString getSysErrorInfo(String code, Long mqErrorDuration) {
        LocaleString info = new LocaleString();
        int duration = 0;
        if (mqErrorDuration != null && mqErrorDuration > 0L) {
            int tmp = (int)(mqErrorDuration / 60L / 1000L);
            duration = tmp > 0 ? tmp : 1;
        }
        switch (code) {
            case "bos.wf.schedule.serverdown": {
                info = ResManager.getLocaleString((String)"\u8c03\u5ea6\u670d\u52a1\u5668\u6545\u969c", (String)"SendAlarmMessageCmd_1", (String)"bos-wf-devops");
                break;
            }
            case "bos.wf.mq.senderror": {
                info = ResManager.getLocaleString((String)"\u53d1\u9001\u6d88\u606f\u5230MQ\u5931\u8d25", (String)"SendAlarmMessageCmd_2", (String)"bos-wf-devops");
                break;
            }
            case "bos.wf.mq.serverdown": {
                info = DevopsUtils.getLocaleString("\u68c0\u6d4b\u6d88\u606f%s\u5206\u949f\u672a\u5904\u7406\uff0c\u53ef\u80fdmq\u5f02\u5e38\u6216\u8005\u8c03\u5ea6\u5f02\u5e38\uff08\u89c4\u5219\uff1a\u5927\u4e8e30\u5206\u949f\uff09", "SendAlarmMessageCmd_3", "bos-wf-devops", duration);
                break;
            }
            case "bos.wf.mq.mqslow": {
                info = DevopsUtils.getLocaleString("\u68c0\u6d4b\u6d88\u606f%s\u5206\u949f\u672a\u5904\u7406\uff0c\u53ef\u80fdmq\u7f13\u6162\u6216\u8005\u8c03\u5ea6\u5f02\u5e38\uff08\u89c4\u5219\uff1a1~10\u5206\u949f\uff09", "SendAlarmMessageCmd_5", "bos-wf-devops", duration);
                break;
            }
            case "bos.wf.mq.block": {
                info = DevopsUtils.getLocaleString("\u68c0\u6d4b\u6d88\u606f%s\u5206\u949f\u672a\u5904\u7406\uff0c\u53ef\u80fdmq\u963b\u585e\u6216\u8005\u6d88\u8d39\u7f13\u6162\u6216\u8005\u8c03\u5ea6\u5f02\u5e38\uff08\u89c4\u5219\uff1a10~30\u5206\u949f\uff09", "SendAlarmMessageCmd_6", "bos-wf-devops", duration);
                break;
            }
        }
        return info;
    }

    private ILocaleString addDescribeIfLastSend(ILocaleString content) {
        if (WfUtils.isNotEmpty((ILocaleString)content)) {
            LocaleString ls = new LocaleString();
            ls.putAll((Map)content);
            LocaleString last = ResManager.getLocaleString((String)"\u5df2\u8fbe\u5230\u6700\u5927\u62a5\u8b66\u6b21\u6570\uff0c\u4e0d\u518d\u53d1\u9001\u91cd\u590d\u7684\u62a5\u8b66\u4fe1\u606f\uff0c\u8bf7\u5c3d\u5feb\u4fee\u590d\u3002", (String)"SendAlarmMessageCmd_0", (String)"bos-wf-devops");
            return WfMultiLangUtils.jointILocaleString((ILocaleString)ls, (ILocaleString)last, (String)"");
        }
        return content;
    }

    private AlarmRuleEntityManager getAlarmRuleEntityManager(CommandContext commandContext) {
        return (AlarmRuleEntityManager)commandContext.getEntityManager(AlarmRuleEntityManager.class);
    }

    private AlarmMsgSendLogEntityManager getAlarmMsgSendLogEntityManager(CommandContext commandContext) {
        return (AlarmMsgSendLogEntityManager)commandContext.getEntityManager(AlarmMsgSendLogEntityManager.class);
    }

    private /* synthetic */ void lambda$setContentAndTitle$0(ILocaleString msgTitle, ILocaleString msgContent, String errorCode, Long mqErrorDuration) {
        ILocaleString sysErrorInfo = this.getSysErrorInfo(errorCode, mqErrorDuration);
        msgTitle.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)msgTitle, (ILocaleString)sysErrorInfo, (String)"\uff0c"));
        msgContent.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)msgContent, (ILocaleString)sysErrorInfo, (String)"\uff0c"));
    }
}

