/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.cmd;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntityManager;
import kd.bos.workflow.devops.entity.MsgJobToMqEntity;
import kd.bos.workflow.devops.entity.MsgJobToMqEntityManager;
import kd.bos.workflow.devops.enums.AutomaticDetectionParserType;
import kd.bos.workflow.devops.enums.DevopsErrorCode;
import kd.bos.workflow.devops.monitor.analyse.AutomaticDetectionAnalyseHelper;
import kd.bos.workflow.devops.task.SendTestMsgJobToMqTask;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.ProcessEngines;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cache.WfCacheHelper;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.cmd.job.JobHandleStrategyFactory;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.jobexecutor.JobUtil;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobEntity;
import kd.bos.workflow.engine.impl.persistence.entity.job.JobStateEnum;

@Deprecated
public class TestingMqAndScheduleStateCmd
implements Command<Void> {
    private Log logger = LogFactory.getLog(SendTestMsgJobToMqTask.class);
    private static final String MSGSTATE_BEGIN = "begin";
    private static final String MSGSTATE_COMPLETE = "complete";
    private static final int SENDJOB_STEP = 3;
    private static final String NEXTEXECUTIONTIME = "nextExecutionTime";
    private static final String INTERVALTIME = "intervalTime";
    private static final String JOB_TYPE_MESSAGE = "message";
    private static final String STR_STATE = "state";
    private static final String STR_ERRORCODE = "errorCode";

    public Void execute(CommandContext commandContext) {
        try {
            Long parentId = this.getCurrentMonitorParentId();
            Map<String, MsgJobToMqEntity> lastBatchEntityMap = this.getLastBatchEntityByParentId(parentId);
            HashSet<String> entityAppids = new HashSet<String>(lastBatchEntityMap.size());
            entityAppids.addAll(lastBatchEntityMap.keySet());
            Set<String> appIds = this.getAllEffectiveAppIds(entityAppids);
            ArrayList<String> needSendJobAppIds = new ArrayList<String>(appIds.size());
            HashMap<String, Long> errorCodes = new HashMap<String, Long>(appIds.size());
            for (String appId2 : appIds) {
                MsgJobToMqEntity msgJobToMqEntity = lastBatchEntityMap.get(appId2);
                Map<String, Object> result = new HashMap<String, Object>();
                if (msgJobToMqEntity != null) {
                    if (msgJobToMqEntity.getEndDate() == null) {
                        result = AutomaticDetectionAnalyseHelper.automaticDetectionParser(AutomaticDetectionParserType.MQANDSCHEDULEPARSER.getType(), msgJobToMqEntity, new HashMap<String, Object>());
                        this.dealResult(result, errorCodes);
                        this.updateMsgJobToMqEntity(msgJobToMqEntity, result);
                    }
                    lastBatchEntityMap.remove(appId2);
                }
                if (!this.isSendNewJob(appId2, result)) continue;
                needSendJobAppIds.add(appId2);
            }
            if (WfUtils.isNotEmptyForMap(lastBatchEntityMap)) {
                lastBatchEntityMap.forEach((appId, entity) -> this.updateMsgJobToMqEntity((MsgJobToMqEntity)entity, null));
            }
            this.sendAlarmMessage(parentId, errorCodes);
            if (errorCodes.isEmpty()) {
                parentId = DB.genGlobalLongId();
                DevopsServiceCacheHelper.putMqAndScheduleMnoitorId(String.valueOf(parentId));
            }
            this.sendAndSaveNewJobToMq(parentId, needSendJobAppIds);
        }
        catch (Exception e) {
            this.logger.info("TestingMqAndScheduleStateCmd_execute error:" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return null;
    }

    private void dealResult(Map<String, Object> result, Map<String, Long> errorCodes) {
        DevopsErrorCode code = (DevopsErrorCode)((Object)result.get(STR_ERRORCODE));
        long newDuration = (Long)Optional.ofNullable(result.get("mqErrorDuration")).orElse(0L);
        Long oldDuration = errorCodes.get("mqErrorDuration");
        if (code != DevopsErrorCode.SUCCESS && (oldDuration == null || oldDuration < newDuration)) {
            errorCodes.put(code.getErrorNumber(), newDuration);
        }
    }

    private boolean isSendNewJob(String appId, Map<String, Object> result) {
        boolean isSuccess;
        Long nextExecutionTime;
        int intervalTime;
        Map<String, String> monitorCacheMap = DevopsServiceCacheHelper.getMqAndScheduleManagerMonitorKey(appId);
        Long now = System.currentTimeMillis();
        boolean isSendNewJob = false;
        if (WfUtils.isEmptyForMap(monitorCacheMap)) {
            intervalTime = 3;
            nextExecutionTime = now;
            monitorCacheMap = new HashMap<String, String>(2);
            monitorCacheMap.put(NEXTEXECUTIONTIME, String.valueOf(now));
            monitorCacheMap.put(INTERVALTIME, String.valueOf(3));
        } else {
            intervalTime = Integer.parseInt(monitorCacheMap.get(INTERVALTIME));
            nextExecutionTime = Long.valueOf(monitorCacheMap.get(NEXTEXECUTIONTIME));
        }
        boolean bl = isSuccess = result.get(STR_ERRORCODE) == null || (DevopsErrorCode)((Object)result.get(STR_ERRORCODE)) == DevopsErrorCode.SUCCESS;
        if (nextExecutionTime <= now) {
            intervalTime = this.calcIntervalTime(intervalTime, isSuccess);
            nextExecutionTime = nextExecutionTime + (long)(intervalTime * 60 * 1000);
            monitorCacheMap.put(NEXTEXECUTIONTIME, String.valueOf(nextExecutionTime));
            monitorCacheMap.put(INTERVALTIME, String.valueOf(intervalTime));
            if (isSuccess || !((DevopsErrorCode)((Object)result.get(STR_ERRORCODE))).isMqSlowError()) {
                isSendNewJob = true;
            }
        } else if (!isSuccess && intervalTime != 3) {
            intervalTime = this.calcIntervalTime(intervalTime, false);
            monitorCacheMap.put(INTERVALTIME, String.valueOf(intervalTime));
        }
        if (!monitorCacheMap.isEmpty()) {
            DevopsServiceCacheHelper.putMqAndScheduleManagerMonitorKey(appId, monitorCacheMap);
        }
        return isSendNewJob;
    }

    private void sendAndSaveNewJobToMq(Long parentId, List<String> needSendJobAppIds) {
        final ArrayList jobs = new ArrayList(needSendJobAppIds.size());
        needSendJobAppIds.forEach(appId -> {
            Long id = DB.genGlobalLongId();
            JobEntity jobEntity = this.buildJobEntity(id, (String)appId);
            jobs.add(jobEntity);
            this.saveData(id, parentId, (String)appId);
        });
        if (!jobs.isEmpty()) {
            Context.getCommandContext().addCloseListener((CommandContextCloseListener)new DefaultCommandContextCloseListener(""){

                public void closed(CommandContext commandContext) {
                    JobUtil.sendJobToMQ((List)jobs);
                    super.closed(commandContext);
                }
            });
        }
    }

    private void updateMsgJobToMqEntity(MsgJobToMqEntity msgJobToMqEntity, Map<String, Object> result) {
        if (result != null) {
            Date endDate = (Date)result.get("endDate");
            String state = (String)result.get(STR_STATE);
            DevopsErrorCode code = (DevopsErrorCode)((Object)result.get(STR_ERRORCODE));
            String errorStack = (String)Optional.ofNullable(result.get("errorStack")).orElse("");
            if (DevopsErrorCode.MQSLOW != code && DevopsErrorCode.MQBLOCK != code) {
                msgJobToMqEntity.setEndDate(endDate);
            }
            msgJobToMqEntity.setState(state);
            msgJobToMqEntity.setErrorCode(code.getErrorNumber());
            msgJobToMqEntity.setErrorType(code.getErrorType());
            msgJobToMqEntity.setErrorInfo(code.getErrorDesc());
            msgJobToMqEntity.setErrorInfoTag(code.getErrorDesc() + "\u3002" + errorStack);
        } else {
            msgJobToMqEntity.setState(MSGSTATE_COMPLETE);
            msgJobToMqEntity.setEndDate(new Date());
        }
        this.getMsgJobToMqEntityManager().update(msgJobToMqEntity);
    }

    private Set<String> getAllEffectiveAppIds(Set<String> entityAppIds) {
        HashSet<String> appIds = new HashSet<String>();
        if (Instance.isAppSplit()) {
            Map<String, String> instanceAppIds = this.getInstanceAppIds();
            Optional.ofNullable(WfCacheHelper.getJobSourceOfAppId()).ifPresent(cacheAppIds -> entityAppIds.addAll(Arrays.asList(cacheAppIds)));
            entityAppIds.forEach(appId -> {
                if (instanceAppIds.containsKey(appId)) {
                    appIds.add((String)appId);
                }
            });
            if (!appIds.isEmpty()) {
                WfCacheHelper.putJobSourceOfAppId((String[])appIds.toArray(new String[0]));
            }
        } else {
            appIds.add("wf");
        }
        this.logger.info("TestingMqAndScheduleStateCmd_currentAppIds:" + appIds.size() + ((Object)appIds).toString());
        return appIds;
    }

    private Map<String, String> getInstanceAppIds() {
        HashMap<String, String> appIds = new HashMap<String, String>(16);
        Object[] appIdArr = Instance.getAppIds();
        if (WfUtils.isNotEmptyForArrays((Object[])appIdArr)) {
            for (Object appId : appIdArr) {
                appIds.put((String)appId, (String)appId);
            }
        }
        return appIds;
    }

    private Map<String, MsgJobToMqEntity> getLastBatchEntityByParentId(Long parentId) {
        List<MsgJobToMqEntity> allEntitys = this.getMsgJobToMqEntityManager().findByParentId(parentId);
        HashMap<String, MsgJobToMqEntity> lastBatchEntitys = new HashMap<String, MsgJobToMqEntity>(allEntitys.size());
        if (!allEntitys.isEmpty()) {
            allEntitys.forEach(entity -> {
                if (!lastBatchEntitys.containsKey(entity.getAppId()) && !DevopsErrorCode.REGISTERERROR.getErrorNumber().equals(entity.getErrorCode())) {
                    lastBatchEntitys.put(entity.getAppId(), (MsgJobToMqEntity)entity);
                }
            });
        }
        return lastBatchEntitys;
    }

    private Integer calcIntervalTime(int intervalTime, boolean isSuccess) {
        intervalTime = isSuccess ? (intervalTime += 3) : 3;
        if (intervalTime >= 30) {
            return 3;
        }
        return intervalTime;
    }

    private void saveData(Long id, Long parendId, String appId) {
        MsgJobToMqEntityManager entityManager = this.getMsgJobToMqEntityManager();
        MsgJobToMqEntity entityObj = (MsgJobToMqEntity)entityManager.create();
        entityObj.setId(id);
        entityObj.setState(MSGSTATE_BEGIN);
        entityObj.setStartDate(new Date());
        entityObj.setAppId(appId);
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)appId);
        entityObj.setAppName((ILocaleString)appInfo.getName());
        entityObj.setParentId(parendId);
        entityManager.insert(entityObj);
    }

    private JobEntity buildJobEntity(Long id, String appId) {
        JobEntity job = (JobEntity)this.getProcessEngineConfigurationImpl().getJobEntityManager().create();
        HashMap<String, String> payload = new HashMap<String, String>(8);
        payload.put("appId", appId);
        job.setJobHandlerConfiguration(SerializationUtils.toJsonString(payload));
        job.setId(id);
        job.setJobType(JOB_TYPE_MESSAGE);
        job.setRetries(0);
        job.setJobHandlerType("async-devops-testmqschedule-job");
        job.setRootTraceNo(RequestContext.get().getTraceId());
        job.setSource(JobHandleStrategyFactory.getWFSource());
        job.setState(JobStateEnum.CREATED.getNumber());
        return job;
    }

    protected void sendAlarmMessage(Long parentId, Map<String, Long> errorCodes) {
        if (errorCodes.isEmpty()) {
            this.getAlarmMsgSendLogEntityManager().completeSendMessage(parentId);
        } else {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("errocde", errorCodes);
            DevopsUtils.getWorkflowDevopsService().sendAlarmMessage("syserror", parentId, params);
        }
    }

    protected Long getCurrentMonitorParentId() {
        String parentId = DevopsServiceCacheHelper.getMqAndScheduleMnoitorId();
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            return Long.valueOf(parentId);
        }
        EntityQueryBuilder eqb = this.getMsgJobToMqEntityManager().createQueryBuilder();
        eqb.orderBy("id desc").setLimit(1);
        List entitys = this.getMsgJobToMqEntityManager().findByQueryBuilder(eqb);
        Long pid = null;
        pid = !entitys.isEmpty() ? ((MsgJobToMqEntity)entitys.get(0)).getParentId() : Long.valueOf(DB.genGlobalLongId());
        DevopsServiceCacheHelper.putMqAndScheduleMnoitorId(String.valueOf(pid));
        return pid;
    }

    protected ProcessEngineConfigurationImpl getProcessEngineConfigurationImpl() {
        return (ProcessEngineConfigurationImpl)ProcessEngines.getDefaultProcessEngine().getProcessEngineConfiguration();
    }

    protected MsgJobToMqEntityManager getMsgJobToMqEntityManager() {
        return (MsgJobToMqEntityManager)Context.getCommandContext().getEntityManager(MsgJobToMqEntityManager.class);
    }

    protected AlarmMsgSendLogEntityManager getAlarmMsgSendLogEntityManager() {
        return (AlarmMsgSendLogEntityManager)Context.getCommandContext().getEntityManager(AlarmMsgSendLogEntityManager.class);
    }
}

