/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.entity;

import java.util.ArrayList;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntity;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntityImpl;
import kd.bos.workflow.devops.entity.AlarmMsgSendLogEntityManager;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

public class AlarmMsgSendLogEntityManagerImpl
extends AbstractEntityManager<AlarmMsgSendLogEntity>
implements AlarmMsgSendLogEntityManager {
    private static final String UNCOMPLETE = "unfinish";
    private static final String COMPLETE = "complete";
    private static final String STATE = "state";

    public AlarmMsgSendLogEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends AlarmMsgSendLogEntity> getManagedEntityClass() {
        return AlarmMsgSendLogEntityImpl.class;
    }

    public String getSelectFields() {
        return "createdate,alarmscene,receiver,times,title,content,content_show,channel,channelname,state,messageids,monitorid,alarmruleid,modifydate,messageids_tag,group";
    }

    public String getEntityName() {
        return "wf_alarmmsgsendlog";
    }

    @Override
    public List<AlarmMsgSendLogEntity> findUncompleteLogsById(Long id) {
        EntityQueryBuilder eqb = this.createQueryBuilder();
        eqb.addFilter("id", "=", (Object)id).addFilter(STATE, "=", (Object)UNCOMPLETE);
        return this.findByQueryBuilder(eqb);
    }

    @Override
    public List<AlarmMsgSendLogEntity> findNoInterruptLogsByRuleId(Long alarmRuleId, Long monitorId) {
        EntityQueryBuilder eqb = this.createQueryBuilder();
        eqb.addFilter("alarmruleid", "=", (Object)alarmRuleId).addFilter("monitorid", "=", (Object)monitorId).addFilter(STATE, "in", (Object)new String[]{UNCOMPLETE, COMPLETE});
        return this.findByQueryBuilder(eqb);
    }

    @Override
    public void completeSendMessage(Long monitorId) {
        EntityQueryBuilder eqb = this.createQueryBuilder();
        eqb.addFilter("monitorid", "=", (Object)monitorId).addFilter(STATE, "in", (Object)new String[]{UNCOMPLETE, COMPLETE});
        List entitys = this.findByQueryBuilder(eqb);
        entitys.forEach(entity -> {
            entity.setState(COMPLETE);
            this.update((Entity)entity);
        });
    }

    @Override
    public List<AlarmMsgSendLogEntity> findUncompleteLogsByRuleId(Long ruleId) {
        QFilter f1 = new QFilter("alarmruleid", "=", (Object)ruleId);
        QFilter f2 = new QFilter(STATE, "=", (Object)UNCOMPLETE);
        return this.findByQueryFilters(new QFilter[]{f1, f2});
    }

    @Override
    public List<AlarmMsgSendLogEntity> findUnfinishLogByScence(String alarmScene) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("alarmscene", "=", (Object)"syserror"));
        filters.add(new QFilter(STATE, "=", (Object)UNCOMPLETE));
        return this.findByQueryFilters(filters.toArray(new QFilter[0]));
    }

    @Override
    public List<AlarmMsgSendLogEntity> findNoInterruptLogsByRuleId(Long alarmRuleId, String group) {
        EntityQueryBuilder eqb = this.createQueryBuilder();
        eqb.addFilter("alarmruleid", "=", (Object)alarmRuleId).addFilter("group", "=", (Object)group).addFilter(STATE, "in", (Object)new String[]{UNCOMPLETE, COMPLETE});
        return this.findByQueryBuilder(eqb);
    }

    @Override
    public void completeSendMessage(String group) {
        EntityQueryBuilder eqb = this.createQueryBuilder();
        eqb.addFilter("group", "=", (Object)group).addFilter(STATE, "in", (Object)new String[]{UNCOMPLETE, COMPLETE});
        List entitys = this.findByQueryBuilder(eqb);
        entitys.forEach(entity -> {
            entity.setState(COMPLETE);
            this.update((Entity)entity);
        });
    }
}

