/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.entity;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.bec.engine.cache.EvtCacheHelper;
import kd.bos.bec.engine.devops.rule.calculate.cmd.AfterIndicatorCalculateRuleCmd;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.thread.ThreadTruck;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntity;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntityImpl;
import kd.bos.workflow.devops.entity.DevopsIndicatorEntityManager;
import kd.bos.workflow.devops.statisticalanalysis.utils.CaptureUtils;
import kd.bos.workflow.engine.WfConfigurationUtil;
import kd.bos.workflow.engine.WfDBUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.Command;
import kd.bos.workflow.engine.impl.interceptor.CommandConfig;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.interceptor.CommandContextCloseListener;
import kd.bos.workflow.engine.impl.interceptor.CommandExecutor;
import kd.bos.workflow.engine.impl.interceptor.DefaultCommandContextCloseListener;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;

public class DevopsIndicatorEntityManagerImpl
extends AbstractEntityManager<DevopsIndicatorEntity>
implements DevopsIndicatorEntityManager {
    private static final String INDICATORGROUPSTARTDATE = "indicatorGroupStartDate";
    private static Log log = LogFactory.getLog(DevopsIndicatorEntityManagerImpl.class);

    public DevopsIndicatorEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends DevopsIndicatorEntity> getManagedEntityClass() {
        return DevopsIndicatorEntityImpl.class;
    }

    public String getEntityName() {
        return "wf_devopsindicator";
    }

    public String getSelectFields() {
        return "id,number,dimvalue,dimdisplayvalue,count,createDate,param,sendtimes";
    }

    @Override
    public List<DevopsIndicatorEntity> getTopnDatas(int limit, String orderBy, String selectFields, List<QFilter> filters) {
        EntityQueryBuilder queryBuilder = this.createQueryBuilder();
        if (WfUtils.isNotEmptyForCollection(filters)) {
            queryBuilder.addFilters(filters.toArray(new QFilter[0]));
        }
        queryBuilder.setSelectFields(WfUtils.isEmpty((String)selectFields) ? this.getSelectFields() : selectFields).setLimit(limit).orderBy(WfUtils.isEmpty((String)orderBy) ? "id" : orderBy);
        List entitys = this.findByQueryBuilder(queryBuilder);
        return entitys;
    }

    @Override
    public List<DevopsIndicatorEntity> findByIds(List<Long> list) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", (Object)list.toArray(new Object[]{list.size()}))};
        List entitys = this.findByQueryFilters(filters);
        return entitys;
    }

    @Override
    public void batchUpdateRetryTimes(List<Object[]> paramList, int batchCount) {
        String sql = "update t_wf_devopsindicator set fsendtimes = ? where fid = ?";
        WfDBUtils.executeBatch((String)sql, paramList, (Integer)batchCount);
    }

    @Override
    public void deleteDevopsIndicatorsByIds(List<Long> ids) {
        String sql = "delete from t_wf_devopsindicator where fid in (?)";
        ArrayList<Long> list = new ArrayList<Long>(ids.size());
        list.addAll(ids);
        WfDBUtils.executeBatchDeleteByIn((String)sql, list, (Integer)100, (boolean)false);
    }

    @Override
    public void batchUpdateDevopsIndicatorsSendTimes(List<Long> ids) {
        if (!ids.isEmpty()) {
            List<DevopsIndicatorEntity> entitys = this.findByIds(ids);
            ArrayList params = new ArrayList(ids.size());
            entitys.forEach(entity -> {
                Object[] tmp = new Object[]{entity.getSendTimes() + 1, entity.getId()};
                params.add(tmp);
            });
            String sql = "update t_wf_devopsindicator set fsendtimes = ? where fid = ?";
            WfDBUtils.executeBatch((String)sql, params, (Integer)ids.size());
        }
    }

    @Override
    public void batchInsert(List<IndicatorInfo> indicators) {
        if (WfUtils.isNotEmptyForCollection(indicators)) {
            indicators.forEach(indicatorInfo -> this.insert(CaptureUtils.buildDevopsIndicatorEntity(indicatorInfo)));
        }
    }

    @Override
    public DynamicObjectCollection findIndicatorsToCollect(Long pkId, List<String> numbers, String orderBy, int limit) {
        Date indicatorGroupStartDate = this.getIndicatorGroupStartDate(numbers);
        if (indicatorGroupStartDate == null) {
            this.notifyBecCalculateRule(numbers, new DynamicObjectCollection(), true);
            return new DynamicObjectCollection();
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (StringUtils.isNotBlank((Object)pkId) && pkId > 0L) {
            filters.add(new QFilter("id", ">=", (Object)pkId));
        }
        Calendar twoHoursAfter = Calendar.getInstance();
        twoHoursAfter.setTime(indicatorGroupStartDate);
        int hours = WfConfigurationUtil.getDevopsIndicatorRetentionDays();
        twoHoursAfter.add(10, hours);
        filters.add(new QFilter("createDate", ">=", (Object)indicatorGroupStartDate));
        filters.add(new QFilter("createDate", "<=", (Object)twoHoursAfter.getTime()));
        if (WfUtils.isNotEmptyForCollection(numbers)) {
            filters.add(new QFilter("number", "in", numbers));
        }
        try (DataSet ds = ORM.create().queryDataSet("DevopsIndicatorEntityManagerImpl_findIndicatorsToCollect", this.getEntityName(), this.getSelectFields(), filters.toArray(new QFilter[0]), orderBy, limit);){
            DynamicObjectCollection dynamicObjects = ORM.create().toPlainDynamicObjectCollection(ds);
            if (WfUtils.isNotEmptyForCollection((Collection)dynamicObjects)) {
                ThreadTruck.put((Object)INDICATORGROUPSTARTDATE, (Object)((DynamicObject)dynamicObjects.get(dynamicObjects.size() - 1)).getDate("createDate"));
            }
            this.notifyBecCalculateRule(numbers, dynamicObjects, false);
            DynamicObjectCollection dynamicObjectCollection = dynamicObjects;
            return dynamicObjectCollection;
        }
    }

    private void notifyBecCalculateRule(List<String> numbers, DynamicObjectCollection dynamicObjects, boolean flag) {
        try {
            if (LocalDateTime.now().getHour() > 6) {
                return;
            }
            if (!numbers.contains("becAsyncMessage")) {
                return;
            }
            LocalDateTime now = LocalDateTime.now();
            final int thisDay = now.getDayOfMonth();
            if (EvtCacheHelper.existLockId((String)"becAsyncMessage", (String)String.valueOf(thisDay))) {
                return;
            }
            if (WfUtils.isEmptyForCollection((Collection)dynamicObjects)) {
                if (flag && EvtCacheHelper.putLockInc((String)"becAsyncMessage", (String)String.valueOf(thisDay), (int)43200) > 0) {
                    now = now.minusDays(1L);
                    final String param = String.format("%s%02d%02d", now.getYear(), now.getMonth().getValue(), now.getDayOfMonth());
                    Context.getCommandContext().addCloseListener((CommandContextCloseListener)new DefaultCommandContextCloseListener("notifyBecCalculateRule"){

                        public void closed(CommandContext commandContext) {
                            super.closed(commandContext);
                            CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
                            CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
                            commandExecutor.execute(commandConfig, (Command)new Command<Void>(){

                                public Void execute(CommandContext commandContext) {
                                    try {
                                        new AfterIndicatorCalculateRuleCmd(param).execute(commandContext);
                                    }
                                    catch (Throwable e) {
                                        EvtCacheHelper.removeLockId((String)"becAsyncMessage", (String)String.valueOf(thisDay));
                                        log.error(String.format("AfterIndicatorCalculateRuleCmd --%s", WfUtils.getExceptionStacktrace((Throwable)e)));
                                    }
                                    return null;
                                }
                            });
                        }
                    });
                }
            } else {
                Calendar cal = Calendar.getInstance();
                cal.setTime(((DynamicObject)dynamicObjects.get(0)).getDate("createDate"));
                int day = cal.get(5);
                if (day == thisDay && EvtCacheHelper.putLockInc((String)"becAsyncMessage", (String)String.valueOf(thisDay), (int)86400) > 0) {
                    now = now.minusDays(1L);
                    final String param = String.format("%s%02d%02d", now.getYear(), now.getMonth().getValue(), now.getDayOfMonth());
                    Context.getCommandContext().addCloseListener((CommandContextCloseListener)new DefaultCommandContextCloseListener("notifyBecCalculateRule"){

                        public void closed(CommandContext commandContext) {
                            super.closed(commandContext);
                            CommandExecutor commandExecutor = commandContext.getProcessEngineConfiguration().getCommandExecutor();
                            CommandConfig commandConfig = commandExecutor.getDefaultConfig().transactionRequiresNew();
                            commandExecutor.execute(commandConfig, (Command)new Command<Void>(){

                                public Void execute(CommandContext commandContext) {
                                    try {
                                        new AfterIndicatorCalculateRuleCmd(param).execute(commandContext);
                                    }
                                    catch (Throwable e) {
                                        EvtCacheHelper.removeLockId((String)"becAsyncMessage", (String)String.valueOf(thisDay));
                                        log.error(String.format("AfterIndicatorCalculateRuleCmd1 --%s", WfUtils.getExceptionStacktrace((Throwable)e)));
                                    }
                                    return null;
                                }
                            });
                        }
                    });
                }
            }
        }
        catch (Throwable e) {
            log.error(String.format("notifyBecCalculateRule --%s", WfUtils.getExceptionStacktrace((Throwable)e)));
        }
    }

    private Date getIndicatorGroupStartDate(List<String> numbers) {
        return (Date)Optional.ofNullable(ThreadTruck.get((Object)INDICATORGROUPSTARTDATE)).orElseGet(() -> {
            EntityQueryBuilder queryBuilder = this.createQueryBuilder();
            if (WfUtils.isNotEmptyForCollection((Collection)numbers)) {
                queryBuilder.addFilter("number", "in", (Object)numbers);
            }
            queryBuilder.setSelectFields("createDate").orderBy("createDate").setLimit(1);
            List entitys = this.findByQueryBuilder(queryBuilder);
            if (WfUtils.isNotEmptyForCollection((Collection)entitys)) {
                return ((DevopsIndicatorEntity)entitys.get(0)).getCreateDate();
            }
            return null;
        });
    }
}

