/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.entity;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;
import kd.bos.workflow.devops.entity.ExceptedEntity;
import kd.bos.workflow.devops.entity.ExceptedEntityImpl;
import kd.bos.workflow.devops.entity.ExceptedEntityManager;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.util.DynamicObjectSafeGetter;

public class ExceptedEntityManagerImpl
extends AbstractEntityManager<ExceptedEntity>
implements ExceptedEntityManager {
    public ExceptedEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public String getEntityName() {
        return "wf_exceptedentity";
    }

    public Class<? extends ExceptedEntity> getManagedEntityClass() {
        return ExceptedEntityImpl.class;
    }

    public String getSelectFields() {
        return "id,entitynumber,entityname";
    }

    public void deleteByFilters(QFilter[] qFilters) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.deleteByFilters(qFilters);
    }

    public void insert(ExceptedEntity entity) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.insert((Entity)entity);
    }

    public void insert(ExceptedEntity entity, boolean fireCreateEvent) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.insert((Entity)entity, fireCreateEvent);
    }

    public ExceptedEntity update(ExceptedEntity entity) {
        ExceptedEntity update = (ExceptedEntity)super.update((Entity)entity);
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        return update;
    }

    public ExceptedEntity update(ExceptedEntity entity, boolean fireUpdateEvent) {
        ExceptedEntity update = (ExceptedEntity)super.update((Entity)entity, fireUpdateEvent);
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        return update;
    }

    public void delete(Long id) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.delete(id);
    }

    public void delete(ExceptedEntity entity) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.delete((Entity)entity);
    }

    public void delete(ExceptedEntity entity, boolean fireDeleteEvent) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.delete((Entity)entity, fireDeleteEvent);
    }

    public void deleteByCacheFilter(String entityNumber, QFilter filter) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        super.deleteByCacheFilter(entityNumber, filter);
    }

    @Override
    public void batchInsert(List<String> entityNumberList) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        QFilter qFilter = new QFilter("id", "in", entityNumberList);
        DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name", (QFilter[])qFilter.toArray());
        List<ExceptedEntity> exceptedEntities = Arrays.stream(objects).map(DynamicObjectSafeGetter::new).map(item -> {
            ExceptedEntityImpl exceptedEntity = new ExceptedEntityImpl();
            exceptedEntity.setEntityName(item.getLocalString("name"));
            exceptedEntity.setEntityNumber(item.getString("id"));
            return exceptedEntity;
        }).collect(Collectors.toList());
        exceptedEntities.forEach(this::insert);
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
    }

    @Override
    public void batchDelete(List<String> entityNumberList) {
        DevopsServiceCacheHelper.removeExceptedEntityNumber();
        QFilter qFilter = new QFilter("entitynumber", "in", entityNumberList);
        super.deleteByFilters(qFilter.toArray());
    }
}

