/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.entity;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.orm.ORM;
import kd.bos.workflow.devops.entity.PluginExeDetailEntity;
import kd.bos.workflow.devops.entity.PluginExeDetailEntityImpl;
import kd.bos.workflow.devops.entity.PluginExeDetailEntityManager;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;

public class PluginExeDetailEntityManagerImpl
extends AbstractEntityManager<PluginExeDetailEntity>
implements PluginExeDetailEntityManager {
    public PluginExeDetailEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    @Override
    public List<PluginExeDetailEntity> getPluginExeDetailDataByCondition(String pluginNo, String processNo) {
        EntityQueryBuilder eqb = this.createQueryBuilder();
        if (WfUtils.isNotEmpty((String)pluginNo)) {
            eqb.addFilter("pluginno", "=", (Object)pluginNo);
        }
        if (WfUtils.isNotEmpty((String)processNo)) {
            eqb.addFilter("processno", "=", (Object)processNo);
        }
        return this.findByQueryBuilder(eqb);
    }

    @Override
    public PluginExeDetailEntity savePluginExeDetail(Map<String, Object> specialProperty) {
        CommandContext commandContext = Context.getCommandContext();
        PluginExeDetailEntityManager pluginExeDetailEntityManager = (PluginExeDetailEntityManager)commandContext.getEntityManager(PluginExeDetailEntityManager.class);
        PluginExeDetailEntity pluginExeDetailEntity = (PluginExeDetailEntity)pluginExeDetailEntityManager.create();
        String businessKey = (String)specialProperty.get("businesskey");
        String billNo = (String)specialProperty.get("billno");
        String pluginNo = (String)specialProperty.get("pluginno");
        ILocaleString pluginName = (ILocaleString)specialProperty.get("pluginname");
        String processNo = (String)specialProperty.get("processno");
        Long endTime = (Long)specialProperty.get("endtime");
        Long beginTime = (Long)specialProperty.get("begintime");
        pluginExeDetailEntity.setJobId((Long)specialProperty.get("jobid"));
        pluginExeDetailEntity.setBillno(billNo);
        pluginExeDetailEntity.setBusinessKey(businessKey);
        pluginExeDetailEntity.setPluginno(pluginNo);
        pluginExeDetailEntity.setPluginname(pluginName);
        pluginExeDetailEntity.setExecutor(WfUtils.getServerHost());
        pluginExeDetailEntity.setBeginTime(new Date(beginTime));
        pluginExeDetailEntity.setEndTime(new Date(endTime));
        pluginExeDetailEntity.setProcessno(processNo);
        pluginExeDetailEntity.setDuration(endTime - beginTime == 0L ? 1L : endTime - beginTime);
        String traceId = (String)specialProperty.get("traceid");
        pluginExeDetailEntity.setTraceid(traceId);
        pluginExeDetailEntity.setProcInstId((Long)specialProperty.get("procinstid"));
        pluginExeDetailEntity.setId(ORM.create().genLongId("wf_pluginexedetail"));
        pluginExeDetailEntity.setElementid(specialProperty.get("elementid") == null ? " " : (String)specialProperty.get("elementid"));
        try {
            pluginExeDetailEntityManager.insert(pluginExeDetailEntity);
        }
        catch (Exception e) {
            this.logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return pluginExeDetailEntity;
    }

    public Class<? extends PluginExeDetailEntity> getManagedEntityClass() {
        return PluginExeDetailEntityImpl.class;
    }

    public String getSelectFields() {
        return "processno,procinstid,jobid,billno,businesskey,executor,traceid,pluginno,pluginname,begintime,endtime,duration,elementid";
    }
}

