/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.entity;

import java.util.Collection;
import java.util.List;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devops.entity.PluginExeDetailEntity;
import kd.bos.workflow.devops.entity.PluginExeSummaryEntity;
import kd.bos.workflow.devops.entity.PluginExeSummaryEntityImpl;
import kd.bos.workflow.devops.entity.PluginExeSummaryEntityManager;
import kd.bos.workflow.devops.entity.cachematcher.PluginExeSummaryEntityMatcher;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;

public class PluginExeSummaryEntityManagerImpl
extends AbstractEntityManager<PluginExeSummaryEntity>
implements PluginExeSummaryEntityManager {
    protected CachedEntityMatcher<PluginExeSummaryEntity> pluginExeSummaryEntityMatcher = new PluginExeSummaryEntityMatcher();

    public PluginExeSummaryEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends PluginExeSummaryEntity> getManagedEntityClass() {
        return PluginExeSummaryEntityImpl.class;
    }

    public String getSelectFields() {
        return "pluginno,pluginname,totalduration,executedtimes,averageduration";
    }

    @Override
    public void savePluginExeSummary(PluginExeDetailEntity pluginExeDetailEntity) {
        CommandContext commandContext = Context.getCommandContext();
        String pluginNo = pluginExeDetailEntity.getPluginno().trim();
        QFilter qFilterNo = new QFilter("pluginno", "=", (Object)pluginNo);
        QFilter[] filters = new QFilter[]{qFilterNo};
        PluginExeSummaryEntityManager pluginExeSummaryEntityManager = (PluginExeSummaryEntityManager)commandContext.getEntityManager(PluginExeSummaryEntityManager.class);
        EntityQueryBuilder qb = new EntityQueryBuilder(this.getEntityName(), filters, this.getSelectFields(), this.getManagedEntityClass());
        List tempData = this.getList(qb, this.pluginExeSummaryEntityMatcher, pluginNo, true);
        if (WfUtils.isNotEmptyForCollection((Collection)tempData)) {
            PluginExeSummaryEntity updateEntity = (PluginExeSummaryEntity)tempData.get(0);
            updateEntity.setExecutedTimes(updateEntity.getExecutedTimes() + 1L);
            updateEntity.setTotalDuration(updateEntity.getTotalDuration() + pluginExeDetailEntity.getDuration());
            Long averageDuration = updateEntity.getTotalDuration() / updateEntity.getExecutedTimes();
            updateEntity.setAverageDuration(averageDuration);
            pluginExeSummaryEntityManager.update(updateEntity);
        } else {
            PluginExeSummaryEntityImpl pluginExeSummaryEntity = new PluginExeSummaryEntityImpl();
            pluginExeSummaryEntity.setPluginNo(pluginExeDetailEntity.getPluginno());
            pluginExeSummaryEntity.setPluginName(pluginExeDetailEntity.getPluginname());
            pluginExeSummaryEntity.setTotalDuration(pluginExeDetailEntity.getDuration());
            pluginExeSummaryEntity.setAverageDuration(pluginExeDetailEntity.getDuration());
            pluginExeSummaryEntity.setExecutedTimes(1L);
            pluginExeSummaryEntityManager.insert(pluginExeSummaryEntity);
        }
    }

    @Override
    public List<PluginExeSummaryEntity> getTimeConsumptionTop5() {
        EntityQueryBuilder eqb = this.createEntityQueryBuilder(null).setSelectFields("pluginno, pluginname, averageduration").orderBy("averageduration desc").setLimit(5);
        return this.findByQueryBuilder(eqb);
    }
}

