/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.entity;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.devops.entity.PluginExeDetailEntity;
import kd.bos.workflow.devops.entity.PluginProcInfoEntity;
import kd.bos.workflow.devops.entity.PluginProcInfoEntityImpl;
import kd.bos.workflow.devops.entity.PluginProcInfoEntityManager;
import kd.bos.workflow.devops.entity.cachematcher.PluginProcInfoEntityMatcher;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.cfg.ProcessEngineConfigurationImpl;
import kd.bos.workflow.engine.impl.context.Context;
import kd.bos.workflow.engine.impl.db.EntityQueryBuilder;
import kd.bos.workflow.engine.impl.interceptor.CommandContext;
import kd.bos.workflow.engine.impl.persistence.CachedEntityMatcher;
import kd.bos.workflow.engine.impl.persistence.entity.AbstractEntityManager;

public class PluginProcInfoEntityManagerImpl
extends AbstractEntityManager<PluginProcInfoEntity>
implements PluginProcInfoEntityManager {
    protected CachedEntityMatcher<PluginProcInfoEntity> pluginExeDetailEntityMatcher = new PluginProcInfoEntityMatcher();

    public PluginProcInfoEntityManagerImpl(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public Class<? extends PluginProcInfoEntity> getManagedEntityClass() {
        return PluginProcInfoEntityImpl.class;
    }

    public String getSelectFields() {
        return "procdefid,processno,procnane,processtype,version,elementid,elementname,entitynumber,entrabillname,scene,plugintype,pluginno,pluginname,executedtimes,averageduration,totalduration";
    }

    @Override
    public void savePluginExeProcessInfo(PluginExeDetailEntity pluginExeDetailEntity, Map<String, Object> specialProperty) {
        EntityQueryBuilder qb;
        List pluginProcInfoEntityList;
        CommandContext commandContext = Context.getCommandContext();
        HashMap<String, String> queryMap = new HashMap<String, String>(8);
        String pluginNo = pluginExeDetailEntity.getPluginno();
        String processNo = pluginExeDetailEntity.getProcessno();
        queryMap.put("pluginno", pluginNo);
        queryMap.put("processno", processNo);
        PluginProcInfoEntityManager pluginProcInfoEntityManager = (PluginProcInfoEntityManager)commandContext.getEntityManager(PluginProcInfoEntityManager.class);
        QFilter qFilter1 = new QFilter("pluginno", "=", (Object)pluginNo);
        QFilter qFilter2 = new QFilter("processno", "=", (Object)processNo);
        String elementId = (String)specialProperty.get("elementid");
        QFilter[] filters = new QFilter[]{qFilter2, qFilter1};
        if (WfUtils.isNotEmpty((String)elementId)) {
            QFilter qFilter3 = new QFilter("elementid", "=", (Object)elementId);
            filters = new QFilter[]{qFilter2, qFilter1, qFilter3};
            queryMap.put("elementid", elementId);
        }
        if (WfUtils.isNotEmptyForCollection((Collection)(pluginProcInfoEntityList = this.getList(qb = new EntityQueryBuilder(this.getEntityName(), filters, this.getSelectFields(), this.getManagedEntityClass()), this.pluginExeDetailEntityMatcher, queryMap, true)))) {
            PluginProcInfoEntity entityUpdate = (PluginProcInfoEntity)pluginProcInfoEntityList.get(0);
            Long executedTimes = entityUpdate.getExecutedtimes();
            Long oriTotalDuration = entityUpdate.getTotalDuration();
            entityUpdate.setExecutedtimes(executedTimes + 1L);
            entityUpdate.setAverageduration((oriTotalDuration + pluginExeDetailEntity.getDuration()) / entityUpdate.getExecutedtimes());
            entityUpdate.setTotalDuration(oriTotalDuration + pluginExeDetailEntity.getDuration());
            pluginProcInfoEntityManager.update(entityUpdate);
        } else {
            try {
                Map map;
                String scene = (String)specialProperty.get("scene");
                PluginProcInfoEntity entity = (PluginProcInfoEntity)pluginProcInfoEntityManager.create();
                entity.setPluginno(pluginNo);
                entity.setPluginname(pluginExeDetailEntity.getPluginname());
                entity.setElementid(specialProperty.get("elementid") == null ? " " : (String)specialProperty.get("elementid"));
                if (specialProperty.get("elementname") == null) {
                    entity.setElementname((ILocaleString)new LocaleString());
                } else if (specialProperty.get("elementname") instanceof Map) {
                    map = (Map)specialProperty.get("elementname");
                    entity.setElementname(WfMultiLangUtils.getMultiLangValue((Map)map));
                } else if (specialProperty.get("elementname") instanceof ILocaleString) {
                    entity.setElementname((ILocaleString)specialProperty.get("elementname"));
                }
                entity.setEntityNumber((String)specialProperty.get("entitynumber"));
                entity.setEntrabillname((ILocaleString)specialProperty.get("entityname"));
                entity.setPluginType((String)specialProperty.get("plugintype"));
                entity.setProcDefId((Long)specialProperty.get("procdefid"));
                entity.setExecutedtimes(1L);
                entity.setProcessno(pluginExeDetailEntity.getProcessno());
                entity.setAverageduration(pluginExeDetailEntity.getDuration());
                if (specialProperty.get("name") instanceof Map) {
                    map = (Map)specialProperty.get("name");
                    entity.setProcNane(WfMultiLangUtils.getMultiLangValue((Map)map));
                } else if (specialProperty.get("name") instanceof ILocaleString) {
                    entity.setProcNane((ILocaleString)specialProperty.get("name"));
                } else {
                    entity.setProcNane((ILocaleString)new LocaleString());
                }
                entity.setScene(scene);
                entity.setProcessType((String)specialProperty.get("processtype"));
                entity.setVersion((String)specialProperty.get("version"));
                entity.setProcessno(pluginExeDetailEntity.getProcessno());
                entity.setId(ORM.create().genLongId("wf_pluginprocinfo"));
                entity.setTotalDuration(pluginExeDetailEntity.getDuration());
                pluginProcInfoEntityManager.insert(entity);
            }
            catch (Exception e) {
                this.logger.warn("PluginProcInfoEntity.insert occurred exception" + WfUtils.getExceptionStacktrace((Throwable)e));
            }
        }
    }
}

