/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.monitor.analyse.impl;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.workflow.devops.entity.MsgJobToMqEntity;
import kd.bos.workflow.devops.enums.DevopsErrorCode;
import kd.bos.workflow.devops.monitor.analyse.IAutomaticDetectionAnalyse;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;

@Deprecated
public class MqAndScheduleParser
implements IAutomaticDetectionAnalyse {
    private Log logger = LogFactory.getLog(MqAndScheduleParser.class);
    private static final String MSGSTATE_ERROR = "error";
    private static final String MSGSTATE_COMPLETE = "complete";
    private static final String ERRORCODE = "errorCode";
    private static final String STATE = "state";

    @Override
    public Map<String, Object> analyse(Entity entity, Map<String, Object> params) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        if (!(entity instanceof MsgJobToMqEntity)) {
            return result;
        }
        MsgJobToMqEntity msgJobToMqEntity = (MsgJobToMqEntity)entity;
        Date endDate = new Date();
        result.put("endDate", new Date());
        String msgState = msgJobToMqEntity.getState();
        String errorCode = msgJobToMqEntity.getErrorCode();
        Date startDate = msgJobToMqEntity.getStartDate();
        long betweenTime = endDate.getTime() - startDate.getTime();
        if (MSGSTATE_ERROR.equals(msgState)) {
            String schJobSql = "select fjobid from t_sch_task where fjobid = ?";
            try (DataSet queryDataSet = DB.queryDataSet((String)"WFDevops.find_sch_job_data", (DBRoute)DBRoute.basedata, (String)schJobSql, (Object[])new Object[]{String.valueOf(msgJobToMqEntity.getId())});){
                int jobcCount = queryDataSet.count("fjobid", false);
                if (jobcCount <= 0) {
                    result.put(ERRORCODE, (Object)DevopsErrorCode.SCHEDULEERROR);
                    result.put("errorStack", msgJobToMqEntity.getErrorInfoTag());
                    result.put(STATE, MSGSTATE_ERROR);
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
            }
            String schErrorJobSql = "select fjobid id, ferrorreason reason from T_SCH_ERRORJOB where fjobid = ?";
            try (DataSet queryDataSet2 = DB.queryDataSet((String)"WFDevops.find_sch_error_job_data", (DBRoute)DBRoute.basedata, (String)schErrorJobSql, (Object[])new Object[]{String.valueOf(msgJobToMqEntity.getId())});){
                DynamicObjectCollection schErrorJobList = ORM.create().toPlainDynamicObjectCollection(queryDataSet2);
                if (!schErrorJobList.isEmpty()) {
                    result.put(ERRORCODE, (Object)DevopsErrorCode.MQPRODUCEERROR);
                    result.put("errorStack", ((DynamicObject)schErrorJobList.get(0)).getString("reason"));
                    result.put(STATE, MSGSTATE_ERROR);
                    HashMap<String, Object> hashMap = result;
                    return hashMap;
                }
            }
        }
        if (betweenTime < 600000L) {
            result.put(ERRORCODE, (Object)DevopsErrorCode.MQSLOW);
            result.put(STATE, MSGSTATE_ERROR);
        } else if (betweenTime < 1800000L) {
            result.put(ERRORCODE, (Object)DevopsErrorCode.MQBLOCK);
            result.put(STATE, MSGSTATE_ERROR);
        } else if (betweenTime >= 1800000L) {
            result.put(STATE, MSGSTATE_ERROR);
            result.put(ERRORCODE, (Object)DevopsErrorCode.MQDOWN);
        } else {
            result.put(ERRORCODE, (Object)DevopsErrorCode.MQUNKNOWERROR);
            result.put(STATE, MSGSTATE_ERROR);
        }
        result.put("mqErrorDuration", betweenTime);
        this.logger.info("MqAndScheduleParser_analyse_rsult is : " + ((Object)result).toString());
        return result;
    }
}

