/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.engine.WfUtils;

public class AlarmMsgSendlogListPlugin
extends AbstractListPlugin {
    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = args.getFieldName();
        Long pk = (Long)event.getCurrentRow().getPrimaryKeyValue();
        if ("content_show".equals(fieldName)) {
            this.showMessageDetails(pk);
        } else if ("times".equals(fieldName)) {
            this.showChannelMessage(pk);
        }
        args.setCancel(true);
    }

    public void setFilter(SetFilterEvent e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Optional.ofNullable(params).ifPresent(param -> {
            Optional.ofNullable(param.get("group")).ifPresent(group -> e.addCustomQFilter(new QFilter("group", "=", group)));
            Optional.ofNullable(param.get("alarmRuleId")).ifPresent(ruleId -> e.addCustomQFilter(new QFilter("alarmruleid", "=", ruleId)));
        });
        this.setDefaultFilter(e);
        super.setFilter(e);
    }

    protected void setDefaultFilter(SetFilterEvent e) {
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if ("evt_alarmmsgsendlog".equals(billFormId)) {
            e.getQFilters().add(new QFilter("appnumber", "=", (Object)"bec"));
        } else {
            e.getQFilters().add(new QFilter("appnumber", "=", (Object)"wf"));
        }
    }

    private void showChannelMessage(Long pk) {
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_alarmmsgsendlog", (String)"messageids");
        String ids = dynObj.getString("messageids");
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_msg_failmessage_buju");
        parameter.setFormId("bos_list");
        if (WfUtils.isNotEmpty((String)ids) && ids.length() > 10000) {
            ids = ids.substring(0, 10000);
        }
        parameter.setCustomParam("messageIds", (Object)ids);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void showMessageDetails(Long pk) {
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_alarmmsgsendlog", (String)"title, content");
        ILocaleString title = dynObj.getLocaleString("title");
        ILocaleString content = dynObj.getLocaleString("content");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_devopsmsgdetails");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("title", (Object)title.getLocaleValue());
        showParameter.setCustomParam("content", (Object)content.getLocaleValue());
        showParameter.setCaption(ResManager.loadKDString((String)"\u53d1\u9001\u5185\u5bb9", (String)"AlarmMsgSendlogListPlugin_0", (String)"bos-wf-devops", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if ("content_show".equals(key) || "times".equals(key)) {
            e.setFormatValue((Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"AlarmMsgSendlogListPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        super.packageData(e);
    }
}

