/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.MulComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class AlarmRuleSettingPlugin
extends AbstractFormPlugin {
    private Log logger = LogFactory.getLog(AlarmRuleSettingPlugin.class);
    private static final String NUMBER = "number";
    private static final String CHANNEL = "channel";
    private static final String RECEIVER_SHOW = "receiver_show";
    private static final String COMMONF7 = "commonf7";
    private static final String ALARMSCENE = "alarmscene";
    private static final String CONFIG = "config";
    private static final String RECEIVERNAME = "receivername";
    private static final String RECEIVER_REAL = "receiver_real";
    private static final String BTN_OK_EVT = "btnok_evt";
    private static final String SAVE = "save";
    private static final String PLUGINTIMEOUTERROR = "plugintimeouterror";
    private static final String DISPLAYVALUE = "displayvalue";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"btnok", BTN_OK_EVT, COMMONF7, RECEIVER_SHOW});
    }

    private void initChannelComboxList() {
        QFilter f1 = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{f1};
        DynamicObject[] channelObjects = BusinessDataServiceHelper.load((String)"msg_channel", (String)"id, number, name", (QFilter[])filters);
        ArrayList<ComboItem> channels = new ArrayList<ComboItem>(channelObjects.length);
        HashMap<String, LocaleString> channelMap = new HashMap<String, LocaleString>(channelObjects.length);
        for (DynamicObject channelObj : channelObjects) {
            if ("sysnotice".equalsIgnoreCase(channelObj.getString(NUMBER))) continue;
            String number = channelObj.getString(NUMBER);
            LocaleString name = WfMultiLangUtils.changeILocaleStringToLocaleString((ILocaleString)channelObj.getLocaleString("name"));
            channelMap.put(number, name);
            channels.add(new ComboItem(name, number));
        }
        if (!channels.isEmpty()) {
            ((MulComboEdit)this.getControl(CHANNEL)).setComboItems(channels);
            this.getPageCache().put(CHANNEL, SerializationUtils.toJsonString(channelMap));
        }
    }

    public void beforeBindData(EventObject e) {
        if (!PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_alarmrule", (String)"4715a0df000000ac")) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
        this.initChannelComboxList();
        this.setTimesAndInterval();
        this.setUserValue();
        this.setCommonF7Value();
        this.getModel().setDataChanged(false);
        super.beforeBindData(e);
    }

    private void setUserValue() {
        if (StringUtils.isNotBlank((Object)this.getModel().getValue(RECEIVERNAME))) {
            this.getModel().setValue(RECEIVER_SHOW, (Object)((ILocaleString)this.getModel().getValue(RECEIVERNAME)));
        }
    }

    private void setCommonF7Value() {
        LocaleString commonF7Caption;
        Object alarmscene;
        Object configStr;
        if (PLUGINTIMEOUTERROR.equals(this.getModel().getValue(ALARMSCENE))) {
            ((TextEdit)this.getControl(COMMONF7)).setMustInput(true);
        }
        if (StringUtils.isNotBlank((Object)(configStr = this.getModel().getValue(CONFIG)))) {
            JSONObject config = (JSONObject)SerializationUtils.fromJsonString((String)((String)configStr), JSONObject.class);
            JSONObject commonF7Json = Optional.ofNullable(config.getJSONObject(COMMONF7)).orElseGet(JSONObject::new);
            Object value = commonF7Json.get((Object)DISPLAYVALUE);
            if (value instanceof ILocaleString) {
                this.getModel().setValue(COMMONF7, (Object)((ILocaleString)value).getLocaleValue());
            } else if (value instanceof Map) {
                LocaleString ls = new LocaleString();
                ls.putAll((Map)value);
                this.getModel().setValue(COMMONF7, (Object)ls.getLocaleValue());
            } else {
                this.getModel().setValue(COMMONF7, value);
            }
        }
        if (StringUtils.isNotBlank((Object)(alarmscene = this.getModel().getValue(ALARMSCENE))) && WfUtils.isNotEmpty((ILocaleString)(commonF7Caption = this.getCommonF7Caption((String)alarmscene)))) {
            TextEdit commonf7 = (TextEdit)this.getView().getControl(COMMONF7);
            commonf7.setCaption(commonF7Caption);
        }
    }

    private void setTimesAndInterval() {
        Object times = this.getModel().getValue("times");
        Object interval = this.getModel().getValue("interval");
        if ((Integer)times != 0) {
            this.getModel().setValue("times_show", (Object)(-1 == (Integer)times ? "nolimit" : String.valueOf(times)));
        }
        if ((Integer)interval != 0) {
            this.getModel().setValue("interval_show", (Object)String.valueOf(interval));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Long pkId;
        Long l = pkId = ((BaseShowParameter)this.getView().getFormShowParameter()).getPkId() != null ? (Long)((BaseShowParameter)this.getView().getFormShowParameter()).getPkId() : null;
        if (args.getSource() instanceof Save) {
            String alarmScene = (String)this.getModel().getValue(ALARMSCENE);
            Boolean exist = DevopsUtils.getWorkflowDevopsService().isExitSameSceneAlarmRule(alarmScene, pkId);
            if (exist.booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u62a5\u8b66\u573a\u666f\u7684\u89c4\u5219,\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AlarmRuleSettingPlugin_0", (String)"bos-wf-devops", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.setAppNumberValue();
            Object receiverObj = this.getModel().getValue(RECEIVER_SHOW);
            Optional.ofNullable(receiverObj).ifPresent(collection -> {
                if (collection instanceof DynamicObjectCollection) {
                    StringBuilder userIds = new StringBuilder();
                    LocaleString userName = new LocaleString();
                    ((DynamicObjectCollection)collection).forEach(arg_0 -> AlarmRuleSettingPlugin.lambda$null$0((ILocaleString)userName, userIds, arg_0));
                    this.getModel().setValue(RECEIVERNAME, (Object)userName);
                    this.getModel().setValue(RECEIVER_REAL, (Object)userIds);
                } else {
                    this.getModel().setValue(RECEIVERNAME, this.getModel().getValue(RECEIVERNAME));
                    this.getModel().setValue(RECEIVER_REAL, this.getModel().getValue(RECEIVER_REAL));
                }
            });
            String channelIds = (String)this.getModel().getValue(CHANNEL);
            if (StringUtils.isNotBlank((CharSequence)channelIds)) {
                String channel = this.getPageCache().get(CHANNEL);
                if (StringUtils.isNotBlank((CharSequence)channel)) {
                    Map channelInfo = (Map)SerializationUtils.fromJsonString((String)channel, Map.class);
                    String[] ids = channelIds.split(",");
                    LocaleString channelName = new LocaleString();
                    StringJoiner realChannels = new StringJoiner(",");
                    for (int i = 0; i < ids.length; ++i) {
                        Optional.ofNullable(ids[i]).filter(id -> !"".equals(id) && channelInfo.containsKey(id)).ifPresent(arg_0 -> AlarmRuleSettingPlugin.lambda$beforeDoOperation$3(channelInfo, (ILocaleString)channelName, realChannels, arg_0));
                    }
                    this.getModel().setValue(CHANNEL, (Object)realChannels.toString());
                    this.getModel().setValue("channelname", (Object)channelName);
                } else {
                    this.getModel().setValue(CHANNEL, null);
                    this.getModel().setValue("channelname", null);
                }
            }
            String times = (String)this.getModel().getValue("times_show");
            String interval = (String)this.getModel().getValue("interval_show");
            if ("conflict".equals(alarmScene) || ProcessNotExistReasonEnum.ERROR_ADDRESS.getReason().equals(alarmScene) || ProcessNotExistReasonEnum.NOT_FIND.getReason().equals(alarmScene)) {
                this.getModel().setValue("times", (Object)1);
                this.getModel().setValue("interval", (Object)3);
            } else {
                this.getModel().setValue("times", (Object)("nolimit".equals(times) ? -1 : Integer.parseInt(times)));
                this.getModel().setValue("interval", (Object)Integer.valueOf(interval));
            }
            if (pkId != null && this.getModel().getDataChanged()) {
                DevopsUtils.getWorkflowDevopsService().abandSendLogEntityByAlarmRuleId(pkId);
            }
        }
        super.beforeDoOperation(args);
    }

    protected void setAppNumberValue() {
        String formId = this.getView().getFormShowParameter().getFormId();
        if ("evt_alarmrule".equals(formId)) {
            this.getModel().setValue("appnumber", (Object)"bec");
        } else {
            this.getModel().setValue("appnumber", (Object)"wf");
        }
    }

    public void pageRelease(EventObject e) {
        this.getPageCache().remove(CHANNEL);
        super.pageRelease(e);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (key.equalsIgnoreCase(COMMONF7)) {
            this.showCommonF7();
        } else if (key.equalsIgnoreCase(RECEIVER_SHOW)) {
            this.showReceiverSetting();
        } else if (key.equalsIgnoreCase(BTN_OK_EVT)) {
            this.getView().invokeOperation(SAVE);
        }
        super.click(evt);
    }

    private void showReceiverSetting() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_alarmmsgreceiver");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object receiverValue = this.getModel().getValue(RECEIVER_REAL);
        if (StringUtils.isNotBlank((Object)receiverValue) && ((String)receiverValue).contains("userids")) {
            Map map = (Map)SerializationUtils.fromJsonString((String)((String)receiverValue), Map.class);
            showParameter.getCustomParams().put("user", map.get("userids"));
            showParameter.getCustomParams().put("wfadmin", map.get("wfadmin"));
            showParameter.getCustomParams().put("initiator", map.get("initiator"));
        } else {
            showParameter.getCustomParams().put("user", receiverValue);
        }
        Object alarmScene = this.getModel().getValue(ALARMSCENE);
        if ("evt_alarmrule".equals(this.getView().getFormShowParameter().getFormId())) {
            showParameter.getCustomParams().put("isShowInitiator", false);
            showParameter.getCustomParams().put("isShowWfadmin", false);
        } else {
            showParameter.getCustomParams().put("isShowInitiator", "conflict".equals(alarmScene) || ProcessNotExistReasonEnum.ERROR_ADDRESS.getReason().equals(alarmScene) || ProcessNotExistReasonEnum.NOT_FIND.getReason().equals(alarmScene));
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, RECEIVER_SHOW));
        this.getView().showForm(showParameter);
    }

    private void showCommonF7() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId(this.getCommonF7ShowEntityNumber((String)this.getModel().getValue(ALARMSCENE)));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        Object configStr = this.getModel().getValue(CONFIG);
        if (StringUtils.isNotBlank((Object)configStr)) {
            JSONObject config = (JSONObject)SerializationUtils.fromJsonString((String)((String)configStr), JSONObject.class);
            JSONObject jsonObject = config.getJSONObject(COMMONF7);
            showParameter.getCustomParams().putAll(jsonObject);
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, COMMONF7));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (StringUtils.isBlank((Object)returnData)) {
            return;
        }
        if (COMMONF7.equals(actionId)) {
            Map result = (Map)returnData;
            Object configStr = this.getModel().getValue(CONFIG);
            JSONObject config = StringUtils.isNotBlank((Object)configStr) ? (JSONObject)SerializationUtils.fromJsonString((String)((String)configStr), JSONObject.class) : new JSONObject();
            JSONObject commonF7 = Optional.ofNullable(config.getJSONObject(COMMONF7)).orElseGet(JSONObject::new);
            commonF7.putAll(result);
            config.put(COMMONF7, (Object)commonF7);
            this.getModel().setValue(CONFIG, (Object)SerializationUtils.toJsonString((Object)config));
            this.setCommonF7Value();
        } else if (RECEIVER_SHOW.equalsIgnoreCase(actionId)) {
            Map result = (Map)returnData;
            this.getModel().setValue(RECEIVERNAME, result.get(RECEIVERNAME));
            this.getModel().setValue(RECEIVER_REAL, result.get(RECEIVER_REAL));
            this.getModel().setValue(RECEIVER_SHOW, result.get(RECEIVERNAME));
        }
        super.closedCallBack(closedCallBackEvent);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        String name = property.getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (ALARMSCENE.equals(name)) {
            this.getModel().setValue(CONFIG, null);
            this.getModel().setValue(COMMONF7, null);
            TextEdit commonf7 = (TextEdit)this.getView().getControl(COMMONF7);
            LocaleString caption = this.getCommonF7Caption((String)changeSet[0].getNewValue());
            commonf7.setCaption(caption);
            if (PLUGINTIMEOUTERROR.equals(changeSet[0].getNewValue())) {
                ((TextEdit)this.getControl(COMMONF7)).setMustInput(true);
            } else {
                ((TextEdit)this.getControl(COMMONF7)).setMustInput(false);
            }
        }
        super.propertyChanged(e);
    }

    private String getCommonF7ShowEntityNumber(String alarmScene) {
        switch (alarmScene) {
            case "plugintimeouterror": {
                return "wf_plugintimeoutsetting";
            }
        }
        return null;
    }

    private LocaleString getCommonF7Caption(String alarmScene) {
        switch (alarmScene) {
            case "plugintimeouterror": {
                return ResManager.getLocaleString((String)"\u63d2\u4ef6\u6267\u884c\u8d85\u65f6\u8bbe\u7f6e", (String)"AlarmRuleSettingPlugin_1", (String)"bos-wf-devops");
            }
        }
        return new LocaleString();
    }

    private static /* synthetic */ void lambda$beforeDoOperation$3(Map channelInfo, ILocaleString channelName, StringJoiner realChannels, String id) {
        LocaleString str = new LocaleString();
        str.putAll((Map)channelInfo.get(id));
        channelName.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)channelName, (ILocaleString)str, (String)","));
        realChannels.add(id);
    }

    private static /* synthetic */ void lambda$null$0(ILocaleString userName, StringBuilder userIds, DynamicObject obj) {
        DynamicObject user = obj.getDynamicObject("fbasedataid");
        userName.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)userName, (ILocaleString)user.getLocaleString("name"), (String)","));
        userIds.append(user.get("masterid")).append(",");
    }
}

