/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.devops.api.ConditionParseApis;
import kd.bos.workflow.devops.vo.ConditionParseVo;
import kd.bos.workflow.engine.HistoryService;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.log.entity.ConditionParseLogEntity;
import kd.bos.workflow.engine.impl.persistence.entity.design.ModelType;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.impl.util.condition.ConditionType;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class ConditionParseProcedurePlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public final ConditionParseApis apis = ConditionParseApis.getInstance();
    public static final String LOG_ENTITY = "logentity";
    public static final String BUTTON_SEARCH = "btnsearch";
    public static final String BUTTON_CLOSE = "btnclose";
    public static final String NUMBER = "number";
    public static final String ENTITY_NUMBER = "entitynumber";
    public static final String BILLNO_OR_BUSINESSKEY = "billnoorbusinesskey";

    public void registerListener(EventObject e) {
        EntryGrid control = (EntryGrid)this.getControl(LOG_ENTITY);
        control.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void initialize() {
        this.addClickListeners(new String[]{BUTTON_SEARCH, BUTTON_CLOSE});
    }

    public void afterCreateNewData(EventObject e) {
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam(ENTITY_NUMBER);
        String billNo = (String)this.getView().getFormShowParameter().getCustomParam(BILLNO_OR_BUSINESSKEY);
        if (entityNumber == null && billNo == null) {
            return;
        }
        if (entityNumber == null || billNo == null) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u6761\u4ef6\u89c4\u5219\u89e3\u6790\u8fc7\u7a0b\u3002", (String)"ConditionParseProcedurePlugin_4", (String)"bos-wf-devops", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        this.getModel().setValue(ENTITY_NUMBER, (Object)entityNumber);
        this.getModel().setValue(BILLNO_OR_BUSINESSKEY, (Object)billNo);
        List list = this.apis.historyService().findConditionParseListBy(entityNumber.trim(), billNo.trim());
        if (list == null || list.isEmpty()) {
            String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u6761\u4ef6\u89c4\u5219\u89e3\u6790\u8fc7\u7a0b\u3002", (String)"ConditionParseProcedurePlugin_4", (String)"bos-wf-devops", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
        }
        List<ConditionParseVo> conditionParseVos = this.buildList(list);
        this.draw(conditionParseVos);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName = hyperLinkClickEvent.getFieldName();
        if ("processname".equals(fieldName)) {
            DynamicObject row = this.getModel().getEntryRowEntity(LOG_ENTITY, hyperLinkClickEvent.getRowIndex());
            this.processNameHyperClick(row);
        }
    }

    public void processNameHyperClick(DynamicObject row) {
        long processInstanceId = row.getLong("processInstanceId");
        if (processInstanceId != 0L) {
            this.showProcessConfiguration(processInstanceId);
            return;
        }
        long processDefinitionId = row.getLong("processDefinitionId");
        if (processDefinitionId == 0L) {
            this.getView().showErrorNotification("error:processDefinitionId is null");
            return;
        }
        String typecode = row.getString("typecode");
        ConditionType.Domain domain = ConditionType.valueOf((String)typecode, (boolean)false).getDomain();
        if (ConditionType.Domain.SCHEMA == domain) {
            String key = row.getString("key");
            List strings = Splitter.on((String)"_").splitToList((CharSequence)key);
            String replace = ((String)strings.get(1)).replace("[", "").replace("]", "");
            long schemeId = Long.parseLong(replace);
            this.showProcessConfiguration(processDefinitionId, schemeId);
        }
        if (ConditionType.Domain.PROCESS == domain) {
            this.toProcessDefinitionList(processDefinitionId);
        }
    }

    protected RepositoryService repositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    public void toProcessDefinitionList(Long processDefinitionId) {
        ListShowParameter param = new ListShowParameter();
        param.setFormId("wf_processtreelist");
        ProcessDefinitionEntity processdefineById = this.repositoryService().getProcessdefineById(processDefinitionId);
        if (processdefineById == null) {
            this.getView().showTipNotification("this process has been deleted");
            return;
        }
        String type = processdefineById.getType();
        if (ModelType.AuditFlow.name().equalsIgnoreCase(type)) {
            param.setBillFormId("wf_processdefinition");
        } else {
            param.setBillFormId("bpm_processmanage");
        }
        ListFilterParameter filter = new ListFilterParameter();
        filter.setFilter(new QFilter("id", "=", (Object)processDefinitionId));
        param.setListFilterParameter(filter);
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            param.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)param);
            return;
        }
        param.setCustomParam("defaultFilter", (Object)"false");
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().sendFormAction(parentView);
        this.getView().showForm((FormShowParameter)param);
    }

    private void showProcessConfiguration(long processDefinitionId, long schemeId) {
        IFormView view = this.getView();
        if (!PermissionServiceHelper.hasSpecificPerm((long)Long.parseLong(RequestContext.get().getUserId()), (String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"/8M2NEU9PFQV")) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u6d41\u7a0b\u7ba1\u7406\u201d\u7684\u201c\u6d41\u7a0b\u52a8\u6001\u65b9\u6848\u914d\u7f6e\u201d\u6743\u9650\u3002", (String)"ProcessInstancePluginUtil_50", (String)"bos-wf-formplugin", (Object[])new Object[0]));
            WfUtils.addOpLogByAppId((String)this.getPermissionAppId(), (String)"wf_processdefinition", (String)"viewProcessConfiguration", (MultiLangEnumBridge)new MultiLangEnumBridge("\u67e5\u770b\u6d41\u7a0b\u914d\u7f6e", "WorkflowProcessInstancePlugin_57", "bos-wf-formplugin"), (MultiLangEnumBridge)new MultiLangEnumBridge("\u8d8a\u6743\u8bbf\u95ee:\u65e0\u201c\u6d41\u7a0b\u5b9e\u4f8b\u201d\u7684\u201c\u67e5\u770b\u6d41\u7a0b\u914d\u7f6e\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", "ProcessInstancePluginUtil_41", "bos-wf-formplugin"), (Object[])new Object[0]);
            return;
        }
        ProcessInstancePluginUtil.openModifyForm((Long)processDefinitionId, (Long)schemeId, (String)"", (IFormView)view);
    }

    public static String getPermissionEntity(IFormView view) {
        FormShowParameter parameter = view.getFormShowParameter();
        String openAppId = (String)parameter.getCustomParam("openappid");
        if ("bpm".equals(openAppId)) {
            return "wf_execution_tree";
        }
        if ("bpm".equals(view.getFormShowParameter().getAppId())) {
            return "wf_execution_tree";
        }
        return "wf_execution";
    }

    private void showProcessConfiguration(long processInstanceId) {
        ProcessInstancePluginUtil.showProcessConfiguration((IFormView)this.getView(), (Long)processInstanceId);
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId((IFormView)this.getView());
    }

    public void click(EventObject evt) {
        String key;
        Control ctrl = (Control)evt.getSource();
        switch (key = ctrl.getKey()) {
            case "btnsearch": {
                String baseNumber;
                if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"a479ec06000000ac", (String)"wf_condparseprocedure", (String)"47150e89000000ac")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u201c\u67e5\u8be2\u201d\u7684\u6743\u9650\u3002", (String)"ConditionParseProcedurePlugin_6", (String)"bos-wf-devops", (Object[])new Object[0]));
                    return;
                }
                DynamicObject object = (DynamicObject)this.getModel().getValue(ENTITY_NUMBER);
                String billNoOrBusinessKey = (String)this.getModel().getValue(BILLNO_OR_BUSINESSKEY);
                if (object == null || StringUtils.isBlank((CharSequence)billNoOrBusinessKey)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\uff0c\u8f93\u5165\u5355\u636e\u7f16\u53f7\u540e\u67e5\u8be2\u3002", (String)"ConditionParseProcedurePlugin_7", (String)"bos-wf-devops", (Object[])new Object[0]));
                    return;
                }
                String entityNumber = (String)object.get(NUMBER);
                List<ConditionParseLogEntity> list = this.apis.findConditionParseList(entityNumber, billNoOrBusinessKey);
                if (list.isEmpty() && "BaseFormModel".equals(object.getString("modelType")) && StringUtils.isNotBlank((CharSequence)(baseNumber = this.apis.findBaseNumber(entityNumber, billNoOrBusinessKey)))) {
                    list = this.apis.findConditionParseList(entityNumber, baseNumber);
                }
                if (list == null || list.isEmpty()) {
                    String tips = ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u65e0\u6761\u4ef6\u89c4\u5219\u89e3\u6790\u8fc7\u7a0b\u3002", (String)"ConditionParseProcedurePlugin_4", (String)"bos-wf-devops", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                }
                List<ConditionParseVo> conditionParseVos = this.buildList(list);
                this.draw(conditionParseVos);
                break;
            }
            case "btnclose": {
                this.getView().close();
            }
        }
    }

    public int draw(List<ConditionParseVo> conditionParseVos) {
        int i;
        this.getModel().deleteEntryData(LOG_ENTITY);
        if (conditionParseVos == null || conditionParseVos.isEmpty()) {
            return 0;
        }
        this.getModel().batchCreateNewEntryRow(LOG_ENTITY, conditionParseVos.size());
        String tips = ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f\u3002", (String)"ConditionParseProcedurePlugin_8", (String)"bos-wf-devops", (Object[])new Object[0]);
        String format = String.format(tips, conditionParseVos.size());
        this.getView().showSuccessNotification(format);
        for (i = 0; i < conditionParseVos.size(); ++i) {
            ConditionParseVo item = conditionParseVos.get(i);
            this.getModel().setValue("id", (Object)item.getId(), i);
            this.getModel().setValue("processInstanceId", (Object)item.getProcessInstanceId(), i);
            this.getModel().setValue("processDefinitionId", (Object)item.getProcessDefinitionId(), i);
            this.getModel().setValue("processname", (Object)item.getProcessName(), i);
            this.getModel().setValue("itemname", (Object)item.getItemName(), i);
            this.getModel().setValue("type", (Object)item.getType(), i);
            this.getModel().setValue("typecode", (Object)item.getTypeCode(), i);
            this.getModel().setValue("parseprocedure", (Object)item.getParseProcedure(), i);
            this.getModel().setValue("time", (Object)item.getTime(), i);
            this.getModel().setValue("opdesc", (Object)item.getOpDesc(), i);
            this.getModel().setValue("key", (Object)item.getKey(), i);
            this.getModel().setValue("superprocessinstancename", (Object)item.getSuperProcessInstanceName(), i);
        }
        EntryGrid entry = (EntryGrid)this.getControl(LOG_ENTITY);
        entry.setPageIndex(1);
        return i;
    }

    public HistoryService historyService() {
        return (HistoryService)((WorkflowService)ServiceFactory.getService(WorkflowService.class)).getService(HistoryService.class);
    }

    public List<ConditionParseVo> buildList(List<ConditionParseLogEntity> entityDataList) {
        if (entityDataList == null || entityDataList.isEmpty()) {
            return new ArrayList<ConditionParseVo>(0);
        }
        List collect = entityDataList.stream().filter(this::filterSeq).map(ConditionParseVo::from).collect(Collectors.toList());
        ConditionParseVo current = new ConditionParseVo();
        ArrayList<ConditionParseVo> result = new ArrayList<ConditionParseVo>(entityDataList.size());
        for (ConditionParseVo item : collect) {
            if (current.equals(item)) continue;
            result.add(item);
            current = item;
        }
        LinkedHashMap voGroupMap = new LinkedHashMap(result.size());
        for (ConditionParseVo item : result) {
            Long definitionId = item.getProcessDefinitionId();
            if (voGroupMap.containsKey(definitionId)) {
                ((List)voGroupMap.get(definitionId)).add(item);
                continue;
            }
            ArrayList<ConditionParseVo> conditionParseVos = new ArrayList<ConditionParseVo>(16);
            conditionParseVos.add(item);
            voGroupMap.put(definitionId, conditionParseVos);
        }
        return voGroupMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public boolean filterSeq(ConditionParseLogEntity item) {
        if (ConditionType.SEQUENCE_FLOW.name().equals(item.getItemName())) {
            return false;
        }
        String key = item.getKey();
        List strings = Splitter.on((String)"_").splitToList((CharSequence)key);
        String dynamic = ((String)strings.get(1)).replace("[", "").replace("]", "");
        return !Boolean.parseBoolean(dynamic);
    }
}

