/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devops.enums.ReAddressType;
import kd.bos.workflow.devops.router.ProcessNotExistRouter;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.pojo.AddressParam;
import kd.bos.workflow.engine.pojo.AddressVariables;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

public class DesignedProcessPlugin
extends AbstractFormPlugin {
    public static final String OPERATE = "operate";
    public static final String PROCESS = "process";
    public static final String BTN_OK = "btnok";
    public static final String BTN_CANCEL = "btncancel";
    public static final String CALLBACK_OP = "callback_op";
    public static final String CALLBACK_PROCESS = "callback_process";
    public static final Log logger = LogFactory.getLog(DesignedProcessPlugin.class);
    public final ProcessNotExistRouter router = ProcessNotExistRouter.get();

    public void initialize() {
        this.router.setPlugin(this);
        TextEdit operateEdit = (TextEdit)this.getControl(OPERATE);
        TextEdit processEdit = (TextEdit)this.getControl(PROCESS);
        Button btnOK = (Button)this.getControl(BTN_OK);
        Button btnCancel = (Button)this.getControl(BTN_CANCEL);
        operateEdit.addClickListener((ClickListener)this);
        processEdit.addClickListener((ClickListener)this);
        btnOK.addClickListener((ClickListener)this);
        btnCancel.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "operate": {
                String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
                this.router.toOperateList(entity, CALLBACK_OP);
                break;
            }
            case "process": {
                String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
                this.router.toEntityProcessList(entity, CALLBACK_PROCESS);
                break;
            }
            case "btncancel": {
                this.getView().close();
                break;
            }
            case "btnok": {
                Map<String, Object> entityProcess = this.getEntityProcess();
                Object definitionid = entityProcess.get("definitionid");
                Object schemeid = entityProcess.get("schemeid");
                Map<String, Object> operate = this.getOperate();
                Object code = operate.get("code");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("definitionid", definitionid);
                map.put("schemeid", schemeid);
                map.put("code", code);
                Object idStr = this.getView().getFormShowParameter().getCustomParam("ids");
                List<Long> ids = Splitter.on((String)",").splitToList((CharSequence)idStr.toString()).stream().map(Long::valueOf).collect(Collectors.toList());
                this.designedToProcess(map, ids);
                this.getView().close();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        switch (actionId) {
            case "callback_op": {
                if (!(returnData instanceof Map)) break;
                Map op = (Map)returnData;
                this.setOperateVo(op);
                Object name = op.get("name");
                this.getModel().setValue(OPERATE, name);
                break;
            }
            case "callback_process": {
                if (!(returnData instanceof Map)) break;
                Map entityProcess = (Map)returnData;
                Object name = entityProcess.get("name");
                HashMap<String, Object> op = new HashMap<String, Object>();
                op.put("type", entityProcess.get("optype"));
                op.put("name", entityProcess.get("opname"));
                op.put("code", entityProcess.get("op"));
                this.setOperateVo(op);
                this.setEntityProcess(entityProcess);
                this.getModel().setValue(PROCESS, name);
                this.getModel().setValue(OPERATE, entityProcess.get("opname"));
            }
        }
    }

    public RuntimeService runtimeService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRuntimeService();
    }

    public Map<String, Object> getOperate() {
        String operateVo = this.getPageCache().get("OperateData");
        try {
            return (Map)new ObjectMapper().readValue(operateVo, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (JsonProcessingException e) {
            logger.info(Arrays.toString(e.getStackTrace()));
            return new HashMap<String, Object>(0);
        }
    }

    public void setOperateVo(Map<String, Object> op) {
        this.getPageCache().put("OperateData", SerializationUtils.toJsonString(op));
    }

    public Map<String, Object> getEntityProcess() {
        String entityProcess = this.getPageCache().get("EntityProcess");
        if (entityProcess == null) {
            return new HashMap<String, Object>(0);
        }
        try {
            return (Map)new ObjectMapper().readValue(entityProcess, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (Exception e) {
            logger.info(Arrays.toString(e.getStackTrace()));
            return new HashMap<String, Object>();
        }
    }

    public void setEntityProcess(Map<String, Object> entityProcess) {
        this.getPageCache().put("EntityProcess", SerializationUtils.toJsonString(entityProcess));
    }

    public void designedToProcess(Map<String, Object> entityProcess, List<Long> processNotExistIds) {
        List<ProcessNotExistPoJo> processNotExistByIds = this.devopsService().findProcessNotExistByIds(processNotExistIds);
        List<AddressParam> addressVariables = this.buildAddressVariables(processNotExistByIds, entityProcess);
        if (addressVariables == null || addressVariables.isEmpty()) {
            String tips = ResManager.loadKDString((String)"\u6307\u5b9a\u6d41\u7a0b\u5931\u8d25", (String)"ProcessNotExistListHyperLinkPlugin_3", (String)"bos-wf-devops", (Object[])new Object[0]);
            this.getView().showTipNotification(tips);
            return;
        }
        this.devopsService().batchRestartProcess(addressVariables, ReAddressType.DESIGNATED);
    }

    public List<AddressParam> buildAddressVariables(List<ProcessNotExistPoJo> processNotExistByIds, Map<String, Object> designatedProcess) {
        if (processNotExistByIds == null || processNotExistByIds.isEmpty() || designatedProcess == null || designatedProcess.get("definitionid") == null || designatedProcess.get("schemeid") == null || designatedProcess.get("code") == null) {
            return new ArrayList<AddressParam>(0);
        }
        HashSet<AddressParam> variablesSet = new HashSet<AddressParam>(processNotExistByIds.size());
        for (ProcessNotExistPoJo item : processNotExistByIds) {
            AddressVariables variables = new AddressVariables();
            variables.setBusinessKey(item.getBusinessKey());
            variables.setEntityNumber(item.getEntityNumber());
            variables.setInitiator(item.getSubmitterId());
            variables.setOp((String)designatedProcess.get("code"));
            variables.setProcessDefinitionId((Long)designatedProcess.get("definitionid"));
            variables.setSchemeId((Long)designatedProcess.get("schemeid"));
            variables.setCalledWay(ReAddressType.DESIGNATED.name());
            variables.setReason(item.getErrorReason());
            AddressParam param = new AddressParam();
            param.setOperate(variables.getOp());
            param.setEntityNumber(variables.getEntityNumber());
            param.setBusinessKey(variables.getBusinessKey());
            param.setVariables(variables.toMap());
            param.setBillno(item.getBillno());
            variablesSet.add(param);
        }
        return new ArrayList<AddressParam>(variablesSet);
    }

    public WFDevopsService devopsService() {
        return DevopsUtils.getWorkflowDevopsService();
    }
}

