/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.google.common.base.Splitter;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devops.pojo.OperateData;

public class EntityProcessListPlugin
extends AbstractFormPlugin {
    public void initialize() {
        this.addClickListeners(new String[]{"btncancel", "btnok"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if ("btncancel".equals(source.getKey())) {
            this.getView().close();
        } else if ("btnok".equals(source.getKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (selectedRows.isEmpty()) {
                return;
            }
            Object primaryKeyValue = selectedRows.get(0).getPrimaryKeyValue();
            QFilter qFilter = new QFilter("id", "=", primaryKeyValue);
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"wf_entityprocess_view", (String)"id,processdefinitionid.id,processdefinitionid.operation,processdefinitionid.name", (QFilter[])qFilter.toArray());
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("definitionid", dynamicObject.getLong("processdefinitionid.id"));
            map.put("schemeid", dynamicObject.getLong("id"));
            map.put("name", dynamicObject.getLocaleString("processdefinitionid.name") + "");
            String op = dynamicObject.getString("processdefinitionid.operation");
            List opList = Splitter.on((String)",").splitToList((CharSequence)op);
            if (opList.size() > 1) {
                String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
                List<OperateData> operation = this.fetchOperation(entity);
                String findKey = opList.contains("submit") ? "submit" : (String)opList.get(0);
                String finalFindKey = findKey;
                OperateData operateData = operation.stream().filter(item -> finalFindKey.equals(item.getCode())).findFirst().orElseGet(OperateData::new);
                map.put("op", operateData.getCode());
                map.put("opname", operateData.getName().toString());
                map.put("optype", operateData.getType());
            } else if (opList.size() == 1) {
                String targetOp = (String)opList.get(0);
                if (StringUtils.isEmpty((CharSequence)targetOp)) {
                    targetOp = "submit";
                }
                map.put("op", targetOp);
            } else {
                map.put("op", "submit");
            }
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    private List<OperateData> fetchOperation(String entity) {
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entity, MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        String entityId = formMetadata.getEntityId();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List operations = metadata.getRootEntity().getOperations();
        return operations.stream().map(OperateData::from).collect(Collectors.toList());
    }
}

