/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.IFormView;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.OnGetControlArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.workflow.devops.pojo.OperateData;
import kd.bos.workflow.devops.vo.EntityProcessVo;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.persistence.entity.Entity;
import kd.bos.workflow.engine.impl.persistence.entity.management.DynamicConfigSchemeEntity;
import kd.bos.workflow.engine.impl.persistence.entity.management.ProcessDefinitionEntity;
import kd.bos.workflow.engine.repository.ProcessDefinition;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;

@Deprecated
public class EntityProcessPlugin
extends AbstractFormPlugin {
    public static final String ENTRY_ENTITY = "entryentity";
    public static final String BTN_OK = "btnok";
    public static final String BTN_CANCEL = "btncancel";
    public static final String sql = "select top %1$s,%2$s scheme.fid sid,def.fid did \n  from t_wf_procdef def left join t_wf_dynconfscheme scheme  \n  on def.fid =scheme.fprocdefid  \nwhere def.fentrabill =? \norder by  isnull(scheme.fcreatedate,{d'1970-01-01'}) desc";
    public static final String countSql = "select count(*) from  t_wf_procdef def left join t_wf_dynconfscheme scheme on  def.fid =scheme.fprocdefid where def.fentrabill =?";

    public void initialize() {
        Button btnOK = (Button)this.getControl(BTN_OK);
        Button btnCancel = (Button)this.getControl(BTN_CANCEL);
        btnOK.addClickListener((ClickListener)this);
        this.getView().addCustomControls(new String[]{ENTRY_ENTITY});
        btnCancel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        if (StringUtils.isEmpty((CharSequence)entity)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int pageRow = entryGrid.getPageRow();
        int count = this.getCount(entity);
        if (count == 0) {
            return;
        }
        List<EntityProcessVo> vos = this.getVos(1, pageRow, entity);
        this.draw(vos);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        dataEntity.getDataEntityState().setEntryRowCount(ENTRY_ENTITY, count);
        dataEntity.getDataEntityState().setEntryPageSize(ENTRY_ENTITY, pageRow);
        dataEntity.getDataEntityState().setEntryStartRowIndex(ENTRY_ENTITY, 0);
    }

    protected List<EntityProcessVo> getVos(int pageIndex, int pageSize, String entity) {
        String format = String.format(sql, pageSize, pageSize * (pageIndex - 1));
        ArrayList<EntityProcessVo> result = new ArrayList<EntityProcessVo>(pageSize);
        ArrayList<Long> schemeIds = new ArrayList<Long>(pageSize);
        ArrayList<Long> defIds = new ArrayList<Long>(pageSize);
        try (DataSet rows = DB.queryDataSet((String)"EntityProcessPlugin.top", (DBRoute)WfUtils.WFS, (String)format, (Object[])new Object[]{entity});){
            for (Row row : rows) {
                Long sid = row.getLong("sid");
                Long did = row.getLong("did");
                schemeIds.add(sid);
                defIds.add(did);
                EntityProcessVo item2 = new EntityProcessVo();
                item2.setDefinitionId(did);
                item2.setSchemeId(sid);
                result.add(item2);
            }
        }
        List<OperateData> operations = this.getOperation(entity);
        HashMap<String, OperateData> map = new HashMap<String, OperateData>(operations.size());
        for (OperateData operation : operations) {
            map.put(operation.getCode(), operation);
        }
        List schemeList = this.repositoryService().findSchemeByIds(schemeIds);
        List definitionEntities = this.repositoryService().findProcDefByIds(defIds);
        Map<Long, ProcessDefinitionEntity> defMap = definitionEntities.stream().collect(Collectors.toMap(ProcessDefinition::getId, item -> item));
        Map<Long, DynamicConfigSchemeEntity> schemeMap = schemeList.stream().collect(Collectors.toMap(Entity::getId, item -> item));
        for (EntityProcessVo item3 : result) {
            ProcessDefinitionEntity definitionEntity = defMap.get(item3.getDefinitionId());
            item3.from(definitionEntity);
            DynamicConfigSchemeEntity schemeEntity = schemeMap.get(item3.getSchemeId());
            item3.from(schemeEntity);
            if (!StringUtils.isNotEmpty((CharSequence)item3.getOp())) continue;
            List strings = Splitter.on((String)",").splitToList((CharSequence)item3.getOp());
            List opList = strings.stream().map(map::get).filter(Objects::nonNull).collect(Collectors.toList());
            if (opList.size() == 1) {
                OperateData operateData = (OperateData)opList.get(0);
                item3.setOpName(operateData.getName());
                item3.setOpType(operateData.getType());
                continue;
            }
            List nameList = opList.stream().map(OperateData::getName).collect(Collectors.toList());
            ILocaleString name = WfMultiLangUtils.jointCollectionLocaleString(nameList, (String)",");
            List typeList = opList.stream().map(OperateData::getType).collect(Collectors.toList());
            item3.setOpName(name);
            item3.setOpType(Joiner.on((String)",").join(typeList));
        }
        return result;
    }

    private int getCount(String entity) {
        String count = this.getPageCache().get("count");
        if (StringUtils.isNotEmpty((CharSequence)count)) {
            return Integer.parseInt(count);
        }
        try (DataSet rows = DB.queryDataSet((String)"EntityProcessPlugin.count", (DBRoute)WfUtils.WFS, (String)countSql, (Object[])new Object[]{entity});){
            Integer countInt = rows.next().getInteger("count(*)");
            if (countInt == null) {
                int n = 0;
                return n;
            }
            this.getPageCache().put("count", countInt + "");
            int n = countInt;
            return n;
        }
    }

    private List<OperateData> getOperation(String entity) {
        String operation = this.getPageCache().get("operation");
        if (StringUtils.isNotEmpty((CharSequence)operation)) {
            return SerializationUtils.fromJsonStringToList((String)operation, OperateData.class);
        }
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entity, MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        String entityId = formMetadata.getEntityId();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List operations = metadata.getRootEntity().getOperations();
        List<OperateData> collect = operations.stream().map(OperateData::from).collect(Collectors.toList());
        String s = SerializationUtils.toJsonString(collect);
        this.getPageCache().put("operation", s);
        return collect;
    }

    public void onGetControl(OnGetControlArgs e) {
        String key = e.getKey();
        if (ENTRY_ENTITY.equals(key)) {
            PageEntryGird entryGrid = new PageEntryGird();
            entryGrid.setView(this.getView());
            entryGrid.setKey(ENTRY_ENTITY);
            entryGrid.setEntryKey(ENTRY_ENTITY);
            entryGrid.setSplitPage(true);
            Control oldGrid = e.getControl();
            if (oldGrid == null) {
                this.findControl(ENTRY_ENTITY);
            }
            if (oldGrid instanceof EntryGrid) {
                entryGrid.getItems().addAll(((EntryGrid)oldGrid).getItems());
            }
            e.setControl((Control)entryGrid);
        }
    }

    private Control findControl(String key) {
        FormRoot root = (FormRoot)this.getView().getRootControl();
        return this.findControl(key, root.getItems());
    }

    private Control findControl(String key, List<Control> items) {
        for (Control ctl : items) {
            Control subCtl;
            if (StringUtils.equals((CharSequence)key, (CharSequence)ctl.getKey())) {
                return ctl;
            }
            if (!(ctl instanceof Container) || (subCtl = this.findControl(key, ((Container)ctl).getItems())) == null) continue;
            return subCtl;
        }
        return null;
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows.length != 1) {
                    StandardTips.view((IFormView)this.getView()).selectMultiRow(selectRows.length);
                    return;
                }
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRY_ENTITY);
                DynamicObject dynamicObject = (DynamicObject)entryentity.get(selectRows[0]);
                EntityProcessVo selected = new EntityProcessVo().from(dynamicObject);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("definitionid", selected.getDefinitionId());
                map.put("schemeid", selected.getSchemeId());
                map.put("name", selected.getName().toString());
                String op = selected.getOp();
                List opList = Splitter.on((String)",").splitToList((CharSequence)op);
                if (opList.size() > 1) {
                    String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
                    List<OperateData> operation = this.getOperation(entity);
                    String findKey = opList.contains("submit") ? "submit" : (String)opList.get(0);
                    String finalFindKey = findKey;
                    OperateData operateData = operation.stream().filter(item -> finalFindKey.equals(item.getCode())).findFirst().orElseGet(OperateData::new);
                    selected.setOp(operateData.getCode());
                    selected.setOpName(operateData.getName());
                    selected.setOpType(operateData.getType());
                }
                map.put("op", selected.getOp());
                map.put("opname", selected.getOpName().toString());
                map.put("optype", selected.getOpType());
                this.getView().returnDataToParent(map);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }

    protected int draw(List<EntityProcessVo> list) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, list.size());
        for (int i = 0; i < list.size(); ++i) {
            EntityProcessVo item = list.get(i);
            this.getModel().setValue("key", (Object)item.getKey(), i);
            this.getModel().setValue("businessid", (Object)item.getBusinessId(), i);
            this.getModel().setValue("name", (Object)item.getName(), i);
            this.getModel().setValue("schemename", (Object)item.getSchemeName(), i);
            this.getModel().setValue("type", (Object)item.calType(item), i);
            this.getModel().setValue("enable", (Object)item.calEnable(item), i);
            this.getModel().setValue("state", (Object)item.calVersionState(item), i);
            this.getModel().setValue("version", (Object)item.getVersion(), i);
            this.getModel().setValue("desc", (Object)item.getDesc(), i);
            this.getModel().setValue("publisher", (Object)item.getPublisher(), i);
            this.getModel().setValue("publishtime", (Object)item.getPublishTime(), i);
            this.getModel().setValue("definitionid", (Object)item.getDefinitionId(), i);
            this.getModel().setValue("schemeid", (Object)item.getSchemeId(), i);
            this.getModel().setValue("op", (Object)item.getOp(), i);
            this.getModel().setValue("opname", (Object)item.getOpName(), i);
            this.getModel().setValue("optype", (Object)item.getOpType(), i);
        }
        return list.size();
    }

    protected RuntimeService runtimeService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRuntimeService();
    }

    protected RepositoryService repositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    public class PageEntryGird
    extends EntryGrid {
        protected boolean onFetchPageData(int pageIndex, int pageRows) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity(this.getKey());
            entryEntity.clear();
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            List<EntityProcessVo> vos = EntityProcessPlugin.this.getVos(pageIndex, pageRows, entity);
            for (int i = 0; i < vos.size(); ++i) {
                EntityProcessVo vo = vos.get(i);
                DynamicObject dynamicObject = entryEntity.addNew();
                vo.toDynamicObject(dynamicObject);
            }
            dataEntity.getDataEntityState().setEntryStartRowIndex(this.getKey(), (pageIndex - 1) * pageRows);
            dataEntity.getDataEntityState().setEntryPageSize(this.getKey(), pageRows);
            return true;
        }

        public boolean isNeedPaged() {
            return true;
        }
    }
}

