/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.F7SelectedList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.helper.F7SelectedListHelper;
import kd.bos.workflow.devops.pojo.ExceptedEntityData;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.devops.util.DevopsUtils;

public class EntitySelectorPlugin
extends AbstractFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String BTN_CANCEL = "btncancel";

    public void initialize() {
        BillList billList = (BillList)this.getControl("billlistap");
        F7SelectedList f7SelectedList = (F7SelectedList)this.getControl("f7selectedlistap");
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.setEntityId("bos_entityobject");
        filterContainer.setNeedShareScheme(false);
        filterContainer.addFilterContainerInitListener(this::filterContainerInitListener);
        filterContainer.addSearchClickListener(this::addSearchClickListener);
        F7SelectedListHelper.addF7SelectedListenerForBillList((BillList)billList, (F7SelectedList)f7SelectedList);
        this.addClickListeners(new String[]{BTN_OK, BTN_CANCEL});
    }

    private void filterContainerInitListener(FilterContainerInitEvent event) {
        List commonFilterColumns = event.getFastFilterColumns();
        FilterColumn filterName = new FilterColumn();
        filterName.setFieldName("name");
        LocaleString localeString = ResManager.getLocaleString((String)"\u7f16\u7801", (String)"EntitySelectorPlugin_1", (String)"bos-wf-devops");
        filterName.setCaption(localeString);
        FilterColumn filterNumber = new FilterColumn();
        filterNumber.setFieldName("number");
        LocaleString name = ResManager.getLocaleString((String)"\u540d\u79f0", (String)"EntitySelectorPlugin_2", (String)"bos-wf-devops");
        filterNumber.setCaption(name);
        commonFilterColumns.add(filterName);
        commonFilterColumns.add(filterNumber);
    }

    private void addSearchClickListener(SearchClickEvent event) {
        BillList billList = (BillList)this.getControl("billlistap");
        List fastQFilters = event.getFastQFilters();
        billList.addSetFilterListener(evt -> evt.setCustomQFilters(fastQFilters));
        this.getView().updateView("billlistap");
    }

    public void afterCreateNewData(EventObject e) {
    }

    public void click(EventObject evt) {
        String key;
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "btnok": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRows = billList.getSelectedRows();
                if (selectedRows.isEmpty()) {
                    this.getView().returnDataToParent((Object)"");
                    this.getView().close();
                }
                List ids = selectedRows.stream().map(item -> (String)item.getPrimaryKeyValue()).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "in", ids);
                DynamicObject[] objects = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)"id,name", (QFilter[])qFilter.toArray());
                List collect = Arrays.stream(objects).map(item -> {
                    ExceptedEntityData data = new ExceptedEntityData();
                    data.setEntityName(item.getLocaleString("name"));
                    data.setEntityNumber(item.getString("id"));
                    return data;
                }).collect(Collectors.toList());
                String s = SerializationUtils.toJsonString(collect);
                this.getView().returnDataToParent((Object)s);
                this.getView().close();
                break;
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }

    public WFDevopsService devopsService() {
        return DevopsUtils.getWorkflowDevopsService();
    }
}

