/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.workflow.devops.cache.DevopsServiceCacheHelper;

public class IndiactorLibraryListPlugin
extends AbstractListPlugin {
    private static final String DISABLE = "disable";
    private static final String ENABLE = "enable";

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult() == null || !afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            return;
        }
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        Object dynamicObject = null;
        switch (operateKey) {
            case "disable": {
                Map<String, String> disableMap = this.setEnable(((ListView)this.getView()).getSelectedRows(), Boolean.FALSE);
                DevopsServiceCacheHelper.putDisableIndictor(disableMap);
                this.refresh();
                break;
            }
            case "enable": {
                Map<String, String> enableMap = this.setEnable(((ListView)this.getView()).getSelectedRows(), Boolean.TRUE);
                DevopsServiceCacheHelper.removeDisableIndictor(enableMap);
                this.refresh();
                break;
            }
        }
    }

    private Map<String, String> setEnable(ListSelectedRowCollection rows, Boolean isEnable) {
        List pks = rows.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        DynamicObject[] objs = BusinessDataServiceHelper.load((String)"wf_indicatorinfomanage", (String)"id,number,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", pks)});
        HashMap<String, String> resultMap = new HashMap<String, String>(objs.length);
        for (DynamicObject obj : objs) {
            obj.set(ENABLE, (Object)isEnable);
            SaveServiceHelper.update((DynamicObject)obj);
            resultMap.put(obj.getString("number"), obj.getString("number"));
        }
        return resultMap;
    }

    private void refresh() {
        IListView listView = (IListView)this.getView();
        listView.clearSelection();
        listView.refresh();
    }
}

