/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;

public class OperateListPlugin
extends AbstractFormPlugin {
    public static final String BTN_OK = "btnok";
    public static final String BTN_CANCEL = "btncancel";
    public static final String TYPE = "type";
    public static final String NAME = "name";
    public static final String CODE = "code";

    public void initialize() {
        Button btnOK = (Button)this.getControl(BTN_OK);
        Button btnCancel = (Button)this.getControl(BTN_CANCEL);
        btnOK.addClickListener((ClickListener)this);
        btnCancel.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entity, MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        String entityId = formMetadata.getEntityId();
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List operations = metadata.getRootEntity().getOperations();
        this.draw(operations);
    }

    public void click(EventObject evt) {
        String key;
        Control source = (Control)evt.getSource();
        switch (key = source.getKey()) {
            case "btnok": {
                DynamicObject selectedOp = this.getSelectedOp();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put(TYPE, selectedOp.get(TYPE));
                map.put(NAME, selectedOp.getLocaleString(NAME).toString());
                map.put(CODE, selectedOp.get(CODE));
                this.getView().returnDataToParent(map);
            }
            case "btncancel": {
                this.getView().close();
            }
        }
    }

    public int draw(List<Operation> operations) {
        int i;
        this.getModel().deleteEntryData("entryentity");
        if (operations == null || operations.isEmpty()) {
            return 0;
        }
        this.getModel().batchCreateNewEntryRow("entryentity", operations.size());
        for (i = 0; i < operations.size(); ++i) {
            Operation operation = operations.get(i);
            this.getModel().setValue(TYPE, (Object)operation.getOperationType(), i);
            this.getModel().setValue(NAME, (Object)operation.getName().toString(), i);
            this.getModel().setValue(CODE, (Object)operation.getKey(), i);
        }
        return i;
    }

    public DynamicObject getSelectedOp() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
        return (DynamicObject)entryentity.get(selectRows[0]);
    }
}

