/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.workflow.design.util.PluginUtil;
import kd.bos.workflow.engine.WfUtils;

public class PluginExeDetailListPlugin
extends AbstractListPlugin {
    private static Log logger = LogFactory.getLog(PluginExeDetailListPlugin.class);
    private static final String BEGINTIME = "begintime";
    private static final String EXECUTOR = "executor";
    private static final String FIELD_DURATION = "duration";

    public void setFilter(SetFilterEvent e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (WfUtils.isNotEmptyForMap((Map)params) && params.get("jobid") != null) {
            QFilter qFilter = new QFilter("jobid", "=", (Object)Long.parseLong(params.get("jobid").toString()));
            e.addCustomQFilter(qFilter);
        } else if (WfUtils.isNotEmptyForMap((Map)params) && params.get("pluginno") != null) {
            String elementId;
            String pluginNo = (String)params.get("pluginno");
            String processNo = (String)params.get("processno");
            QFilter qFPluginNo = new QFilter("pluginno", "=", (Object)pluginNo);
            QFilter qFProcessNo = new QFilter("processno", "=", (Object)processNo);
            String string = elementId = params.get("elementid") == null ? "" : (String)params.get("elementid");
            if (WfUtils.isNotEmpty((String)elementId)) {
                QFilter qFElementId = new QFilter("elementid", "=", (Object)elementId);
                e.addCustomQFilter(qFPluginNo.and(qFProcessNo).and(qFElementId));
            } else {
                e.addCustomQFilter(qFPluginNo.and(qFProcessNo));
            }
        }
        List qFilterList = e.getQFilters();
        if (!PluginUtil.check((IFormView)this.getView(), (List)qFilterList, (String[])new String[]{BEGINTIME})) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u8303\u56f4\u4e0d\u80fd\u8d85\u51fa3\u4e2a\u6708\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PluginExeDetailListPlugin_2", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        Date now = WfUtils.now();
        for (QFilter qf : qFilterList) {
            List nests;
            if (!BEGINTIME.equals(qf.getProperty()) || (nests = qf.getNests(true)) == null) continue;
            for (QFilter.QFilterNest qfNest : nests) {
                Date filterEnd;
                if (!(qfNest.getFilter().getValue() instanceof Date) || this.getLastDay(filterEnd = (Date)qfNest.getFilter().getValue()).compareTo(now) <= 0) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u65f6\u95f4\u4e0d\u80fd\u8d85\u8fc7\u5f53\u524d\u65f6\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PluginExeDetailListPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]));
            }
        }
        super.setFilter(e);
    }

    private Date getLastDay(Date filterEndDate) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(filterEndDate);
        cal.add(5, -1);
        return cal.getTime();
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if (EXECUTOR.equalsIgnoreCase(key)) {
            String value = String.valueOf(e.getRowData().get(EXECUTOR));
            e.setFormatValue((Object)PluginExeDetailListPlugin.desensitizeIP(value));
        } else if (FIELD_DURATION.equalsIgnoreCase(key)) {
            Long value = (Long)e.getRowData().get(FIELD_DURATION);
            BigDecimal bigDecimal = new BigDecimal(value);
            BigDecimal divDecimal = new BigDecimal(1000L);
            e.setFormatValue((Object)bigDecimal.divide(divDecimal, 2, 2));
        }
        super.packageData(e);
    }

    private static String desensitizeIP(String ip) {
        String ret = "";
        try {
            if (WfUtils.isNotEmpty((String)ip)) {
                int first = ip.indexOf(".");
                int last = ip.lastIndexOf(".");
                ret = ip.substring(0, first) + ".*.*." + ip.substring(last + 1, ip.length());
            }
        }
        catch (Exception e) {
            logger.warn(WfUtils.getExceptionStacktrace((Throwable)e));
        }
        return ret;
    }
}

