/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PluginExeSummaryPlugin
extends AbstractListPlugin {
    private static final String FIELD_ALARMMSG = "alarmmsg";
    private static final String SCENE = "scene";
    private static final String FIELD_TOTALDURATION = "totalduration";
    private static final String FIELD_AVERAGEDURATION = "averageduration";

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = args.getFieldName();
        Long pk = (Long)event.getCurrentRow().getPrimaryKeyValue();
        this.showListPage(fieldName, pk);
        args.setCancel(true);
    }

    private void showListPage(String hyperLinkClickFieldName, Long pk) {
        ListShowParameter parameter = new ListShowParameter();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_pluginexesummary", (String)"pluginno");
        if (dynObj == null) {
            return;
        }
        String pluginNo = (String)dynObj.get("pluginno");
        if (FIELD_AVERAGEDURATION.equalsIgnoreCase(hyperLinkClickFieldName)) {
            parameter.setBillFormId("wf_pluginprocinfo");
            parameter.setCustomParam("pluginno", (Object)pluginNo);
        } else if (FIELD_ALARMMSG.equalsIgnoreCase(hyperLinkClickFieldName)) {
            parameter.setCustomParam(SCENE, (Object)"plugintimeouterror");
            parameter.setCustomParam("group", (Object)pluginNo);
            parameter.setBillFormId("wf_alarmmsgsendlog");
        }
        parameter.setParentPageId(this.getView().getPageId());
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setCustomParam("isOpenNewTab", (Object)Boolean.TRUE);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void packageData(PackageDataEvent e) {
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if (FIELD_ALARMMSG.equalsIgnoreCase(key)) {
            String pluginNo = (String)e.getRowData().get("pluginno");
            if (this.isAlreadySendAlarmMsg(pluginNo)) {
                e.setFormatValue((Object)ResManager.loadKDString((String)"\u8be6\u60c5", (String)"PluginExeSummaryPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]));
            }
        } else if (FIELD_TOTALDURATION.equalsIgnoreCase(key)) {
            Long value = (Long)e.getRowData().get(FIELD_TOTALDURATION);
            e.setFormatValue((Object)PluginExeSummaryPlugin.getFormatValue(value));
        } else if (FIELD_AVERAGEDURATION.equalsIgnoreCase(key)) {
            Long value = (Long)e.getRowData().get(FIELD_AVERAGEDURATION);
            e.setFormatValue((Object)PluginExeSummaryPlugin.getFormatValue(value));
        }
        super.packageData(e);
    }

    private static BigDecimal getFormatValue(Long tempValue) {
        BigDecimal bigDecimal = new BigDecimal(tempValue);
        BigDecimal divDecimal = new BigDecimal(1000L);
        return bigDecimal.divide(divDecimal, 2, 2);
    }

    private boolean isAlreadySendAlarmMsg(String pluginNo) {
        QFilter qFilter = new QFilter("group", "=", (Object)pluginNo);
        return QueryServiceHelper.exists((String)"wf_alarmmsgsendlog", (QFilter[])new QFilter[]{qFilter});
    }
}

