/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryData;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.CheckPermissionReq;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.devops.pojo.ExceptedEntityData;
import kd.bos.workflow.devops.router.ProcessNotExistRouter;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.util.PermissionReqBuilder;
import org.apache.commons.collections.CollectionUtils;

public class ProcessExceptedEntityPlugin
extends AbstractFormPlugin {
    public static final String CALLBACK_INSERT_OK = "insert_ok";
    public static final String ENTRY_ENTITY = "entryentity";
    private static Log logger = LogFactory.getLog(ProcessExceptedEntityPlugin.class);
    private final ProcessNotExistRouter router = ProcessNotExistRouter.get();

    public void initialize() {
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        Button btnok = (Button)this.getControl("btnok");
        btnok.addClickListener((ClickListener)this);
        this.router.setPlugin(this);
    }

    public void afterCreateNewData(EventObject e) {
        List<ExceptedEntityData> collect = this.devopsService().findAllExceptedEntity().stream().map(ExceptedEntityData::from).collect(Collectors.toList());
        this.draw(collect);
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "add": {
                CheckPermissionReq req = PermissionReqBuilder.builder().common().setEntityNumber("wf_exceptedentity").newItem().build();
                PermResult result = PermissionServiceHelper.checkPermission((CheckPermissionReq)req);
                if (result.getCode() != 0) {
                    String entityName = ResManager.loadKDString((String)"\u4f8b\u5916", (String)"ProcessExceptedEntityPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]);
                    String permName = ResManager.loadKDString((String)"\u65b0\u589e", (String)"ProcessExceptedEntityPlugin_2", (String)"bos-wf-devops", (Object[])new Object[0]);
                    StandardTips.view((IFormView)this.getView()).noPerm(entityName, permName);
                    return;
                }
                this.router.toWfEntityObj(CALLBACK_INSERT_OK);
                break;
            }
            case "delete": {
                CheckPermissionReq req = PermissionReqBuilder.builder().common().setEntityNumber("wf_exceptedentity").delete().build();
                PermResult result = PermissionServiceHelper.checkPermission((CheckPermissionReq)req);
                if (result.getCode() != 0) {
                    String entityName = ResManager.loadKDString((String)"\u4f8b\u5916", (String)"ProcessExceptedEntityPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]);
                    String permName = ResManager.loadKDString((String)"\u5220\u9664", (String)"ProcessExceptedEntityPlugin_3", (String)"bos-wf-devops", (Object[])new Object[0]);
                    StandardTips.view((IFormView)this.getView()).noPerm(entityName, permName);
                    return;
                }
                List<ExceptedEntityData> selectedDate = this.getSelectedDate();
                if (selectedDate == null || selectedDate.isEmpty()) {
                    String msg = StandardTips.notSelectRowTips();
                    this.getView().showTipNotification(msg);
                    return;
                }
                this.deleteList(selectedDate);
            }
        }
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("btnok".equals(key)) {
            List<ExceptedEntityData> list = this.fetchList();
            this.devopsService().commitExceptedChanges(list);
            this.getView().close();
        }
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        String actionId = event.getActionId();
        if (CALLBACK_INSERT_OK.equals(actionId)) {
            String returnData = (String)event.getReturnData();
            if (StringUtils.isEmpty((CharSequence)returnData)) {
                return;
            }
            try {
                List list = (List)new ObjectMapper().readValue(returnData, (TypeReference)new TypeReference<List<ExceptedEntityData>>(){});
                this.addList(list);
            }
            catch (JsonProcessingException e) {
                logger.warn((Throwable)e);
            }
        }
    }

    private void draw(List<ExceptedEntityData> list) {
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.getModel().batchCreateNewEntryRow(ENTRY_ENTITY, list.size());
        for (int i = 0; i < list.size(); ++i) {
            ExceptedEntityData data = list.get(i);
            this.getModel().setValue("entityname", (Object)data.getEntityName(), i);
            this.getModel().setValue("entitynumber", (Object)data.getEntityNumber(), i);
        }
    }

    private List<ExceptedEntityData> fetchList() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        EntryData entryData = entryGrid.getEntryData();
        DynamicObject[] dataEntities = entryData.getDataEntitys();
        if (dataEntities != null && dataEntities.length > 0) {
            return Arrays.stream(dataEntities).map(ExceptedEntityData::from).collect(Collectors.toList());
        }
        return new ArrayList<ExceptedEntityData>(0);
    }

    private void addList(List<ExceptedEntityData> addList) {
        List<ExceptedEntityData> list = this.fetchList();
        ArrayList res = (ArrayList)CollectionUtils.subtract(addList, list);
        if (res.isEmpty()) {
            return;
        }
        list.addAll(res);
        this.draw(list);
    }

    private void deleteList(List<ExceptedEntityData> deleteList) {
        List<ExceptedEntityData> list = this.fetchList();
        ArrayList res = (ArrayList)CollectionUtils.subtract(list, deleteList);
        this.draw(res);
    }

    private List<ExceptedEntityData> getSelectedDate() {
        EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        int[] selectRows = entryGrid.getSelectRows();
        List<ExceptedEntityData> list = this.fetchList();
        return Arrays.stream(selectRows).mapToObj(list::get).collect(Collectors.toList());
    }

    private WFDevopsService devopsService() {
        return DevopsUtils.getWorkflowDevopsService();
    }
}

