/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bec.engine.utils.BatchOptionResult;
import kd.bos.bec.engine.utils.StandardTips;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.permission.model.PermResult;
import kd.bos.permission.model.perm.req.CheckPermissionReq;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.workflow.design.util.ProcessInstancePluginUtil;
import kd.bos.workflow.devopos.ProcessNotExistPoJo;
import kd.bos.workflow.devopos.ProcessNotExistReasonEnum;
import kd.bos.workflow.devopos.ReasonPayload;
import kd.bos.workflow.devops.enums.ReAddressType;
import kd.bos.workflow.devops.router.ProcessNotExistRouter;
import kd.bos.workflow.devops.service.WFDevopsService;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.devops.vo.AddressProcedureVo;
import kd.bos.workflow.engine.RepositoryService;
import kd.bos.workflow.engine.RuntimeService;
import kd.bos.workflow.engine.WfUtils;
import kd.bos.workflow.engine.impl.bpmn.behavior.TaskBehaviorUtil;
import kd.bos.workflow.engine.pojo.AddressParam;
import kd.bos.workflow.service.WorkflowService;
import kd.bos.workflow.service.impl.ServiceFactory;
import kd.bos.workflow.util.PermissionReqBuilder;

public class ProcessNotExistListHyperLinkPlugin
extends AbstractListPlugin {
    public static final String RETRY_CODE = "RETRY_CODE";
    public static final long RETYR_TIME_LIMIT = 1000L;
    public static final int MAX_SIZE = 100;
    public static final String DESIGNED = "DESIGNED";
    public final ProcessNotExistRouter router = ProcessNotExistRouter.get();
    public final StandardTips standardTips = new StandardTips();

    public void initialize() {
        this.router.setPlugin((AbstractFormPlugin)this);
        this.standardTips.setView(this.getView());
    }

    public void packageData(PackageDataEvent e) {
        long msgLogId;
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if ("errorreason".equals(key)) {
            String tips;
            if (ProcessNotExistReasonEnum.ERROR_ADDRESS.getReason().equals(e.getFormatValue())) {
                tips = ResManager.loadKDString((String)"\u5bfb\u5740\u5f02\u5e38", (String)"ProcessNotExist_2", (String)"bos-wf-devops", (Object[])new Object[0]);
                e.setFormatValue((Object)tips);
            } else if (ProcessNotExistReasonEnum.NOT_FIND.getReason().equals(e.getFormatValue())) {
                tips = ResManager.loadKDString((String)"\u65e0\u5339\u914d\u7684\u6d41\u7a0b", (String)"ProcessNotExist_3", (String)"bos-wf-devops", (Object[])new Object[0]);
                e.setFormatValue((Object)tips);
            } else if (ProcessNotExistReasonEnum.CONFLICT.getReason().equals(e.getFormatValue())) {
                ReasonPayload payload;
                String reasonPayload = e.getRowData().getString("reasonpayload");
                try {
                    payload = (ReasonPayload)new ObjectMapper().readValue(reasonPayload, (TypeReference)new TypeReference<ReasonPayload<List<Long>>>(){});
                }
                catch (Exception exception) {
                    payload = new ReasonPayload();
                }
                List processDefinitions = (List)payload.getData();
                String tips2 = ResManager.loadKDString((String)"\u627e\u5230%s\u6761\u6ee1\u8db3\u6761\u4ef6\u7684\u6d41\u7a0b", (String)"ProcessNotExist_4", (String)"bos-wf-devops", (Object[])new Object[0]);
                String format = String.format(tips2, Optional.ofNullable(processDefinitions).map(List::size).orElseGet(() -> 0));
                e.setFormatValue((Object)format);
            }
        }
        if ("alarmmsgsendlogid".equals(key) && (msgLogId = e.getRowData().getLong("alarmmsgsendlogid")) != 0L) {
            String tips = ResManager.loadKDString((String)"\u8be6\u60c5", (String)"ProcessNotExist_5", (String)"bos-wf-devops", (Object[])new Object[0]);
            e.setFormatValue((Object)tips);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof Donothing) {
            String operateKey;
            Donothing donothing = (Donothing)source;
            switch (operateKey = donothing.getOperateKey()) {
                case "retry": 
                case "designated": {
                    ListSelectedRowCollection selectedRows = this.getSelectedRows();
                    if (selectedRows == null || selectedRows.isEmpty()) {
                        args.setCancel(true);
                        return;
                    }
                    if (selectedRows.size() <= 100) break;
                    String tips = ResManager.loadKDString((String)"\u6700\u591a\u9009\u62e9%s\u6761\u3002", (String)"ProcessNotExistListHyperLinkPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]);
                    String format = String.format(tips, 100);
                    this.getView().showTipNotification(format);
                    args.setCancel(true);
                    return;
                }
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        Long id = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
        ProcessNotExistPoJo entity = this.devopsService().findProcessNotExistById(id);
        if ("billno".equals(args.getFieldName())) {
            this.router.showBillForm(entity);
        } else if ("errorreason".equals(args.getFieldName())) {
            if (ProcessNotExistReasonEnum.NOT_FIND == entity.getErrorReason()) {
                String entityNumber = entity.getEntityNumber();
                String businessKey = entity.getBusinessKey();
                List entities = this.runtimeService().findAddressParseLogByBusinessKey(entityNumber, businessKey);
                List<AddressProcedureVo> vos = entities.stream().map(AddressProcedureVo::fromEntity).collect(Collectors.toList());
                DynamicObject businessModel = WfUtils.findBusinessObject((String)businessKey, (String)entityNumber);
                String billNo = TaskBehaviorUtil.getTaskBillNo((String)entityNumber, (DynamicObject)businessModel);
                this.router.showAddressPath(entityNumber, billNo, vos);
            } else if (ProcessNotExistReasonEnum.ERROR_ADDRESS == entity.getErrorReason()) {
                this.router.showErrorAddressFrom(entity);
            } else if (ProcessNotExistReasonEnum.CONFLICT == entity.getErrorReason()) {
                ReasonPayload payload = entity.getPayload();
                List processDefinitions = (List)payload.getData();
                this.router.toProcessDefinitionList(processDefinitions);
            }
        } else if ("alarmmsgsendlogid".equals(args.getFieldName())) {
            this.router.toAlarmMsgSendLogList(entity.getAlarmMsgSendLogId());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "excepted": {
                CheckPermissionReq req = PermissionReqBuilder.builder().common().setEntityNumber("wf_exceptedentity").view().build();
                PermResult permResult = PermissionServiceHelper.checkPermission((CheckPermissionReq)req);
                int code = permResult.getCode();
                if (code != 0) {
                    String entityName = ResManager.loadKDString((String)"\u4f8b\u5916", (String)"ProcessNotExistListHyperLinkPlugin_7", (String)"bos-wf-devops", (Object[])new Object[0]);
                    String permName = ResManager.loadKDString((String)"\u67e5\u8be2", (String)"ProcessNotExistListHyperLinkPlugin_10", (String)"bos-wf-devops", (Object[])new Object[0]);
                    StandardTips.view((IFormView)this.getView()).noPerm(entityName, permName);
                    return;
                }
                this.router.toExceptedEntity();
                break;
            }
            case "alarmrule": {
                this.router.toAlarmRule();
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        switch (operateKey = e.getOperateKey()) {
            case "retry": {
                List<Long> ids = this.selectIds();
                BatchOptionResult<String> retry = this.retry(ids);
                if (StringUtils.isNotEmpty((CharSequence)retry.getMsg())) {
                    this.getView().showTipNotification(retry.getMsg());
                    break;
                }
                String s = ResManager.loadKDString((String)"\u5df2\u91cd\u8bd5\u3002", (String)"ProcessNotExistListHyperLinkPlugin_13", (String)"bos-wf-devops", (Object[])new Object[0]);
                BillList list = (BillList)this.getControl("billlistap");
                list.refresh();
                this.getView().showSuccessNotification(s);
                break;
            }
            case "designated": {
                List<Long> ids = this.selectIds();
                String entity = this.designated(ids);
                if (StringUtils.isEmpty((CharSequence)entity)) {
                    String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u540c\u7c7b\u578b\u5355\u636e\u3002", (String)"ProcessNotExistListHyperLinkPlugin_12", (String)"bos-wf-devops", (Object[])new Object[0]);
                    this.getView().showTipNotification(tips);
                    return;
                }
                if ("0".equals(entity)) {
                    return;
                }
                this.router.toDesignedProcess(entity, ids, DESIGNED);
                break;
            }
        }
    }

    public List<Long> selectIds() {
        if (this.getSelectedRows() == null || this.getSelectedRows().isEmpty() || this.getSelectedRows().size() > 100) {
            return new ArrayList<Long>(0);
        }
        return this.getSelectedRows().stream().map(item -> (Long)item.getPrimaryKeyValue()).collect(Collectors.toList());
    }

    private BatchOptionResult<String> retry(List<Long> ids) {
        BatchOptionResult result = new BatchOptionResult();
        if (this.tooFrequently()) {
            return result.setMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"ProcessNotExistListHyperLinkPlugin_5", (String)"bos-wf-devops", (Object[])new Object[0]));
        }
        long now = this.putRetryTime();
        List<ProcessNotExistPoJo> processNotExistByIds = this.devopsService().findProcessNotExistByIds(ids);
        List<AddressParam> collect = processNotExistByIds.stream().map(AddressParam::from).collect(Collectors.toList());
        return this.devopsService().batchRestartProcess(collect, ReAddressType.RETRY);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (DESIGNED.equals(actionId)) {
            BillList list = (BillList)this.getControl("billlistap");
            list.refresh();
        }
    }

    public String designated(List<Long> ids) {
        if (ids == null || ids.isEmpty() || ids.size() > 100) {
            return "";
        }
        Set<String> entities = this.devopsService().findProcessNotExistEntityNumberById(ids);
        if (entities.size() == 0) {
            return "0";
        }
        if (entities.size() > 1) {
            return "";
        }
        return new ArrayList<String>(entities).get(0);
    }

    public boolean tooFrequently() {
        String s = this.getPageCache().get(RETRY_CODE);
        if (StringUtils.isEmpty((CharSequence)s)) {
            this.putRetryTime();
            return false;
        }
        long lastRetryTime = Long.parseLong(s);
        return System.currentTimeMillis() - lastRetryTime < 1000L;
    }

    public long putRetryTime() {
        long now = System.currentTimeMillis();
        this.getPageCache().put(RETRY_CODE, now + "");
        return now;
    }

    private String getPermissionAppId() {
        return ProcessInstancePluginUtil.getPermissionAppId((IFormView)this.getView());
    }

    public RuntimeService runtimeService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRuntimeService();
    }

    public RepositoryService repositoryService() {
        WorkflowService wfService = (WorkflowService)ServiceFactory.getService(WorkflowService.class);
        return wfService.getRepositoryService();
    }

    public WFDevopsService getWorkflowDevopsService() {
        return DevopsUtils.getWorkflowDevopsService();
    }

    public WFDevopsService devopsService() {
        return DevopsUtils.getWorkflowDevopsService();
    }
}

