/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devops.util.DevopsUtils;

public class RepairSysErrorProcessInstanceListPlugin
extends AbstractListPlugin {
    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.stream().filter(f -> "duration".equals(f.getProperty())).forEach(f -> {
            Long time;
            if (f.getValue() instanceof Integer) {
                time = (long)((Integer)f.getValue()).intValue() * 1L;
            } else if (f.getValue() instanceof Long) {
                time = (Long)f.getValue();
            } else {
                return;
            }
            if (time > 0L) {
                f.__setValue((Object)DevopsUtils.converToMillSecond(time, "minute"));
            }
        });
        super.setFilter(e);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        Long pk = (Long)event.getCurrentRow().getPrimaryKeyValue();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_recoversyserrorjoblog", (String)"recoverdetails_tag");
        String details = dynObj.getString("recoverdetails_tag");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_recoverdetails");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("details", (Object)details);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5", (String)"RepairSysErrorProcessInstanceListPlugin_0", (String)"bos-wf-devops", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
        args.setCancel(true);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if (key.equals("duration")) {
            Object[] arr = (Object[])e.getFormatValue();
            arr[0] = DevopsUtils.millSecondConversion(rowData.getLong(key), "minute");
            e.setFormatValue((Object)arr);
        }
        super.packageData(e);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("reparibtn".equals(itemKey)) {
            DevopsUtils.getWorkflowDevopsService().sendRecoverSysErrorProcessInstanceJob();
        }
        super.itemClick(evt);
    }
}

