/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.alarmrulesetting;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.workflow.devops.pojo.AlarmReceiver;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfMultiLangUtils;
import kd.bos.workflow.engine.WfUtils;

public class AlarmMessageReceiverSettingPlugin
extends AbstractFormPlugin {
    private static final String USER = "user";
    private static final String WFADMIN = "wfadmin";
    private static final String BTNOK = "btnok";
    private static final String INITIATOR = "initiator";
    private static final String USERIDS = "userIds";
    private static final String USERNAME = "userNames";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (WfUtils.isNotEmptyForMap((Map)customParams)) {
            this.setUserValue(customParams.get(USER));
            this.getModel().setValue(INITIATOR, customParams.get(INITIATOR));
            this.getModel().setValue(WFADMIN, customParams.get(WFADMIN));
            if (customParams.get("isShowInitiator") == null || !((Boolean)customParams.get("isShowInitiator")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{INITIATOR});
            }
            if (customParams.get("isShowWfadmin") != null && !((Boolean)customParams.get("isShowWfadmin")).booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{WFADMIN});
            }
        }
        super.afterCreateNewData(e);
    }

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{BTNOK});
        MulBasedataEdit bosUserF7 = (MulBasedataEdit)this.getControl(USER);
        bosUserF7.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            FormShowParameter parameter = beforeF7SelectEvent.getFormShowParameter();
            parameter.setCustomParam("externalUserType", (Object)"all");
        });
        super.registerListener(e);
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if (BTNOK.equals(key)) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            Map<String, Object> userMap = this.getUserInfoFromF7();
            AlarmReceiver alarmReceiver = new AlarmReceiver();
            if (!userMap.isEmpty()) {
                alarmReceiver.setUserIds(userMap.get(USERIDS).toString());
            }
            alarmReceiver.setWfadmin((Boolean)this.getModel().getValue(WFADMIN));
            alarmReceiver.setInitiator((Boolean)this.getModel().getValue(INITIATOR));
            map.put("receiver_real", SerializationUtils.toJsonString((Object)alarmReceiver));
            map.put("receivername", (String)this.getDisplayValue(userMap.get(USERNAME)));
            this.getView().returnDataToParent(map);
        }
        this.getView().close();
        super.click(evt);
    }

    private Map<String, Object> getUserInfoFromF7() {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        Object value = this.getModel().getValue(USER);
        Optional.ofNullable(value).ifPresent(collection -> {
            StringBuilder userIds = new StringBuilder();
            LocaleString userName = new LocaleString();
            ((DynamicObjectCollection)collection).forEach(arg_0 -> AlarmMessageReceiverSettingPlugin.lambda$null$1((ILocaleString)userName, userIds, arg_0));
            map.put(USERNAME, userName);
            map.put(USERIDS, userIds);
        });
        return map;
    }

    private ILocaleString getDisplayValue(Object userName) {
        LocaleString display = new LocaleString();
        if (((Boolean)this.getModel().getValue(INITIATOR)).booleanValue()) {
            display.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)display, (ILocaleString)ResManager.getLocaleString((String)"\u63d0\u5355\u4eba", (String)"AlarmMessageReceiverSettingPlugin_1", (String)"bos-wf-devops"), (String)","));
        }
        if (((Boolean)this.getModel().getValue(WFADMIN)).booleanValue()) {
            display.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)display, (ILocaleString)ResManager.getLocaleString((String)"\u6d41\u7a0b\u7ba1\u7406\u5458", (String)"AlarmMessageReceiverSettingPlugin_0", (String)"bos-wf-devops"), (String)","));
        }
        if (userName instanceof ILocaleString) {
            display.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)display, (ILocaleString)((ILocaleString)userName), (String)","));
        }
        return WfMultiLangUtils.subString((ILocaleString)display, (int)0, (int)500);
    }

    private void setUserValue(Object receiverIds) {
        List<Object> ids = new ArrayList();
        if (StringUtils.isNotBlank((Object)receiverIds)) {
            ids = DevopsUtils.formatArrStrToSLongList((String)receiverIds, ",");
        }
        this.getModel().setValue(USER, (Object)ids.toArray());
    }

    private static /* synthetic */ void lambda$null$1(ILocaleString userName, StringBuilder userIds, DynamicObject obj) {
        DynamicObject user = obj.getDynamicObject("fbasedataid");
        userName.putAll((Map)WfMultiLangUtils.jointILocaleString((ILocaleString)userName, (ILocaleString)user.getLocaleString("name"), (String)","));
        userIds.append(user.getPkValue()).append(",");
    }
}

