/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractDevopsBarChartPlugin
extends AbstractDevopsWidgetsPlugin {
    protected static final String SERIES = "series";
    private static final String BARCHARTAP = "barchartap";
    private static final int MAX_NAMELENGTH = 10;

    @Override
    protected void refreshData() {
        BarChart barChart = this.getBarChart();
        barChart.clearData();
        barChart.clearGraphic();
        Map<String, LinkedHashMap<String, Long>> datas = this.getChartSeriesData();
        if (WfUtils.isEmptyForMap(datas)) {
            barChart.refresh();
            return;
        }
        this.setChartTitle(barChart, datas);
        this.createSeries(barChart, datas);
        this.setLegend(barChart, datas);
        this.setFloatToolTipStyle(barChart, datas);
        this.createXAxis(barChart, datas);
        this.createYAxis(barChart, datas);
        this.setCustomeStyle(barChart, datas);
        barChart.refresh();
    }

    protected BarChart getBarChart() {
        return (BarChart)this.getControl(BARCHARTAP);
    }

    protected abstract Map<String, LinkedHashMap<String, Long>> getChartSeriesData();

    protected Axis createXAxis(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        Axis x = chart.createXAxis("", AxisType.value);
        JSONObject textStyle = new JSONObject();
        textStyle.put("color", (Object)"#999999");
        x.setPropValue("axisLabel", (Object)textStyle);
        x.setPropValue("nameTextStyle", (Object)textStyle);
        return x;
    }

    protected Axis createYAxis(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        Axis y = chart.createYAxis("", AxisType.category);
        LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
        ArrayList list = new ArrayList();
        seriesData.forEach((key, value) -> {
            if (key.length() > 10) {
                list.add(key.substring(0, 10) + "...");
            } else {
                list.add(key);
            }
        });
        y.setCategorys(list.toArray(new String[0]));
        JSONObject axisLabel = new JSONObject();
        axisLabel.put("width", (Object)300);
        axisLabel.put("color", (Object)"#999999");
        y.setPropValue("axisLabel", (Object)axisLabel);
        return y;
    }

    protected void setFloatToolTipStyle(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTooltip(true);
        JSONObject json = new JSONObject();
        String formatter = "function(params){ var data = params.data;  return (data.name+ '\uff1a' +data.value);}";
        json.put("formatter", (Object)formatter);
        json.put("trigger", (Object)"item");
        chart.addProperty("tooltip", (Object)json);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        chart.addFuncPath(toolTipFuncPath);
    }

    protected List<BarSeries> createSeries(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        ArrayList<BarSeries> barSeriesList = new ArrayList<BarSeries>(1);
        datas.forEach((key, map) -> {
            BarSeries series = chart.createBarSeries(key);
            ArrayList lists = new ArrayList(map.size());
            map.forEach((name, count) -> lists.add(new ItemValue(name, (Number)count)));
            series.setData(lists.toArray(new ItemValue[0]));
            barSeriesList.add(series);
            Label label = series.getLabel();
            label.setColor("#ffffff");
            label.setPosition(Position.inside);
            series.setLabel(label);
            series.setAnimationDuration(2000);
        });
        return barSeriesList;
    }

    protected void setCustomeStyle(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setMargin(Position.right, "30px");
        chart.setMargin(Position.top, "20px");
    }

    protected void setLegend(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowLegend(false);
    }

    protected void setChartTitle(BarChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTitle(Boolean.FALSE.booleanValue());
    }
}

