/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.ItemValue;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractDevopsHistogramChartPlugin
extends AbstractDevopsWidgetsPlugin {
    protected static final String SERIES = "series";
    protected static final String HISTOGRAMCHARTAP = "histogramchartap";

    @Override
    protected void refreshData() {
        HistogramChart histogramChart = this.getHistogramChart();
        histogramChart.clearData();
        histogramChart.clearGraphic();
        Map<String, LinkedHashMap<String, Long>> datas = this.getChartSeriesData();
        if (WfUtils.isEmptyForMap(datas)) {
            histogramChart.refresh();
            return;
        }
        this.setChartTitle(histogramChart, datas);
        this.createSeries(histogramChart, datas);
        this.setLegend(histogramChart, datas);
        this.setFloatToolTipStyle(histogramChart, datas);
        this.createXAxis(histogramChart, datas);
        this.createYAxis(histogramChart, datas);
        this.setCustomeStyle(histogramChart, datas);
        histogramChart.refresh();
    }

    protected HistogramChart getHistogramChart() {
        return (HistogramChart)this.getControl(HISTOGRAMCHARTAP);
    }

    protected abstract Map<String, LinkedHashMap<String, Long>> getChartSeriesData();

    protected Axis createXAxis(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        Axis x = chart.createXAxis("", AxisType.category);
        LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
        Set keys = seriesData.keySet();
        x.setCategorys(keys.toArray(new String[0]));
        JSONObject textStyle = new JSONObject();
        textStyle.put("color", (Object)"#999999");
        x.setPropValue("axisLabel", (Object)textStyle);
        x.setPropValue("nameTextStyle", (Object)textStyle);
        return x;
    }

    protected Axis createYAxis(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        Axis y = chart.createYAxis(ResManager.loadKDString((String)"\u6761", (String)"ProcessCountHistogramChartPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]), AxisType.value);
        JSONObject textStyle = new JSONObject();
        textStyle.put("color", (Object)"#999999");
        y.setPropValue("axisLabel", (Object)textStyle);
        y.setPropValue("nameTextStyle", (Object)textStyle);
        return y;
    }

    protected void setFloatToolTipStyle(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTooltip(true);
        JSONObject json = new JSONObject();
        String formatter = "function(params){ var data = params.data;  return (data.name+ '\uff1a' +data.value);}";
        json.put("formatter", (Object)formatter);
        json.put("trigger", (Object)"item");
        chart.addProperty("tooltip", (Object)json);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        chart.addFuncPath(toolTipFuncPath);
    }

    protected List<BarSeries> createSeries(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        ArrayList<BarSeries> barSeriesList = new ArrayList<BarSeries>(1);
        datas.forEach((key, map) -> {
            BarSeries series = chart.createBarSeries(key);
            ArrayList lists = new ArrayList(map.size());
            map.forEach((name, count) -> lists.add(new ItemValue(name, (Number)count)));
            series.setData(lists.toArray(new ItemValue[0]));
            series.setBarWidth("18");
            barSeriesList.add(series);
        });
        return barSeriesList;
    }

    protected void setCustomeStyle(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        JSONObject grid = new JSONObject();
        grid.put("top", (Object)"15%");
        chart.addProperty("grid", (Object)grid);
    }

    protected void setLegend(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowLegend(false);
    }

    protected void setChartTitle(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTitle(Boolean.FALSE.booleanValue());
    }
}

