/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.ChartType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.engine.WfUtils;

public abstract class AbstractDevopsPieChartPlugin
extends AbstractDevopsWidgetsPlugin {
    protected static final String SERIES = "series1";
    private static final String PIECHARTAP = "piechartap";
    private static final String DEFAULT_FLOATTIPJS = "function(params){ var data = params.data;  return (data.name+ '\uff1a' +data.value + '(' + (data.value*100/%s).toFixed(2) + '%s' +  ')');}";
    private static final String DEFAULT_LABELJS = "function(params){ var data = params.data; var tmp = data.name ; var len = window.screen.width > 1300 ? 6 : 3; if(tmp.length > len) {tmp = tmp.substring(0,len) + '...'; } return ((data.value*100/%s).toFixed(2) + '%s'+ ','\n+tmp);}";

    @Override
    protected void refreshData() {
        try {
            PieChart pieChart = this.getPieChart();
            pieChart.clearData();
            pieChart.clearGraphic();
            Map<String, LinkedHashMap<String, Long>> datas = this.getChartSeriesData();
            if (WfUtils.isEmptyForMap(datas)) {
                pieChart.refresh();
                return;
            }
            this.setChartTitle(pieChart, datas);
            this.createSeries(pieChart, datas);
            this.setLegend(pieChart, datas);
            this.setFloatToolTipStyle(pieChart, datas);
            this.setCustomeStyle(pieChart, datas);
            pieChart.refresh();
        }
        catch (Exception e) {
            this.logger.info(((Object)((Object)this)).getClass().getName() + ":" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    protected PieChart getPieChart() {
        return (PieChart)this.getControl(PIECHARTAP);
    }

    protected void setLegend(PieChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowLegend(false);
    }

    protected abstract Map<String, LinkedHashMap<String, Long>> getChartSeriesData();

    protected void setFloatToolTipStyle(PieChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTooltip(true);
        JSONObject json = new JSONObject();
        String formatter = this.getFloatToolTipFormatterJS(datas);
        json.put("formatter", (Object)formatter);
        json.put("trigger", (Object)"item");
        chart.addProperty("tooltip", (Object)json);
        ArrayList<String> toolTipFuncPath = new ArrayList<String>();
        toolTipFuncPath.add("tooltip");
        toolTipFuncPath.add("formatter");
        chart.addFuncPath(toolTipFuncPath);
    }

    protected List<PieSeries> createSeries(PieChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        ArrayList<PieSeries> series = new ArrayList<PieSeries>();
        PieSeries pieSeries = chart.createPieSeries(SERIES);
        pieSeries.setType(ChartType.pie);
        if (this.isRingPieChart().booleanValue()) {
            pieSeries.setRadius("35", "55");
        } else {
            pieSeries.setPropValue("radius", (Object)55);
        }
        pieSeries.setPropValue("startAngle", (Object)360);
        JSONObject json = new JSONObject();
        json.put("formatter", (Object)this.getLabelFormatterJs(datas));
        json.put("color", (Object)"#666666");
        pieSeries.setPropValue("label", (Object)json);
        ArrayList<String> zz = new ArrayList<String>();
        zz.add("label");
        zz.add("formatter");
        pieSeries.addFuncPath(zz);
        ArrayList list = new ArrayList(datas.size());
        LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
        seriesData.forEach((key, value) -> list.add(new ItemValue(key, (Number)value)));
        pieSeries.setData(list.toArray(new ItemValue[0]));
        series.add(pieSeries);
        return series;
    }

    protected void setChartTitle(PieChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        if (this.isRingPieChart().booleanValue()) {
            Long sum = 0L;
            LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
            for (Map.Entry entry : seriesData.entrySet()) {
                sum = sum + (Long)entry.getValue();
            }
            JSONObject title = new JSONObject();
            title.put("text", (Object)sum);
            title.put("subtext", (Object)ResManager.loadKDString((String)"\u603b\u6570", (String)"AbstractDevopsPieChartPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]));
            title.put("show", (Object)"true");
            title.put("itemGap", (Object)5);
            title.put("left", (Object)"center");
            title.put("top", (Object)"center");
            chart.addProperty("title", (Object)title);
        } else {
            chart.setShowTitle(false);
        }
    }

    protected void setCustomeStyle(PieChart pieChart, Map<String, LinkedHashMap<String, Long>> datas) {
    }

    protected Boolean isRingPieChart() {
        return Boolean.FALSE;
    }

    protected String getFloatToolTipFormatterJS(Map<String, LinkedHashMap<String, Long>> datas) {
        Long sum = 0L;
        LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
        for (Map.Entry entry : seriesData.entrySet()) {
            sum = sum + (Long)entry.getValue();
        }
        return String.format(DEFAULT_FLOATTIPJS, sum, "%");
    }

    protected String getLabelFormatterJs(Map<String, LinkedHashMap<String, Long>> datas) {
        Long sum = 0L;
        LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
        for (Map.Entry entry : seriesData.entrySet()) {
            sum = sum + (Long)entry.getValue();
        }
        return String.format(DEFAULT_LABELJS, sum, "%");
    }
}

