/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.GradientItem;
import kd.bos.form.chart.PointLineChart;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.engine.WfUtils;
import org.apache.commons.collections.map.LinkedMap;

public abstract class AbstractDevopsPointLineChartPlugin
extends AbstractDevopsWidgetsPlugin {
    private static final String POINTLINECHARTAP = "pointlinechartap";

    @Override
    protected void refreshData() {
        try {
            PointLineChart pointLineChart = this.getPointLineChart();
            pointLineChart.clearData();
            pointLineChart.clearGraphic();
            Map<String, LinkedHashMap<String, Long>> datas = this.getChartSeriesData();
            if (WfUtils.isEmptyForMap(datas)) {
                pointLineChart.refresh();
                return;
            }
            this.setChartTitle((Chart)pointLineChart, datas);
            this.createSeries((Chart)pointLineChart, datas);
            this.setLegend((Chart)pointLineChart, datas);
            this.setFloatToolTipStyle((Chart)pointLineChart, datas);
            this.createXAxis((Chart)pointLineChart, datas);
            this.createYAxis((Chart)pointLineChart, datas);
            this.setCustomeStyle((Chart)pointLineChart, datas);
            pointLineChart.refresh();
        }
        catch (Exception e) {
            this.logger.info(((Object)((Object)this)).getClass().getName() + ":" + WfUtils.getExceptionStacktrace((Throwable)e));
        }
    }

    protected PointLineChart getPointLineChart() {
        return (PointLineChart)this.getControl(POINTLINECHARTAP);
    }

    protected Axis createXAxis(Chart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        Axis x = chart.createXAxis("", AxisType.category);
        x.setPropValue("boundaryGap", (Object)false);
        LinkedHashMap seriesData = datas.values().stream().findFirst().orElseGet(LinkedHashMap::new);
        x.setCategorys(seriesData.keySet().toArray(new String[0]));
        JSONObject textStyle = new JSONObject();
        textStyle.put("color", (Object)"#999999");
        x.setPropValue("axisLabel", (Object)textStyle);
        x.setPropValue("nameTextStyle", (Object)textStyle);
        return x;
    }

    protected Axis createYAxis(Chart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        Axis y = chart.createYAxis(ResManager.loadKDString((String)"\u6761", (String)"ProcessCountHistogramChartPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]), AxisType.value);
        JSONObject textStyle = new JSONObject();
        textStyle.put("color", (Object)"#999999");
        y.setPropValue("axisLabel", (Object)textStyle);
        y.setPropValue("nameTextStyle", (Object)textStyle);
        return y;
    }

    protected void setCustomeStyle(Chart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        JSONObject grid = new JSONObject();
        grid.put("left", (Object)"25");
        grid.put("right", (Object)"30");
        chart.addProperty("grid", (Object)grid);
    }

    protected void setFloatToolTipStyle(Chart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTooltip(true);
    }

    protected abstract void createSeries(Chart var1, Map<String, LinkedHashMap<String, Long>> var2);

    protected void setLegend(Chart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowLegend(true);
        chart.setLegendPropValue("icon", (Object)"line");
    }

    protected void setChartTitle(Chart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        chart.setShowTitle(Boolean.FALSE.booleanValue());
    }

    protected abstract Map<String, LinkedHashMap<String, Long>> getChartSeriesData();

    protected LinkedMap getRecentThirtyMinutes() {
        LinkedMap minutes = new LinkedMap(7);
        Calendar now = Calendar.getInstance();
        now.setTime(WfUtils.now());
        now.add(12, -35);
        SimpleDateFormat dimFormat = new SimpleDateFormat("yyyyMMddHHmm");
        SimpleDateFormat xAxisFormat = new SimpleDateFormat("HH:mm");
        int len = 8;
        for (int i = 0; i < len; ++i) {
            minutes.put((Object)dimFormat.format(now.getTime()), (Object)xAxisFormat.format(now.getTime()));
            now.add(12, 5);
        }
        return minutes;
    }

    protected List<GradientItem> getAreaColor(String color) {
        if (StringUtils.isBlank((CharSequence)color)) {
            return Collections.emptyList();
        }
        ArrayList<GradientItem> items = new ArrayList<GradientItem>();
        GradientItem gradientItem = new GradientItem();
        GradientItem gradientItem2 = new GradientItem();
        gradientItem.setColor("rgba(255,255,255, 0.3)");
        gradientItem.setOffset(0);
        gradientItem2.setColor(color);
        gradientItem2.setOffset(1);
        items.add(gradientItem);
        items.add(gradientItem2);
        return items;
    }
}

