/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets;

import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.pluginnew.CardUtils;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.workflow.devops.util.DevopsUtils;

public abstract class AbstractDevopsWidgetsPlugin
extends AbstractFormPlugin {
    protected Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    protected static final String REFRESH = "vectorap1";
    protected static final String COMBOFIELD = "combofield";
    private static final String DAYBEGIN = "1";
    private static final String WEEKBEGIN = "2";
    private static final String MONTHBEGIN = "3";
    private static final String THREEMONTHSBEFORE = "4";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{REFRESH});
    }

    public void afterCreateNewData(EventObject e) {
        this.refreshData();
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (REFRESH.equals(key)) {
            this.refreshData();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (COMBOFIELD.equals(property.getName())) {
            this.refreshData();
        }
    }

    protected void refreshData() {
        LinkedHashMap<String, Object> data = this.getData();
        this.setData(data);
    }

    protected LinkedHashMap<String, Object> getData() {
        return new LinkedHashMap<String, Object>();
    }

    protected void setData(LinkedHashMap<String, Object> datas) {
        for (Map.Entry<String, Object> entry : datas.entrySet()) {
            ((Label)this.getControl(entry.getKey())).setText(entry.getValue().toString());
        }
    }

    protected String getSelectComboxData() {
        return (String)this.getView().getModel().getValue(COMBOFIELD);
    }

    protected Date getSelectDate(String type) {
        Date date = new Date();
        switch (type) {
            case "1": {
                date = DevopsUtils.getDateOfDayBegin();
                break;
            }
            case "2": {
                date = DevopsUtils.getDateOfWeekBegin();
                break;
            }
            case "3": {
                date = DevopsUtils.getDateOyMonthBegin();
                break;
            }
            case "4": {
                date = DevopsUtils.getDateBeforeThreeMonths();
                break;
            }
        }
        return date;
    }

    protected void showForm(String entityNumber, String openAppNum, String formBelongToAppNum, String filterSchemeId) {
        AppInfo appInfo = AppMetadataCache.getAppInfo((String)openAppNum);
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        JSONObject parameter = new JSONObject();
        String menuId = CardUtils.findMenuId((String)formBelongToAppNum, (String)entityNumber);
        AppMenuInfo menu = AppMetadataCache.getAppMenuInfo((String)openAppNum, (String)menuId);
        if (Objects.nonNull(menu)) {
            map.put("menuname", menu.getName());
            map.put("openType", menu.getOpenType());
            map.put("permItem", menu.getPermission());
            if (Objects.nonNull(menu.getParams())) {
                JSONObject menuParamJson = JSONObject.parseObject((String)menu.getParams());
                parameter.putAll((Map)menuParamJson);
            }
        }
        map.put("view", this.getView());
        map.put("appname", appInfo.getName().getLocaleValue());
        String formNum = appInfo.getHomeNum();
        map.put("appmainnumber", formNum);
        map.put("formnumber", entityNumber);
        map.put("parametertype", "ListShowParameter");
        parameter.put("filterSchemeId", (Object)filterSchemeId);
        map.put("parameter", parameter);
        OpenPageUtils.openAppForCardCount((String)openAppNum, (String)menuId, map, (IFormView)this.getView());
    }
}

