/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.bec;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;

public class BecStatisticsCardPlugin
extends AbstractDevopsWidgetsPlugin {
    private static final String EVENT = "businessEventDef";
    private static final String SUBSCRIBTION = "businessSubscription";
    private static final String SERVICE = "businessService";
    private static final String NULLCOLOR = "#bbbbbb";
    private static final String BECAPPNUM = "bec";
    private static final String[] CAPTURES = new String[]{"businessEventDef", "businessService", "businessSubscription"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{EVENT, SUBSCRIBTION, SERVICE});
    }

    public void beforeBindData(EventObject e) {
        this.refreshData();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (EVENT.equalsIgnoreCase(key)) {
            this.showForm("evt_event", BECAPPNUM, BECAPPNUM, null);
        } else if (SUBSCRIBTION.equalsIgnoreCase(key)) {
            this.showForm("evt_subscription", BECAPPNUM, BECAPPNUM, null);
        } else if (SERVICE.equalsIgnoreCase(key)) {
            this.showForm("evt_service", BECAPPNUM, BECAPPNUM, null);
        }
    }

    @Override
    protected void setData(LinkedHashMap<String, Object> datas) {
        super.setData(datas);
        for (Map.Entry<String, Object> entry : datas.entrySet()) {
            Object total = entry.getValue();
            if (!StringUtils.isBlank((Object)total) && (Long)total != 0L) continue;
            this.updateColor(entry.getKey());
        }
    }

    @Override
    protected LinkedHashMap<String, Object> getData() {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        for (String capture : CAPTURES) {
            List<IndicatorInfo> infos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo(capture, null);
            long count = 0L;
            if (WfUtils.isNotEmptyForCollection(infos)) {
                count = infos.stream().mapToLong(IndicatorInfo::getTotal).sum();
            }
            dataMap.put(capture.toLowerCase(), count);
        }
        return dataMap;
    }

    private void updateColor(String control) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", NULLCOLOR);
        this.getView().updateControlMetadata(control, map);
    }
}

