/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.wf;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;

public class DevopsProcessStatisticsCardPlugin
extends AbstractDevopsWidgetsPlugin {
    private static final String PROCESSDEFINITION = "processdefinition";
    private static final String PROCESSINSTANCE = "processinstance";
    private static final String EXCEPTIONALPROCESS = "exceptionalprocess";
    private static final String NULLCOLOR = "#bbbbbb";
    private static final String WF_PROCESSDEFINITION_SCHEMEID = "3ACCUS24WFQB";
    private static final String BPM_PROCESSDEFINITION_SCHEMEID = "2+6QGVDKDBAL";
    private static final String WF_PROCESS_SCHEMEID = "3GKRWQZWO3F=";
    private static final String BPM_PROCESS_SCHEMEID = "3GKS+X=CUZ+Z";
    private static final String WF_EXCEPTIONALPROCESS_SCHEMEID = "M7/1HYP2B7R";
    private static final String BPM_EXCEPTIONALPROCESS_SCHEMEID = "3EN4+3D01TT2";
    private static final String WFAPPNUM = "wf";
    private static final String BPMAPPNUM = "bpm";
    private static final String[] CAPTURES = new String[]{"processInstance", "processDefinition", "exceptionalprocess"};

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{PROCESSDEFINITION, PROCESSINSTANCE, EXCEPTIONALPROCESS});
    }

    public void beforeBindData(EventObject e) {
        this.refreshData();
    }

    @Override
    public void afterCreateNewData(EventObject e) {
    }

    @Override
    public void click(EventObject evt) {
        String belongToAppNum;
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        boolean isBizFlow = "BizFlow".equalsIgnoreCase((String)this.getView().getModel().getValue("combofield"));
        String string = belongToAppNum = isBizFlow ? BPMAPPNUM : WFAPPNUM;
        if (PROCESSDEFINITION.equals(key)) {
            String entityNumber = isBizFlow ? "bpm_processmanage" : "wf_processdefinition";
            String filterSchemeId = isBizFlow ? BPM_PROCESSDEFINITION_SCHEMEID : WF_PROCESSDEFINITION_SCHEMEID;
            this.showForm(entityNumber, WFAPPNUM, belongToAppNum, filterSchemeId);
        } else if (PROCESSINSTANCE.equals(key)) {
            String entityNumber = isBizFlow ? "wf_execution_tree" : "wf_execution";
            String filterSchemeId = isBizFlow ? BPM_PROCESS_SCHEMEID : WF_PROCESS_SCHEMEID;
            this.showForm(entityNumber, WFAPPNUM, belongToAppNum, filterSchemeId);
        } else if (EXCEPTIONALPROCESS.equals(key)) {
            String entityNumber = isBizFlow ? "wf_execution_tree" : "wf_execution";
            String filterSchemeId = isBizFlow ? BPM_EXCEPTIONALPROCESS_SCHEMEID : WF_EXCEPTIONALPROCESS_SCHEMEID;
            this.showForm(entityNumber, WFAPPNUM, belongToAppNum, filterSchemeId);
        }
    }

    @Override
    protected void setData(LinkedHashMap<String, Object> datas) {
        for (Map.Entry<String, Object> entry : datas.entrySet()) {
            Object total = entry.getValue();
            if (StringUtils.isBlank((Object)total) || (Long)total == 0L) {
                total = 0L;
                this.updateColor(entry.getKey());
            }
            ((Label)this.getControl(entry.getKey())).setText(total.toString());
        }
    }

    @Override
    protected LinkedHashMap<String, Object> getData() {
        String type = this.getSelectComboxData();
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        for (String capture : CAPTURES) {
            List<IndicatorInfo> infos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo(capture, type);
            if (!WfUtils.isNotEmptyForCollection(infos)) continue;
            dataMap.put(capture.toLowerCase(), infos.get(0).getTotal());
        }
        return dataMap;
    }

    private void updateColor(String control) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("fc", NULLCOLOR);
        this.getView().updateControlMetadata(control, map);
    }
}

