/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.wf;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.chart.HistogramChart;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsHistogramChartPlugin;
import kd.bos.workflow.devops.util.DevopsUtils;
import kd.bos.workflow.engine.WfUtils;

public class ProcessCountHistogramChartPlugin
extends AbstractDevopsHistogramChartPlugin {
    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"combofield"});
    }

    @Override
    protected Map<String, LinkedHashMap<String, Long>> getChartSeriesData() {
        HashMap<String, LinkedHashMap<String, Long>> datas = new HashMap<String, LinkedHashMap<String, Long>>(1);
        LinkedHashMap map = new LinkedHashMap();
        String type = (String)this.getModel().getValue("combofield");
        LinkedHashMap<String, String> months = this.getRecentSixMonths();
        List<IndicatorInfo> infos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo(type, null);
        months.forEach((key, value) -> {
            Iterator iterator = infos.iterator();
            Long count = 0L;
            while (iterator.hasNext()) {
                IndicatorInfo info = (IndicatorInfo)iterator.next();
                if (!StringUtils.isNotBlank((Object)info.getDimValue()) || !key.equalsIgnoreCase(info.getDimValue().toString())) continue;
                count = info.getTotal();
                iterator.remove();
                break;
            }
            map.put(value, count);
        });
        datas.put("series", map);
        return datas;
    }

    @Override
    protected void setCustomeStyle(HistogramChart chart, Map<String, LinkedHashMap<String, Long>> datas) {
        JSONObject grid = new JSONObject();
        grid.put("top", (Object)"20%");
        chart.addProperty("grid", (Object)grid);
    }

    private LinkedHashMap<String, String> getRecentSixMonths() {
        LinkedHashMap<String, String> months = new LinkedHashMap<String, String>(6);
        Calendar now = Calendar.getInstance();
        now.setTime(WfUtils.now());
        now.add(2, -5);
        SimpleDateFormat format = new SimpleDateFormat("yyyyMM");
        int len = 6;
        for (int i = 0; i < len; ++i) {
            months.put(format.format(now.getTime()), ResManager.loadKDString((String)"%s\u6708", (String)"ProcessCountHistogramChartPlugin_2", (String)"bos-wf-devops", (Object[])new Object[]{now.get(2) + 1}));
            now.add(2, 1);
        }
        return months;
    }
}

