/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.wf;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;

public class ProcessExecutedTimeListCardPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    private static final String REFRESH = "vectorap1";
    private static final String BTN_MORE = "btnmore";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MORE, REFRESH});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addPackageDataListener(this::packageData);
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (REFRESH.equalsIgnoreCase(key)) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            list.refreshData();
        } else if (BTN_MORE.equals(key)) {
            this.showFormList();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        this.showFormList();
    }

    private void showFormList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_pluginprocinfo");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addPackageDataListener(this::packageData);
        super.beforeBindData(e);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if (key.equals("averageduration")) {
            Object[] arr = (Object[])e.getFormatValue();
            BigDecimal bigDecimal = new BigDecimal(rowData.getLong(key));
            arr[0] = bigDecimal.divide(new BigDecimal(1000L), 2, 2);
            e.setFormatValue((Object)arr);
        }
        super.packageData(e);
    }
}

