/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.wf;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.list.ListShowParameter;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.devops.util.DevopsUtils;

public class ProcessPluginExecutedTimeCardPlugin
extends AbstractDevopsWidgetsPlugin {
    private static final String BTN_MORE = "btnmore";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MORE});
    }

    @Override
    protected void refreshData() {
        LinkedHashMap<String, Object> map = this.getData();
        if (map.isEmpty()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"costlist"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"image"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"image"});
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"costlist"});
        this.setData(map);
    }

    @Override
    protected void setData(LinkedHashMap<String, Object> datas) {
        int i = 1;
        for (Map.Entry<String, Object> entry : datas.entrySet()) {
            String controlName = "name" + i;
            String controlValue = "value" + i;
            ((Label)this.getControl(controlName)).setText(entry.getKey());
            Long value = (Long)Optional.ofNullable(entry.getValue()).orElseGet(() -> 0L);
            BigDecimal bigDecimal = new BigDecimal(value);
            ((Label)this.getControl(controlValue)).setText(bigDecimal.divide(new BigDecimal(1000L), 2, 2).toString());
            ++i;
        }
        String controlDiv = "line";
        ArrayList<String> hideList = new ArrayList<String>(6);
        while (i < 6) {
            hideList.add(controlDiv + i);
            ++i;
        }
        this.getView().setVisible(Boolean.FALSE, hideList.toArray(new String[0]));
    }

    @Override
    protected LinkedHashMap<String, Object> getData() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(5);
        List<IndicatorInfo> infos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo("pluginExecutionInfo", null);
        infos.forEach(info -> {
            ILocaleString pluginname = info.getDimDisplayValue();
            Long averageduration = info.getTotal();
            map.put(pluginname.toString(), averageduration);
        });
        return map;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (BTN_MORE.equals(key)) {
            this.showFormList();
        }
    }

    private void showFormList() {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_pluginexesummary");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)parameter);
    }
}

