/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.wf;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.events.SetFilterListener;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.devops.util.DevopsUtils;

public class RecoverDeadletterJobsListCardPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
SetFilterListener {
    private static final String REFRESH = "vectorap1";
    private static final String BTN_MORE = "btnmore";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_MORE, REFRESH});
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addPackageDataListener(this::packageData);
    }

    public void click(EventObject evt) {
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (REFRESH.equalsIgnoreCase(key)) {
            BillList list = (BillList)this.getControl(BILLLISTAP);
            list.refreshData();
        } else if (BTN_MORE.equals(key)) {
            this.showFormList(null);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent args) {
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args;
        Long pk = (Long)event.getCurrentRow().getPrimaryKeyValue();
        DynamicObject dynObj = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"wf_recoversyserrorjoblog", (String)"recoverdetails_tag");
        String details = dynObj.getString("recoverdetails_tag");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("wf_recoverdetails");
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("details", (Object)details);
        showParameter.setCaption(ResManager.loadKDString((String)"\u5f02\u5e38\u65e5\u5fd7\u8be6\u60c5", (String)"RepairSysErrorProcessInstanceListPlugin_0", (String)"bos-wf-devops", (Object[])new Object[0]));
        this.getView().showForm(showParameter);
    }

    public void beforeBindData(EventObject e) {
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        billList.addHyperClickListener((HyperLinkClickListener)this);
        billList.addSetFilterListener((SetFilterListener)this);
        billList.addPackageDataListener(this::packageData);
        super.beforeBindData(e);
    }

    private void showFormList(Long pk) {
        ListShowParameter parameter = new ListShowParameter();
        parameter.setBillFormId("wf_recoversyserrorjoblog");
        parameter.setFormId("bos_list");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject rowData = e.getRowData();
        ColumnDesc source = (ColumnDesc)e.getSource();
        String key = source.getKey();
        if (key.equals("duration")) {
            Object[] arr = (Object[])e.getFormatValue();
            arr[0] = DevopsUtils.millSecondConversion(rowData.getLong(key), "minute");
            e.setFormatValue((Object)arr);
        }
        super.packageData(e);
    }

    public void setFilter(SetFilterEvent e) {
        List qFilters = e.getQFilters();
        qFilters.stream().filter(f -> "duration".equals(f.getProperty())).forEach(f -> {
            Long time;
            if (f.getValue() instanceof Integer) {
                time = (long)((Integer)f.getValue()).intValue() * 1L;
            } else if (f.getValue() instanceof Long) {
                time = (Long)f.getValue();
            } else {
                return;
            }
            if (time > 0L) {
                f.__setValue((Object)DevopsUtils.converToMillSecond(time, "minute"));
            }
        });
        super.setFilter(e);
    }
}

