/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.devops.plugin.widgets.wf;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.schedule.api.ExecutorServerInfo;
import kd.bos.schedule.api.SchCheckResult;
import kd.bos.schedule.next.ClientObservableUtils;
import kd.bos.schedule.server.next.ServerObservableUtils;
import kd.bos.url.UrlService;
import kd.bos.workflow.devopos.info.IndicatorInfo;
import kd.bos.workflow.devops.plugin.widgets.AbstractDevopsWidgetsPlugin;
import kd.bos.workflow.devops.util.DevopsUtils;

public class ScheduleCardPlugin
extends AbstractDevopsWidgetsPlugin {
    private static final String BTNDETAIL = "btndetail";
    private static final String STATE_BUSY = "busy";
    private static final String STATE_BLOCK = "block";
    private static final String STATE_ERROR = "error";
    private static final String IMAGE_NORMAL = "/images/pc/emotion/lcfwy_cg_168_96.png";
    private static final String IMAGE_BUSY = "/images/pc/emotion/lcfwy_fm_168_96.png";
    private static final String IMAGE_BLOCK = "/images/pc/emotion/lcfwy_hm_168_96.png";
    private static final String IMAGE_ERROR = "/images/pc/emotion/lcfwy_yc_168_96.png";
    private static final String STATE = "state";
    private static final String ERRORINFO = "errorinfo";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTNDETAIL});
    }

    @Override
    protected void refreshData() {
        Map<String, String> result = this.checkState();
        String state = result.get(STATE);
        String desc = result.get(ERRORINFO);
        Image image = (Image)this.getControl("imageap");
        image.setUrl(this.getImageUrl(state));
        image.setTips(desc);
        Label stateValue = (Label)this.getControl("labelap1");
        stateValue.setText(this.getStateName(state));
        this.getView().updateView("imageap");
    }

    private String getStateName(String state) {
        switch (state) {
            case "block": {
                return ResManager.loadKDString((String)"\u8fd0\u884c\u7f13\u6162", (String)"ScheduleCardPlugin_0", (String)"bos-wf-devops", (Object[])new Object[0]);
            }
            case "busy": {
                return ResManager.loadKDString((String)"\u8fd0\u884c\u7e41\u5fd9", (String)"ScheduleCardPlugin_1", (String)"bos-wf-devops", (Object[])new Object[0]);
            }
            case "error": {
                return ResManager.loadKDString((String)"\u8fd0\u884c\u5f02\u5e38", (String)"ScheduleCardPlugin_2", (String)"bos-wf-devops", (Object[])new Object[0]);
            }
        }
        return ResManager.loadKDString((String)"\u8fd0\u884c\u6b63\u5e38", (String)"ScheduleCardPlugin_3", (String)"bos-wf-devops", (Object[])new Object[0]);
    }

    private String getImageUrl(String state) {
        String contxtPath;
        String url = contxtPath = UrlService.getDomainContextUrl();
        switch (state) {
            case "block": {
                url = url + IMAGE_BLOCK;
                break;
            }
            case "busy": {
                url = url + IMAGE_BUSY;
                break;
            }
            case "error": {
                url = url + IMAGE_ERROR;
                break;
            }
            default: {
                url = url + IMAGE_NORMAL;
            }
        }
        return url;
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control ctl = (Control)evt.getSource();
        String key = ctl.getKey();
        if (BTNDETAIL.equals(key)) {
            this.showScheduleAndAsyncMessageBoard();
        }
    }

    private void showScheduleAndAsyncMessageBoard() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("wf_schandasyncmsgsignbord");
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        this.getView().showForm(parameter);
    }

    private Map<String, String> checkState() {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!this.checkMaster()) {
            result.put(STATE, STATE_ERROR);
            result.put(ERRORINFO, ResManager.loadKDString((String)"\u4e3b\u8282\u70b9\u5f02\u5e38", (String)"ScheduleCardPlugin_4", (String)"bos-wf-devops", (Object[])new Object[0]));
            return result;
        }
        if (!this.checkExecuteState()) {
            result.put(STATE, STATE_ERROR);
            result.put(ERRORINFO, ResManager.loadKDString((String)"\u6267\u884c\u673a\u5f02\u5e38", (String)"ScheduleCardPlugin_5", (String)"bos-wf-devops", (Object[])new Object[0]));
            return result;
        }
        if (!this.checkMiddleWare()) {
            result.put(STATE, STATE_ERROR);
            result.put(ERRORINFO, ResManager.loadKDString((String)"\u4e2d\u95f4\u4ef6\u5f02\u5e38", (String)"ScheduleCardPlugin_6", (String)"bos-wf-devops", (Object[])new Object[0]));
            return result;
        }
        return this.jobCosumeState();
    }

    private Map<String, String> jobCosumeState() {
        HashMap<String, String> result = new HashMap<String, String>(2);
        List<IndicatorInfo> indicatorInfos = DevopsUtils.getWorkflowDevopsService().fetchIndicatorInfo("scheduleStatae", null);
        IndicatorInfo indicatorInfo = indicatorInfos.get(0);
        String state = (String)indicatorInfo.getDimValue();
        String dimName = indicatorInfo.getDimDisplayValue().toString();
        String describe = ResManager.loadKDString((String)"\u8fd130\u5206\u949f\u751f\u6210job\uff1a%1$s\u8fd130\u5206\u949f\u6d88\u8d39job\uff1a%2$s", (String)"ScheduleCardPlugin_7", (String)"bos-wf-devops", (Object[])new Object[]{indicatorInfo.getSpecialProperty("product") + " \n", indicatorInfo.getSpecialProperty("consume") + " \n" + dimName});
        result.put(STATE, state);
        result.put(ERRORINFO, describe);
        return result;
    }

    private boolean checkMiddleWare() {
        JSONObject jsonObject = ServerObservableUtils.getMiddlewareStatus();
        int mqResult = jsonObject.getInteger("mq");
        if (mqResult == -1) {
            return false;
        }
        int redisResult = jsonObject.getInteger("redis");
        if (redisResult == -1) {
            return false;
        }
        SchCheckResult zkResult = ServerObservableUtils.checkZkConnected();
        return zkResult.getCode() != null && zkResult.getCode() == 0;
    }

    private boolean checkExecuteState() {
        List executors = ClientObservableUtils.queryExecutorServerStatus();
        int success = 0;
        int fail = 0;
        for (ExecutorServerInfo executor : executors) {
            if (executor.getStartTime() > 0L) {
                ++success;
                continue;
            }
            ++fail;
        }
        return success != 0 || fail <= 0;
    }

    private boolean checkMaster() {
        Map serverInfo = ServerObservableUtils.getMasterServerInfo();
        return !"false".equals(serverInfo.get("isStarted").toString()) && ServerObservableUtils.isScheduleServiceStarted();
    }
}

